"use strict";
this.author = "phkb";
this.copyright = "2018 phkb";
this.description = "Allows lasers to be moved to different mounts, when docked";
this.name = "LaserArrangement";
this.licence = "CC BY-NC-SA 4.0";

this._page = 0;
this._selected = "";
this._selectedName = "";
this._multiple = 1;

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    this.$initInterface(player.ship.dockedStation);
}

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function (station) {
    this.$initInterface(station);
}

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtNewShip = function (ship, price) {
    this.$initInterface(player.ship.dockedStation);
}

//-------------------------------------------------------------------------------------------------------------
// establishes the F4 interface for switching laser mounts while docked
this.$initInterface = function $initInterface(station) {
    // can only move lasers if there is more than one mount to move them between
    // 0 = none, 1 = forward only
    if (player.ship.weaponFacings > 1) {
        station.setInterface(this.name, {
            title: expandDescription("[arrange_interface_title]"),
            category: expandDescription("[interfaces-category-ship-systems]"),
            summary: expandDescription("[arrange_interface_summary]"),
            callback: this.$showInitial.bind(this)
        });
    } else {
        station.setInterface(this.name, null);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$showInitial = function $showInitial() {
    this._page = 0;
    this._selected = "";
    this.$showPage();
}

//-------------------------------------------------------------------------------------------------------------
this.$showPage = function $showPage() {
    var p = player.ship;
    var curChoices = {};
    var text = "";
    var col1 = 10;
    var def = "99_EXIT";
    var laserName = "";
    var laserEq = "";

    var lb = worldScripts["laserBooster_worldScript.js"];

    if (this._page === 0) {
        text = expandDescription("[arrange_select_laser]") + ":\n\n";

        if (worldScripts.LMSS_Core && (p.equipmentStatus("EQ_LMSS_ACTIVATOR") === "EQUIPMENT_OK")) {
            curChoices["00_LMSS"] = {
                text: "[arrange_lmss]"
            };
        }

        if (" 1 3 5 7 9 11 13 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0) {
            text += this.$padTextRight(expandDescription("[arrange_forward]") + ": ", col1);
            laserEq = p.forwardWeapon.equipmentKey;
            laserName = p.forwardWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage["FORWARD"].primary).name + " " + expandDescription("[arrange_damaged]");

            text += (laserEq === "EQ_WEAPON_NONE" ? "--None--" : laserName + (p.weaponPositionForward.length > 1 ? " x " + p.weaponPositionForward.length : "")) + "\n";
            curChoices["01_FORWARD"] = {
                text: "[arrange_select_forward]",
                color: (laserEq === "EQ_WEAPON_NONE" ? "grayColor" : "orangeColor"),
                unselectable: (laserEq === "EQ_WEAPON_NONE" ? true : false)
            };
        }
        if (" 2 3 6 7 10 11 14 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0) {
            text += this.$padTextRight(expandDescription("[arrange_aft]") + ": ", col1);
            laserEq = p.aftWeapon.equipmentKey;
            laserName = p.aftWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage["AFT"].primary).name + " " + expandDescription("[arrange_damaged]");

            text += (laserEq === "EQ_WEAPON_NONE" ? "--None--" : laserName + (p.weaponPositionAft.length > 1 ? " x " + p.weaponPositionAft.length : "")) + "\n";
            curChoices["02_AFT"] = {
                text: "[arrange_select_aft]",
                color: (laserEq === "EQ_WEAPON_NONE" ? "grayColor" : "orangeColor"),
                unselectable: (laserEq === "EQ_WEAPON_NONE" ? true : false)
            };
        }
        if (" 4 5 6 7 12 13 14 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0) {
            text += this.$padTextRight(expandDescription("[arrange_port]") + ": ", col1);
            laserEq = p.portWeapon.equipmentKey;
            laserName = p.portWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage["PORT"].primary).name + " " + expandDescription("[arrange_damaged]");

            text += (laserEq === "EQ_WEAPON_NONE" ? "--None--" : laserName + (p.weaponPositionPort.length > 1 ? " x " + p.weaponPositionPort.length : "")) + "\n";
            curChoices["03_PORT"] = {
                text: "[arrange_select_port]",
                color: (laserEq === "EQ_WEAPON_NONE" ? "grayColor" : "orangeColor"),
                unselectable: (laserEq === "EQ_WEAPON_NONE" ? true : false)
            };
        }
        if (" 8 9 10 11 12 13 14 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0) {
            text += this.$padTextRight(expandDescription("[arrange_starboard]") + ": ", col1);
            laserEq = p.starboardWeapon.equipmentKey;
            laserName = p.starboardWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage["STARBOARD"].primary).name + " " + expandDescription("[arrange_damaged]");

            text += (laserEq === "EQ_WEAPON_NONE" ? "--None--" : laserName + (p.weaponPositionStarboard.length > 1 ? " x " + p.weaponPositionStarboard.length : "")) + "\n";
            curChoices["04_STARBOARD"] = {
                text: "[arrange_select_starboard]",
                color: (laserEq === "EQ_WEAPON_NONE" ? "grayColor" : "orangeColor"),
                unselectable: (laserEq === "EQ_WEAPON_NONE" ? true : false)
            };
        }

        curChoices["99_EXIT"] = { text: "[arrange_exit]" };
    }

    if (this._page === 1) {
        text = "Select destination for " + this._selected.toLowerCase() + " laser '" + this._selectedName + "':";
        if (" 1 3 5 7 9 11 13 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0 && p.weaponPositionForward.length === this._multiple) {
            laserEq = p.forwardWeapon.equipmentKey;
            laserName = p.forwardWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name + " " + expandDescription("[arrange_damaged]");

            if (this._selected !== "FORWARD") {
                curChoices["11_FORWARD"] = {
                    text: expandDescription("[arrange_forward_position]") + (laserEq !== "EQ_WEAPON_NONE" ? " " + expandDescription("[arrange_swap_with]", { laser: laserName + (p.weaponPositionForward.length > 1 ? " x " + p.weaponPositionForward.length : "") }) : ""),
                    color: "orangeColor"
                }
            } else {
                curChoices["11_FORWARD"] = {
                    text: "[arrange_forward_selected]",
                    color: "grayColor",
                    unselectable: true
                }
            }
        }
        if (" 2 3 6 7 10 11 14 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0 && p.weaponPositionAft.length === this._multiple) {
            laserEq = p.aftWeapon.equipmentKey;
            laserName = p.aftWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name + " " + expandDescription("[arrange_damaged]");

            if (this._selected !== "AFT") {
                curChoices["12_AFT"] = {
                    text: expandDescription("[arrange_aft_position]") + (laserEq !== "EQ_WEAPON_NONE" ? " " + expandDescription("[arrange_swap_with]", { laser: p.aftWeapon.name + (p.weaponPositionAft.length > 1 ? " x " + p.weaponPositionAft.length : "") }) : ""),
                    color: "orangeColor"
                };
            } else {
                curChoices["12_AFT"] = {
                    text: "[arrange_aft_selected]",
                    color: "grayColor",
                    unselectable: true
                };
            }
        }
        if (" 4 5 6 7 12 13 14 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0 && p.weaponPositionPort.length === this._multiple) {
            laserEq = p.portWeapon.equipmentKey;
            laserName = p.portWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name + " " + expandDescription("[arrange_damaged]");

            if (this._selected !== "PORT") {
                curChoices["13_PORT"] = {
                    text: expandDescription("[arrange_port_position]") + (laserEq !== "EQ_WEAPON_NONE" ? " " + expandDescription("[arrange_swap_with]", { laser: laserName + (p.weaponPositionPort.length > 1 ? " x " + p.weaponPositionPort.length : "") }) : ""),
                    color: "orangeColor"
                };
            } else {
                curChoices["13_PORT"] = {
                    text: "[arrange_port_selected]",
                    color: "grayColor",
                    unselectable: true
                };
            }
        }
        if (" 8 9 10 11 12 13 14 15 ".indexOf(" " + p.weaponFacings.toString() + " ") >= 0 && p.weaponPositionStarboard.length === this._multiple) {
            laserEq = p.starboardWeapon.equipmentKey;
            laserName = p.starboardWeapon.name;
            if (lb && laserEq == lb._damagedEq) laserName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name + " " + expandDescription("[arrange_damaged]");

            if (this._selected !== "STARBOARD") {
                curChoices["14_STARBOARD"] = {
                    text: expandDescription("[arrange_starboard_position]") + (laserEq !== "EQ_WEAPON_NONE" ? " " + expandDescription("[arrange_swap_with]", { laser: laserName + (p.weaponPositionStarboard.length > 1 ? " x " + p.weaponPositionStarboard.length : "") }) : ""),
                    color: "orangeColor"
                };
            } else {
                curChoices["14_STARBOARD"] = {
                    text: "[arrange_starboard_selected]",
                    color: "grayColor",
                    unselectable: true
                };
            }
        }
        curChoices["98_CANCEL"] = { text: "[arrange_cancel]" };
        curChoices["99_EXIT"] = { text: "[arrange_exit]" };
    }

    var opts = {
        screenID: "oolite-la-dockside-map",
        title: expandDescription("[arrange_screen_title]"),
        allowInterrupt: true,
        exitScreen: "GUI_SCREEN_INTERFACES",
        overlay: {
            name: "la-arrow.png",
            height: 546
        },
        choices: curChoices,
        initialChoicesKey: def,
        message: text
    };
    mission.runScreen(opts, this.$screenHandler, this);
}

//-------------------------------------------------------------------------------------------------------------
this.$screenHandler = function $screenHandler(choice) {
    if (choice == null) return;

    var p = player.ship;
    var lb = worldScripts["laserBooster_worldScript.js"];

    switch (choice) {
        case "00_LMSS":
            worldScripts.LMSS_Core.$showLMSSList();
            return;
        case "01_FORWARD":
            this._selected = "FORWARD";
            this._selectedName = p.forwardWeapon.name;
            if (lb && this._selectedName == lb._damagedEq) this._selectedName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name;
            this._multiple = p.weaponPositionForward.length;
            this._page = 1;
            break;
        case "02_AFT":
            this._selected = "AFT";
            this._selectedName = p.aftWeapon.name;
            if (lb && this._selectedName == lb._damagedEq) this._selectedName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name;
            this._multiple = p.weaponPositionAft.length;
            this._page = 1;
            break;
        case "03_PORT":
            this._selected = "PORT";
            this._selectedName = p.portWeapon.name;
            if (lb && this._selectedName == lb._damagedEq) this._selectedName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name;
            this._multiple = p.weaponPositionPort.length;
            this._page = 1;
            break;
        case "04_STARBOARD":
            this._selected = "STARBOARD";
            this._selectedName = p.starboardWeapon.name;
            if (lb && this._selectedName == lb._damagedEq) this._selectedName = EquipmentInfo.infoForKey(lb._holdDamage[this._selected].primary).name;
            this._multiple = p.weaponPositionStarboard.length;
            this._page = 1;
            break;
        case "11_FORWARD":
            var hold = "EQ_WEAPON_NONE";
            var from = "FORWARD";
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = true;
            if (p.forwardWeapon.equipmentKey !== "EQ_WEAPON_NONE") hold = p.forwardWeapon.equipmentKey;
            switch (this._selected) {
                case "AFT":
                    p.forwardWeapon = p.aftWeapon.equipmentKey;
                    p.aftWeapon = hold;
                    break;
                case "PORT":
                    p.forwardWeapon = p.portWeapon.equipmentKey;
                    p.portWeapon = hold;
                    break;
                case "STARBOARD":
                    p.forwardWeapon = p.starboardWeapon.equipmentKey;
                    p.starboardWeapon = hold;
                    break;
            }
            if (lb) lb.$transferPrimaryLaser(this._selected, from);
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = false;
            this._selected = "";
            this._page = 0;
            break;
        case "12_AFT":
            var hold = "EQ_WEAPON_NONE";
            var from = "AFT";
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = true;
            if (p.aftWeapon.equipmentKey !== "EQ_WEAPON_NONE") hold = p.aftWeapon.equipmentKey;
            switch (this._selected) {
                case "FORWARD":
                    p.aftWeapon = p.forwardWeapon.equipmentKey;
                    p.forwardWeapon = hold;
                    break;
                case "PORT":
                    p.aftWeapon = p.portWeapon.equipmentKey;
                    p.portWeapon = hold;
                    break;
                case "STARBOARD":
                    p.aftWeapon = p.starboardWeapon.equipmentKey;
                    p.starboardWeapon = hold;
                    break;
            }
            if (lb) lb.$transferPrimaryLaser(this._selected, from);
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = false;
            this._selected = "";
            this._page = 0;
            break;
        case "13_PORT":
            var hold = "EQ_WEAPON_NONE";
            var from = "PORT";
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = true;
            if (p.portWeapon.equipmentKey !== "EQ_WEAPON_NONE") hold = p.portWeapon.equipmentKey;
            switch (this._selected) {
                case "FORWARD":
                    p.portWeapon = p.forwardWeapon.equipmentKey;
                    p.forwardWeapon = hold;
                    break;
                case "AFT":
                    p.portWeapon = p.aftWeapon.equipmentKey;
                    p.aftWeapon = hold;
                    break;
                case "STARBOARD":
                    p.portWeapon = p.starboardWeapon.equipmentKey;
                    p.starboardWeapon = hold;
                    break;
            }
            if (lb) lb.$transferPrimaryLaser(this._selected, from);
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = false;
            this._selected = "";
            this._page = 0;
            break;
        case "14_STARBOARD":
            var hold = "EQ_WEAPON_NONE";
            var from = "AFT";
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = true;
            if (p.starboardWeapon.equipmentKey !== "EQ_WEAPON_NONE") hold = p.starboardWeapon.equipmentKey;
            switch (this._selected) {
                case "FORWARD":
                    p.starboardWeapon = p.forwardWeapon.equipmentKey;
                    p.forwardWeapon = hold;
                    break;
                case "AFT":
                    p.starboardWeapon = p.aftWeapon.equipmentKey;
                    p.aftWeapon = hold;
                    break;
                case "PORT":
                    p.starboardWeapon = p.portWeapon.equipmentKey;
                    p.portWeapon = hold;
                    break;
            }
            if (lb) lb.$transferPrimaryLaser(this._selected, from);
            if (worldScripts.LMSS_Core) worldScripts.LMSS_Core._switching = false;
            this._selected = "";
            this._page = 0;
            break;
        case "98_CANCEL":
            this._selected = "";
            this._page = 0;
            break;
    }

    if (choice != "99_EXIT") {
        this.$showPage();
    }
}

//-------------------------------------------------------------------------------------------------------------
// appends space to currentText to the specified length in 'em'
this.$padTextRight = function $padTextRight(currentText, desiredLength, leftSwitch) {
	if (currentText == null) currentText = "";
	var space = " ";
	var hairSpace = String.fromCharCode(31);
	var ellip = "…";
	var currentLength = defaultFont.measureString(currentText.replace(/%%/g, "%"));
	var hairSpaceLength = defaultFont.measureString(hairSpace);
	var spaceLength = defaultFont.measureString(space);
	// calculate number needed to fill remaining length
	var spacesNeeded = parseInt(Math.floor((desiredLength - currentLength) / spaceLength));
	if (spacesNeeded < 0) {
		spacesNeeded = 0;
	} else {
		if (!leftSwitch || leftSwitch === false) {
			currentText += new Array(spacesNeeded).join(space);
		} else {
			currentText = new Array(spacesNeeded).join(space) + currentText;
		}
		currentLength = defaultFont.measureString(currentText.replace(/%%/g, "%"));
	}
	var padsNeeded = Math.floor((desiredLength - currentLength) / hairSpaceLength);
	if (padsNeeded < 1) {
		// text is too long for column, so start pulling characters off
		var tmp = currentText;
		do {
			tmp = tmp.substring(0, tmp.length - 2) + ellip;
			if (tmp === ellip) break;
		} while (defaultFont.measureString(tmp.replace(/%%/g, "%")) > desiredLength);
		currentLength = defaultFont.measureString(tmp.replace(/%%/g, "%"));
		padsNeeded = Math.floor((desiredLength - currentLength) / hairSpaceLength);
		currentText = tmp;
	}
	// quick way of generating a repeated string of that number
	if (!leftSwitch || leftSwitch === false) {
		return currentText + new Array(padsNeeded).join(hairSpace);
	} else {
		return new Array(padsNeeded).join(hairSpace) + currentText;
	}
}
