"use strict";

/* ========================================================
		SCREEN BACKGROUND DEMONSTRATION OXP

Created by Karl Smith ("Wildeblood"), April 8th, 2024.

Here I was just learning the difference between the methods
setScreenBackground() and setScreenBackgroundForKey()
=========================================================== */

    this.name = "DemoScreenBackground";

    this.alertConditionChanged = function (newAlert) {
        if (newAlert == 1) {
            setScreenBackgroundForKey("status_in_flight", { name: "distant_space_status_green.png", height: 512 });
            if (guiScreen == "GUI_SCREEN_STATUS") {
                setScreenBackground({ name: "distant_space_status_green.png", height: 512 });
            }
        } else if (newAlert == 2) {
            setScreenBackgroundForKey("status_in_flight", { name: "distant_space_status_orange.png", height: 512 });
            if (guiScreen == "GUI_SCREEN_STATUS") {
                setScreenBackground({ name: "distant_space_status_orange.png", height: 512 });
            }
        }
    };

    this.startUpComplete = function () {
        setScreenBackgroundForKey("status_in_flight", { name: "distant_space_status_orange.png", height: 512 });
        setScreenBackgroundForKey("status_red_alert", { name: "distant_space_status_red.png", height: 512 });
        setScreenBackgroundForKey("status_docked",    { name: "distant_space_status_blue.png", height: 512 });
        if (player.ship.docked && guiScreen == "GUI_SCREEN_STATUS") {
            setScreenBackground({ name: "distant_space_status_blue.png", height: 512 });
        }
        delete this.startUpComplete;
    };

/* ========================================================

https://wiki.alioth.net/index.php/Oolite_JavaScript_Reference:_Global#getScreenBackgroundForKey
https://wiki.alioth.net/index.php/Oolite_JavaScript_Reference:_Global#setScreenBackground
https://wiki.alioth.net/index.php/Oolite_JavaScript_Reference:_Global#setScreenBackgroundForKey
https://wiki.alioth.net/index.php/Screenbackgrounds.plist

=========================================================== */