"use strict";
this.name = "BountySystem_NPCScan";
this.author = "phkb";
this.copyright = "2016 phkb";
this.description = "Routines for NPC's using the Warrant scanning";
this.licence = "CC BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.$initialiseTimer = function (overrideFreq) {
	this.ship.script._debugNPCScan = false;
	this.ship.script._loggingLevel = 2;
	this.ship.script._rangeCheck = 0;

	// grab the scan time and range from the equipment info record
	// but only do this once - once we have the numbers we don't need to look them up again.
	if (!this.ship.script._warrantScannerTime) {
		if (this.ship.equipmentStatus("EQ_WARRANT_SCANNER") === "EQUIPMENT_OK")
			var eq = EquipmentInfo.infoForKey("EQ_WARRANT_SCANNER");
		if (this.ship.equipmentStatus("EQ_WARRANT_SCANNER_POLICE") === "EQUIPMENT_OK")
			var eq = EquipmentInfo.infoForKey("EQ_WARRANT_SCANNER_POLICE");

		if (eq) {
			this.ship.script._warrantScannerTime = eq.scriptInfo.scan_time;
			this.ship.script._warrantScannerRange = this.ship.scannerRange * eq.scriptInfo.scan_range;
			this.ship.script._warrantScannerFrequency = eq.scriptInfo.npc_scan_frequency;
		}
	}

	if ((overrideFreq != null && isNaN(overrideFreq) === false) || isNaN(this.ship.script._warrantScannerFrequency) === false) {
		// run a timer so that, at regular intervals, the NPC ship will consider doing a warrant scan
		this.ship.script._checkTimer = new Timer(this, this.ship.script.$checkScannerForTarget, (overrideFreq == null ? this.ship.script._warrantScannerFrequency : overrideFreq), 0);
		if (!this.ship.script._scannedList) this.ship.script._scannedList = [];
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$checkScannerForTarget = function $checkScannerForTarget() {

	// make sure we're still a valid entity
	if (!this.ship.isValid || !this.ship.isInSpace) return;

	// if we don't have the scanner or its damaged, we don't go any further
	if (this.ship.equipmentStatus("EQ_WARRANT_SCANNER") != "EQUIPMENT_OK" && this.ship.equipmentStatus("EQ_WARRANT_SCANNER_POLICE") != "EQUIPMENT_OK") {
		//log(this.name, "!NOTE: Warrant Scanner equipment failure");
		return;
	}
	// the ship needs a valid AI to work
	if (this.ship.AIScript.name === "Null AI") return;

	// free up the ship's target if it's still on the last target and we aren't fighting it
	//if (this.ship.script._lastTarget && this.ship.script._lastTarget === this.ship.target && this.ship.hasHostileTarget === false) this.ship.target = null;

	// if the ship already has a target don't do anything
	/*if (this.ship.target && this.ship.target != this.ship.script._checkTarget) {
		if (this.ship.script._debugNPCScan && this.ship.script._loggingLevel > 1) log(this.name, "ship already has target (" + this.ship.target + ") :" + this.ship);
		this.ship.script.$initialiseTimer();
		return;
	}*/

	// don't do it under red alert condition
	if (this.ship.alertCondition === 3) {
		if (this.ship.script._debugNPCScan && this.ship.script._loggingLevel > 1) log(this.name, "ship is under attack :" + this.ship);
		this.ship.script.$initialiseTimer();
		return;
	}

	// random chance that the ship won't initiate a scan: 20% for police, 50% for bounty hunters
	if ((this.ship.isPolice && Math.random() > 0.8) || Math.random() > 0.5) {
		if (this.ship.script._debugNPCScan && this.ship.script._loggingLevel > 1) log(this.name, "ship decides not to scan :" + this.ship);
		this.ship.script.$initialiseTimer(15);
		return;
	}

	// get a list of ships
	var ships = this.ship.checkScanner(true);

	// if there's no ships in range, try again later
	if (!ships || ships.length === 0) {
		this.ship.script.$initialiseTimer();
		return;
	}

	for (var i = 0; i < ships.length; i++) {
		var found = false;
		if (this.ship.isPolice) {
			// police will only scan clean ships, and they won't scan pirates - they already know to attack them!
			if (ships[i].status === "STATUS_IN_FLIGHT" && ships[i].bounty === 0 && (Ship.roleIsInCategory(ships[i].primaryRole, "oolite-assassin") || Ship.roleIsInCategory(ships[i].primaryRole, "oolite-trader") || ships[i].isPlayer) && this.ship.script._scannedList.indexOf(ships[i]) === -1) {
				found = true;
			}
		} else {
			// bounty hunters will scan pirates, looking to maximise their profits
			if (ships[i].status === "STATUS_IN_FLIGHT" && (Ship.roleIsInCategory(ships[i].primaryRole, "oolite-pirate") || Ship.roleIsInCategory(ships[i].primaryRole, "oolite-assassin") || Ship.roleIsInCategory(ships[i].primaryRole, "oolite-trader") || ships[i].isPlayer) && this.ship.script._scannedList.indexOf(ships[i]) === -1) {
				found = true;
			}
		}
		if (found === true) {
			// we have a winner!
			if (this.ship.script._debugNPCScan && this.ship.script._loggingLevel >= 1) log(this.name, "scan target selected :" + this.ship);
			if (this.ship.script._debugNPCScan && this.ship.script._loggingLevel >= 1) log(this.name, "target selected = " + ships[i]);
			//this.ship.target = ships[i];
			this.ship.script._checkTarget = ships[i];
			this.ship.script._scanPass = 0;
			this.ship.script._warrantScannerTimer = new Timer(this, this.ship.script.$scanTarget, 1, 1);
			return;
		}
	}
	this.ship.script.$initialiseTimer();
}

//-------------------------------------------------------------------------------------------------------------
this.$scanTarget = function $scanTarget() {
	var that = $scanTarget; // pointer to this function
	var core = (that.core = that.core || worldScripts.BountySystem_Core); // cache worldScript reference in local property on this function
	var w = (that.w = that.w || worldScripts.BountySystem_WarrantScanner); // cache worldScript reference in local property on this function
	var npcscan = (that.npcscan = that.npcscan || worldScripts.BountySystem_NPCScan); // cache worldScript reference in local property on this function
	var bcc = (that.bcc = that.bcc || worldScripts.BroadcastCommsMFD); // cache worldScript reference in local property on this function
	var myShip = this.ship,
		myScript = myShip.script,
		myTarget = myScript._checkTarget;
	if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "running scanTarget :" + myShip);
	// make sure ship is valid
	if (!myShip.isValid) {
		myScript._warrantScannerTimer.stop();
		return;
	}
	if (myShip.alertCondition === 3) {
		// ship is in a battle
		if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "ship in red alert - cancelling scan :" + myShip);
		myScript._warrantScannerTimer.stop();
		myTarget = null;
		myScript.$initialiseTimer();
		return;
	}
	if (myTarget.hasEquipmentProviding("EQ_MILITARY_JAMMER")) {
		// this device stops scans from happening
		myScript._warrantScannerTimer.stop();
		return;
	}
	/*if (myShip.target != myTarget || !myTarget.isValid) {
		// somethings happened and their target has switched
		if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "target has shifted - cancelling scan :" + myShip);
		myScript._warrantScannerTimer.stop();
		myTarget = null;
		myScript.$initialiseTimer();
		return;
	}*/
	// is target still valid
	var result = w.$targetIsValid(myShip);
	if (result) {
		// are we in range?
		if (w.$targetInRange(myShip)) {
			myScript._rangeCheck = 0;
			if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "scanning ship (" + myTarget + ") :" + myShip);
			// ok, do a pass
			myScript._scanPass += 1;
			if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "pass " + this._scanPass + " :" + myShip);
			if (myScript._scanPass === 1 && myTarget.isPlayer) player.consoleMessage(expandDescription("[warrant-scan-detected]"), 5);
			if (myScript._scanPass === 2 && myTarget.isPlayer === false) w.$npcReaction(myTarget, myShip);
			// are we done?
			if (myScript._scanPass >= myScript._warrantScannerTime) {
				myScript._warrantScannerTimer.stop();
				if (!myTarget.isPlayer || !core._alreadyScannedPlayerInThisSystem) { // only apply out-of-system bounties to the player once per system visit
					if (myTarget.isPlayer) core._alreadyScannedPlayerInThisSystem = true; // remember that we did this
					// ok, get the hidden bounty;
					if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "scan complete :" + myShip);
					myScript._scannedList.push(myTarget);

					var initial = myTarget.bounty;
					var check = w.$checkBounty(myTarget, true, myShip); // returns sum of out-of-system bounties and imports any transferable bounties to the current system (this affects the calculation in shipWillDockWithStation that sets player bounty)
					if (check > 0) { // an out-of-system bounty was found
						if (myTarget.isPlayer && bcc && bcc._surrenderBounty > 0) { // player has a hidden bounty after surrendering to police with Broadcast Comms
							bcc._surrenderBounty += check; // add bounty amount to Broadcast Comms' "hidden" value to be restored if the player commits another crime or doesn't go to the station
							if (myScript._debugNPCScan && myScript._loggingLevel >= 1) log(this.name, "bounty of " + check + " added to Broadcast Comms' hidden bounty value for surrendered " + myTarget);
						} else { // apply the bounty directly
							myTarget.bounty += check;
							if (myScript._debugNPCScan && myScript._loggingLevel >= 1) log(this.name, "bounty change of " + (myTarget.bounty - initial) + " for " + myTarget);
						}
					}
				}

				// add this target to all vessels in range who have the same scan class
				npcscan.$addTargetToScannedList(myShip, myTarget); // call to worldScript function from ship-attached script

				myScript._lastTarget = myTarget;
				myTarget = null;
				myScript.$initialiseTimer();
			}
		} else {
			myScript._rangeCheck += 1;
			// try to move in range of target so we can continue scanning
			if (myShip.position.distanceTo(myTarget) < (myShip.scannerRange * 1.3) && myScript._rangeCheck < 30) {
				if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "attempting to get in range :" + myShip);
				myShip.destination = myTarget.position;
				myShip.desiredRange = myScript._warrantScannerRange - parseInt(Math.random * 1000) + 200;
				myShip.desiredSpeed = myShip.maxSpeed;
			} else {
				// give up if the distance is too great, or the range check counter times out
				if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "unable to get in range of target (timeout or distance too far) :" + myShip);
				myScript._warrantScannerTimer.stop();
				//myShip.target = null;
				myTarget = null;
				myScript.$initialiseTimer();
			}
		}
	} else {
		if (myScript._debugNPCScan && myScript._loggingLevel > 1) log(this.name, "target no longer valid :" + myShip);
		myScript._warrantScannerTimer.stop();
		//myShip.target = null;
		myTarget = null;
		myScript.$initialiseTimer();
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$addTargetToScannedList = function (source, target) {
	var ships = source.checkScanner(true);
	for (var i = 0; i < ships.length; i++) {
		if (ships[i].scanClass === source.scanClass && (ships[i].equipmentStatus("EQ_WARRANT_SCANNER") === "EQUIPMENT_OK" || ships[i].equipmentStatus("EQ_WARRANT_SCANNER_POLICE") === "EQUIPMENT_OK")) {
			ships[i].script._scannedList.push(target);
		}
	}
}