"use strict";
this.name        = "BountySystem_Conditions";
this.author      = "phkb";
this.copyright   = "2020 phkb";
this.description = "Condition script for determining when items are available";
this.licence     = "CC BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function(equipment, ship, context) {
    if (context === "scripted") return true;
    var p = player.ship;
    switch (equipment) {
        case "EQ_WARRANT_SCANNER":
            if (p.equipmentStatus("EQ_WARRANT_SCANNER_PASSIVE") != "EQUIPMENT_UNAVAILABLE") return false;
            break;
        case "EQ_WARRANT_SCANNER_PASSIVE":
            if (p.equipmentStatus(equipment) === "EQUIPMENT_DAMAGED") return true;
            return false;
    }
    return true;
}