"use strict";
this.name = "BountySystem_Book";
this.author = "phkb";
this.description = "Adds the Bounty System Handbook to the Ship's Library";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    if (worldScripts["Ships Library"]) this._registerBook();
}

//-------------------------------------------------------------------------------------------------------------
this._registerBook = function () {
    var contents = [
        { level: 0, key: "bountyinfo_intro" },
        { level: 1, key: "bountyinfo_chap1" },
        { level: 1, key: "bountyinfo_chap2" },
        { level: 1, key: "bountyinfo_chap3" },
        { level: 1, key: "bountyinfo_chap4" },
        { level: 1, key: "bountyinfo_chap5" },
        { level: 1, key: "bountyinfo_chap6" },
        { level: 1, key: "bountyinfo_chap7" },
    ];
    if (worldScripts.BountySystem_Core._deferredBounties.enabled) {
        contents.push({ level: 1, key: "bountyinfo_chap8", params: [function() { 
            if (worldScripts.BountySystem_Core._deferredBounties.range > 0)
                return expandMissionText("bountyinfo_deferred_range", {range: worldScripts.BountySystem_Core._deferredBounties.range});
            else 
                return "";
        }] });
    }
    contents.push({ level: 1, key: "bountyinfo_appendix" });

    worldScripts["Ships Library"]._registerBook("bounty_system", expandMissionText("bountyinfo_title"), contents, 22);
}
