"use strict";
this.name = "silicone_equipment";
this.author = "phkb";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Equipment script for silicone sealant.";

//-------------------------------------------------------------------------------------------------------------
this.activated = function() {
    var p = player.ship;
    if (p.fuelLeakRate == 0) {
        player.consoleMessage("No fuel leak detected."); 
        return;
    }
    p.removeEquipment("EQ_SILICONE_SEALANT");
    var sc = worldScripts.silicone_equipment;
    sc._holdLeakRate = p.fuelLeakRate;
    p.fuelLeakRate = 0;
    this.$playSound("silicone");
    player.consoleMessage("Fuel leak has been plugged.");
    sc._timer = new Timer(sc, sc.$siliconeFail, Math.random() * 200 + 30);
}

//-------------------------------------------------------------------------------------------------------------
this.$siliconeFail = function $siliconeFail() {
    this.$playSound("leak");
    player.ship.fuelLeakRate = this._holdLeakRate + (Math.random() > 0.5 ? 0.03 : 0);

}

//-------------------------------------------------------------------------------------------------------------
this.playerBoughtEquipment = function(equipKey) {
    if (equipKey == "EQ_SILICONE_SEALANT") {
        // buying one means your buying 5 applications
        for (var i = 1; i <= 4; i++) {
            player.ship.awardEquipment("EQ_SILICONE_SEALANT");
        }
        player.consoleMessage("Purchased 5 silicone sealants");
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipDockedWithStation = function() {
    if (this._timer && this._timer.isRunning) this._timer.stop();
}

//-------------------------------------------------------------------------------------------------------------
// plays the hydraulic sound of the silicone sealant being applied
this.$playSound = function $playSound(type) {
	var mySound = new SoundSource;
    switch (type) {
        case "silicone":
            mySound.sound = "silicone_application.ogg";
            break;
        case "leak":
            mySound.sound = "[fuel-leak]";
            break;
    }
	mySound.loop = false;
	mySound.play();
}
