"use strict";
this.name = "BountySystem_Deferred";
this.author = "phkb";
this.copyright = "2024 phkb";
this.description = "Defers bounty payments and Elite ranking for Security Office visit";
this.license = "CC BY-NC-SA 4.0";

/*
    This script makes the assumption that player.credits and player.score will only change when the player destroys a ship
    If there are examples of credits or score changing for another reason while in flight, (eg completing a mission), exceptions will need to be added.
*/

this._deferred = {};
this._hold = {};

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
    if (missionVariables.BountySystem_Deferred) {
        this._deferred = JSON.parse(missionVariables.BountySystem_Deferred);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function () {
    if (!worldScripts.BountySystem_Core._deferredBounties.enabled) {
        delete this.shipKilledOther;
        return;
    }
    this.shipKilledOther = this.shipKilledOther_hold;
    this.$setPlayerBaseline();
}

//-------------------------------------------------------------------------------------------------------------
this.shipKilledOther_hold = function (whom, damageType) {
    if (!player.ship || !player.ship.isValid) return;
    if (!player.ship.isInSpace) return;
    // check for changes in credits or bounties
    if (player.credits != this._hold.credits) { // || player.score != this._hold.score) {
        this.$addEntry();
        this._deferred[galaxyNumber + " " + system.ID].push(
            {
                ship:whom.displayName, 
                credits:(player.credits - this._hold.credits)
            }
        );
        player.credits = this._hold.credits;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
    missionVariables.BountySystem_Deferred = JSON.stringify(this._deferred);
}

//-------------------------------------------------------------------------------------------------------------
this.$addEntry = function () {
    if (!this._deferred[galaxyNumber + " " + system.ID]) {
        this._deferred[galaxyNumber + " " + system.ID] = [];
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$setPlayerBaseline = function() {
    this._hold.credits = player.credits;
}

//-------------------------------------------------------------------------------------------------------------
this.$checkScope = function() {
    var list = [];
    var keys = Object.keys(this._deferred);
    var range = worldScripts.BountySystem_Core._deferredBounties.range;
	for (var i = 0; i < keys.length; i++) {
		var subs = keys[i].split(" ");
		if (parseInt(subs[0]) == galaxyNumber) {
			if (this._deferred[keys[i]].length == 0) continue;
			if (parseInt(subs[1]) == system.ID || range == 3) list.push(keys[i]);
			else {
				var sys = System.infoForSystem(galaxyNumber, parseInt(subs[1]));
				var dist = system.info.distanceToSystem(sys);
				switch (range) {
					case 1: 
						if (dist <= 7) list.push(keys[i]);
						break;
					case 2: 
						if (dist <= 25) list.push(keys[i]);
						break;
				}
			}
		}
	}
	return list;
}

//-------------------------------------------------------------------------------------------------------------
this.$clearData = function() {
    var keys = Object.keys(this._deferred);
    var range = worldScripts.BountySystem_Core._deferredBounties.range;
    for (var i = 0; i < keys.length; i++) {
        var subs = keys[i].split(" ");
        if (parseInt(subs[0]) != galaxyNumber) continue;
        if (parseInt(subs[1]) == system.ID || range == 3) this._deferred[keys[i]].length = 0;
        else {
            var sys = System.infoForSystem(galaxyNumber, parseInt(subs[1]));
            var dist = system.info.distanceToSystem(sys);
            switch (range) {
                case 1: 
                    if (dist <= 7) this._deferred[keys[i]].length = 0;
                    break;
                case 2: 
                    if (dist <= 25) this._deferred[keys[i]].length = 0;
                    break;
            }
        }
    }
}