this.name			= "pilot_license";
this.author			= "Redspear";
this.copyright		= "2024 Redspear";
this.licence		= "CC BY-NC-SA 4.0"; 
this.description	= "Player progression according to elite rating";
this.version		= "1.2";

"use strict";

this.startUpComplete = function ()
{
	// for new (or combat shy) commanders only
		_screen = 0; 
}

this.guiScreenChanged = function ()
{		
		// check for (mostly) new player start
		if (guiScreen != "GUI_SCREEN_MISSION" && player.score === 0 && _screen === 0) {
			player.ship.awardEquipment("EQ_LICENCE_1");
			_screen = 1;
			player.replaceShip("adder-player");	//	good luck!
			player.ship.forwardWeapon = "EQ_WEAPON_BEAM_LASER";	// as per elite manual, don't you know...
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon successfully completing the Galactic Co-operative of Worlds Space and Interstellar Pilot's Examination.\n\nGalCop acknowledges your designation as : ...TRAINEE 3rd CLASS\n\nYou are now licensed to fly the Outworld Workshops ADDER class vessel.\n\nWe wish you luck in your new career.\n\n\nIvor Lavalamp\n\nPromotions Officer\nGalCop Federal Law Center"
					});				
			}
}

this.shipWillDockWithStation = function()
{	
		// check for promotion
		if (player.score >= 8 && player.ship.equipmentStatus("EQ_LICENCE_1") === "EQUIPMENT_OK") {
			_screen = 2;
		}
		if (player.score >= 16 && player.ship.equipmentStatus("EQ_LICENCE_2") === "EQUIPMENT_OK") {
			_screen = 3;
		}
		if (player.score >= 32 && player.ship.equipmentStatus("EQ_LICENCE_3") === "EQUIPMENT_OK") {
			_screen = 4;
		}
		if (player.score >= 64 && player.ship.equipmentStatus("EQ_LICENCE_4") === "EQUIPMENT_OK") {
			_screen = 5;
		}
		if (player.score >= 128 && player.ship.equipmentStatus("EQ_LICENCE_5") === "EQUIPMENT_OK") {
			_screen = 6;
		}
		if (player.score >= 256 && player.ship.equipmentStatus("EQ_LICENCE_6") === "EQUIPMENT_OK") {
			_screen = 7;
		}
		if (player.score >= 512 && player.ship.equipmentStatus("EQ_LICENCE_7") === "EQUIPMENT_OK") {
			_screen = 8;
		}
		if (player.score >= 2560 && player.ship.equipmentStatus("EQ_LICENCE_8") === "EQUIPMENT_OK") {
			_screen = 9;
		}
		if (player.score >= 6400 && player.ship.equipmentStatus("EQ_LICENCE_9") === "EQUIPMENT_OK") {
			_screen = 10;
		}
}

this.shipDockedWithStation = function (station)
{ 	
		// apply promotions
		if (station.isMainStation) {
			if (_screen === 2) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the combat rank of MOSTLY HARMLESS.\nThe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... TRAINEE 2nd CLASS\n\nYou are now licensed to fly vessels equipped with Fuel Scoops and/or a Cargo Bay Extension.\n\n\nBetsy Baskerville-Ramsbottom\n\nTS ComDirect Representative\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_1");	
				player.ship.awardEquipment("EQ_LICENCE_2");
			}
			if (_screen === 3) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the comabat rank of POOR.\nThe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... TRAINEE 1st CLASS\n\nIn addition to being licensed to fly the Paynou, Prossett & Salem. COBRA Mk I Trader, you are also licensed to equip the Advanced Space Compass.\n\n\nGespacho 'Parking Meter' Smith\n\nActing Security Officer\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_2");	
				player.ship.awardEquipment("EQ_LICENCE_3");
			}
			if (_screen === 4) {
				mission.runScreen ({
					titleKey: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the combat rank of AVERAGE.\nThe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... PILOT 3rd CLASS\n\nYou are now licensed to fly vessels equipped with an Extra Energy Unit and/or a Passenger Berth.\n\n\nDave 'Fancy Pants' McTreeoid\n\nLocal Head of Promotions\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_3");	
				player.ship.awardEquipment("EQ_LICENCE_4");
			}
			if (_screen === 5) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the combat rank of ABOVE AVERAGE.\nthe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... PILOT 2nd CLASS\n\nIn addition to being licensed to fly the Marine Trench Company MORAY class vessel, you are also licensed to equip an Advanced Navigation Array.\n\n\nDoris 'The Real Deal' Johnson\n\nTS ComDirect Officer\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_4");	
				player.ship.awardEquipment("EQ_LICENCE_5");
			}
			if (_screen === 6) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the rank of COMPETENT.\nThe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... PILOT 1st CLASS\n\nYou are now licensed to fly vessels equipped with a Wormhole Scanner and/or a Galactic Hyperdrive. We wish you continued success.\n\n\nArchibald Soylent-Beeblebrox\n\n%H Security Officer\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_5");	
				player.ship.awardEquipment("EQ_LICENCE_6");
			}
			if (_screen === 7) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nIn recognition of your continued success in combat, as recorded by TS ComDirect, you are henceforce recognised as... WARRANT OFFICER\n\nThe Galactic Co-operative of Worlds congratulates you on this significant achievement.\n\nYou are now licensed to fly the Faulcon deLacy COBRA Mk III trading and combat craft. Additionally, some systems may grant permission to fly PYTHON class vessels.\n\n\nSpork Skywalker-Smith\n\nSecretary\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_6");	
				player.ship.awardEquipment("EQ_LICENCE_7");
			}
			if (_screen === 8) {
				mission.runScreen ({
					titleKey: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the rank of DANGEROUS.\nThe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... FLIGHT OFFICER\n\nWe hope that you be working more closely with us in future.\n\nYou are now licensed to fly the Zorgun Petterson Group FER DE LANCE class vessel. Some systems may also recognise your qualification to fly the BOA Mk I freighter.\n\n\nHumperdink O'Ryder\n\nGovernor\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_7");	
				player.ship.awardEquipment("EQ_LICENCE_8");
			}
			if (_screen === 9) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the rank of DEADLY.\nThe Galactic Co-operative of Worlds is pleased to inform you that you pilot's licence has been upgraded to... CAPTAIN\n\nAdditionally the Galactic Navy would like to pass on their congratulations and recognise you as an 'Ace' Pilot.\nYou are now licensed to fly the GalCop ASP Mk II fighter transport. Further, Beerbaum & ThruSpace Incorporated recognise your abilty to pilot an ANACONDA freighter.\n\n\nArbuthnot Ponsonby-Smythe\n\nBrigadier\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_8");	
				player.ship.awardEquipment("EQ_LICENCE_9");
			}
			if (_screen === 10) {
				mission.runScreen ({
					title: "Congratulations Commander",
					music: "handy-introduction-022-glbml-21786.ogg",
					message: "\nCongratulations upon achieving the rank of ELITE.\nIn recognition of an outstanding combat record, you are now one of the very few to have their Pilot's Licence upgraded to... COMMODORE\n\nYou are now considered to be one of the most capable combateers in the galaxy.\nMay our purposes always align Captain.\n\nYou are now licensed to fly the Gerege Federation Space Works BOA Mk II cruiser. We trust that she will serve you well.\n\n\nLord Ernest 'Martini' Flange-Bracket\n\nSector Commander\nGalCop Federal Law Center"
					});
				player.ship.removeEquipment("EQ_LICENCE_9");	
				player.ship.awardEquipment("EQ_LICENCE_10");
			}
		}
}