/* ========================================================
			EXPLORERS' CLUB OXP

Created by Karl Smith ("Wildeblood"), June, 2013.
Based on an earlier work of the same name:- 

author:      "Capt. Murphy"
copyright:   2011, 2012 Steve Murphy
licence:     "CC BY-NC-SA 3.0"
description: Worldscript to record unique systems visited.

Reviewed January, 2024, using Oolite 1.91. 
It hasn't broken yet, despite all the changes to Oolite. 
We must have done something right.
=========================================================== */

this.name    = "Explorers Club"; 
this.version = "1.4.6";

/* ========================================================
			FUNCTIONS TO RECORD VISITS

 Check to see if new system has already been visited,
 and if not, add it to the record array.
=========================================================== */

    this._recordVisit = function () {
        "use strict";
        if (this.$xc_record[galaxyNumber].indexOf(system.ID) === -1) {
            this.$xc_record[galaxyNumber].push(system.ID);
            return true;
        } else {
            return false;
        }
    }

    // Visiting option 1, default mode.

    this.shipWillDockWithStation = function (station) {
        "use strict";
        if (this.$xc_visitOption === 1 &&
            station.isMainStation) {
            this._recordVisit();
        }
    }

    // Visiting option 2, easy mode.

    this.shipExitedWitchspace = function () {
        "use strict";
        if (system.isInterstellarSpace) {
            return;
        }
        if (this.$xc_visitOption === 2) {
            this._recordVisit();
            return;
        }
        if (system.sun.hasGoneNova) {
            if (this._recordVisit()) {
                player.commsMessage(expandMissionText("explorers_club_visit_logged"));
            }
        }
    }

    // Visiting option 3, expert mode.

    this.shipApproachingPlanetSurface = function (planet) {
        "use strict";
        if (this.$xc_visitOption === 3 &&
            planet.isMainPlanet) {
            if (this._recordVisit()) {
                player.commsMessage(expandMissionText("explorers_club_visit_logged"));
            }
        }
    }

    this.playerWillSaveGame = function () {
        "use strict";
        missionVariables.explorerClub_record = JSON.stringify(this.$xc_record);
        missionVariables.explorerClub_chartOption = this.$xc_chartOption;
        missionVariables.explorerClub_visitOption = this.$xc_visitOption;
    }

/* ========================================================
			THE ENHANCED NAVIGATION CHARTS
=========================================================== */

    this.guiScreenChanged = function (to, from) {
        "use strict";
        if (guiScreen === "GUI_SCREEN_SYSTEM_DATA") {
            if (this.$xc_record[galaxyNumber].indexOf(player.ship.targetSystem) === -1) {
                mission.addMessageTextKey("explorers_club_never_visited");
            } else if (player.ship.targetSystem === system.ID) {
                mission.addMessageTextKey("explorers_club_here_now");
            } else {
                mission.addMessageTextKey("explorers_club_already_visited");
            }
        } else if (guiScreen === "GUI_SCREEN_LONG_RANGE_CHART") {
            if (this.$xc_chartOption === 2) {
                for (var i = 0; i < 256; i++) {
                    mission.unmarkSystem({system: i, name: "exclubmap"});
                }
                if (this.$xc_fadingReminder > 1) {
                    player.consoleMessage(expandMissionText("explorers_club_chart_visited"), this.$xc_fadingReminder);
                    this.$xc_fadingReminder -= 1;
                }
                // Double timer to execute function every 0.125 seconds.
                this.$xc_chartAnimationCounter = 0;
                this.$xc_markingTimer1 = new Timer(this, this._xc_markChart, 0.25, 0.25);
                this.$xc_markingTimer2 = new Timer(this, this._xc_markChart, 0.375, 0.25);
            } else if (this.$xc_chartOption === 3) {
                if (this.$xc_fadingReminder > 1) {
                    player.consoleMessage(expandMissionText("explorers_club_chart_unvisited"), this.$xc_fadingReminder);
                    this.$xc_fadingReminder -= 1;
                }
                var currentGalaxy = galaxyNumber;
                for (var i = 0; i < 256; i++) {
                    if (this.$xc_record[currentGalaxy].indexOf(i) === -1) {
                        mission.markSystem({system: i, name: "exclubmap", markerColor: "orangeColor", markerScale: 1.0, markerShape: "MARKER_DIAMOND"});
                    } else {
                        mission.unmarkSystem({system: i, name: "exclubmap"});
                    }
                }
            }
            return; // Yes.
        }
        if (from === "GUI_SCREEN_LONG_RANGE_CHART") {
            if (this.$xc_markingTimer1) {
                this.$xc_markingTimer1.stop();
                delete this.$xc_markingTimer1;
            }
            if (this.$xc_markingTimer2) {
                this.$xc_markingTimer2.stop();
                delete this.$xc_markingTimer2;
            }
            if (to !== "GUI_SCREEN_SHORT_RANGE_CHART" &&
                this.$xc_chartOption !== 1) {
                for (var i = 0; i < 256; i++) {
                    mission.unmarkSystem({system: i, name: "exclubmap"});
                }
            }
        }
    }

    this._xc_markChart = function () {
        "use strict";
        if (this.$xc_chartAnimationCounter >= this.$xc_record[galaxyNumber].length) {
            if (this.$xc_markingTimer1) {
                this.$xc_markingTimer1.stop();
                delete this.$xc_markingTimer1;
            }
            if (this.$xc_markingTimer2) {
                this.$xc_markingTimer2.stop();
                delete this.$xc_markingTimer2;
            }
            return;
        }
        var sysID = this.$xc_record[galaxyNumber][this.$xc_chartAnimationCounter];
        mission.markSystem({system: sysID, name: "exclubmap", markerColor: "greenColor", markerScale: 1.0, markerShape: "MARKER_X"});
        this.$xc_chartAnimationCounter++;
    }

/* ========================================================
			EVENT HANDLERS FOR THE SPECIAL SCREENS
=========================================================== */

    this.shipDockedWithStation = function (station) {
        "use strict";
        station.setInterface("explorers_club", {title: expandMissionText("explorers_club_interface_title"), category: expandDescription("[interfaces-category-organisations]"), summary: expandMissionText("explorers_club_interface_summary") + "\n" + this._playerRank(), callback: this.missionScreenOpportunity.bind(this)});
    }

    this.missionScreenOpportunity = function (screenToShowNext) {
        "use strict";
        if (screenToShowNext) {
            this.$xc_screenToShowNext = screenToShowNext;
        }
        if (!this.$xc_screenToShowNext) {
            return;
        }
        switch (this.$xc_screenToShowNext) {
          case "explorers_club":
            mission.runScreen({allowInterrupt: true, exitScreen: "GUI_SCREEN_INTERFACES", titleKey: "explorers_club_options_title", messageKey: "explorers_club_options_text", background: "Explorers_Club.png", choicesKey: "explorers_club_options_choices", initialChoicesKey: ["99_EXIT"]}, this._xc_choice);
            delete this.$xc_screenToShowNext;
            mission.addMessageText("\n" + this._playerRank());
            delete this.$xc_mileStonesPage;
            delete this.$xc_visitedNameAllPage;
            delete this.$xc_visitedNameFirstPage;
            delete this.$xc_visitedNameSecondPage;
            delete this.$xc_unvisitedNameAllPage;
            delete this.$xc_unvisitedNameFirstPage;
            delete this.$xc_unvisitedNameSecondPage;
            break;
          case "settings":
            mission.runScreen({allowInterrupt: true, exitScreen: "GUI_SCREEN_LONG_RANGE_CHART", titleKey: "explorers_club_settings_title", messageKey: "explorers_club_settings_text", background: "Explorers_Club.png"});
            delete this.$xc_screenToShowNext;
            switch (this.$xc_chartOption) {
              case 1:
                mission.addMessageTextKey("explorers_club_settings_chart_1");
                break;
              case 2:
                mission.addMessageTextKey("explorers_club_settings_chart_2");
                break;
              case 3:
                mission.addMessageTextKey("explorers_club_settings_chart_3");
                break;
              default:;
            }
            switch (this.$xc_visitOption) {
              case 1:
                mission.addMessageTextKey("explorers_club_settings_visit_1");
                break;
              case 2:
                mission.addMessageTextKey("explorers_club_settings_visit_2");
                break;
              case 3:
                mission.addMessageTextKey("explorers_club_settings_visit_3");
                break;
              default:;
            }
            break;
          case "achievements":
            mission.runScreen({allowInterrupt: true, titleKey: "explorers_club_achieved_title", message: this.$xc_mileStonesPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "explorers_club";
            break;
          case "alternative_ooniverse":
            mission.runScreen({allowInterrupt: true, titleKey: "explorers_club_achieved_title", messageKey: "explorers_club_alternative_ooniverse", background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "explorers_club";
            break;
          case "systems_visited_all":
            mission.runScreen({allowInterrupt: true, title: "G" + (galaxyNumber + 1) + expandMissionText("explorers_club_systems_visited_all"), message: this.$xc_visitedNameAllPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "systems_unvisited_1";
            break;
          case "systems_unvisited_1":
            mission.runScreen({allowInterrupt: true, title: "G" + (galaxyNumber + 1) + expandMissionText("explorers_club_systems_unvisited_1"), message: this.$xc_unvisitedNameFirstPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "systems_unvisited_2";
            break;
          case "systems_unvisited_2":
            mission.runScreen({allowInterrupt: true, title: "G" + (galaxyNumber + 1) + expandMissionText("explorers_club_systems_unvisited_2"), message: this.$xc_unvisitedNameSecondPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "explorers_club";
            break;
          case "systems_visited_1":
            mission.runScreen({allowInterrupt: true, title: "G" + (galaxyNumber + 1) + expandMissionText("explorers_club_systems_visited_1"), message: this.$xc_visitedNameFirstPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "systems_visited_2";
            break;
          case "systems_visited_2":
            mission.runScreen({allowInterrupt: true, title: "G" + (galaxyNumber + 1) + expandMissionText("explorers_club_systems_visited_2"), message: this.$xc_visitedNameSecondPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "systems_unvisited_all";
            break;
          case "systems_unvisited_all":
            mission.runScreen({allowInterrupt: true, title: "G" + (galaxyNumber + 1) + expandMissionText("explorers_club_systems_unvisited_all"), message: this.$xc_unvisitedNameAllPage, background: "Explorers_Club.png"});
            this.$xc_screenToShowNext = "explorers_club";
            break;
          default:;
        }
    }

/* ========================================================
			OTHER FUNCTIONS FOR THE SPECIAL SCREENS
=========================================================== */

    this._xc_choice = function (choice) {
        "use strict";
        switch (choice) {
          case "99_EXIT":
            delete this.$xc_screenToShowNext;
            break;
          case "31_SYSTEMS":
            this._xc_systemList();
            break;
          case "32_ACHIEVE":
            this._xc_achievements();
            break;
          default: // All these go to the settings screen.
            switch (choice) {
              case "11_CHART_NORMAL":
                this.$xc_chartOption = 1;
                for (var i = 0; i < 256; i++) {
                    mission.unmarkSystem({system: i, name: "exclubmap"});
                }
                break;
              case "12_CHART_VISITED":
                this.$xc_chartOption = 2;
                this.$xc_fadingReminder = 10;
                break;
              case "13_CHART_UNVISITED":
                this.$xc_chartOption = 3;
                this.$xc_fadingReminder = 10;
                break;
              case "21_DOCKED":
                this.$xc_visitOption = 1;
                if (player.ship.dockedStation.isMainStation) {
                    this._recordVisit();
                }
                break;
              case "22_FLYING":
                this.$xc_visitOption = 2;
                this._recordVisit();
                break;
              case "23_SURFACE":
                this.$xc_visitOption = 3;
                break;
              default:;
            }
            this.$xc_screenToShowNext = "settings";
        }
    }

    this._xc_systemList = function () {
        "use strict";
        var visitedName = new Array;
        var unVisitedName = new Array;
        var currentGalaxy = galaxyNumber;
        var arrayLength = this.$xc_record[galaxyNumber].length;
        var i;
        for (i = 0; i < arrayLength; i++) {
            visitedName.push(" " + System.systemNameForID(this.$xc_record[currentGalaxy][i]));
        }
        for (i = 0; i < 256; i++) {
            if (this.$xc_record[currentGalaxy].indexOf(i) === -1) {
                unVisitedName.push(" " + System.systemNameForID(i));
            }
        }
        unVisitedName = unVisitedName.sort();
        if (visitedName.length <= 128) {
            this.$xc_visitedNameAllPage = visitedName;
            this.$xc_unvisitedNameFirstPage = unVisitedName.slice(0, 128);
            this.$xc_unvisitedNameSecondPage = unVisitedName.slice(128);
            this.$xc_screenToShowNext = "systems_visited_all";
            this.missionScreenOpportunity();
        } else {
            this.$xc_visitedNameFirstPage = visitedName.slice(0, 128);
            this.$xc_visitedNameSecondPage = visitedName.slice(128);
            this.$xc_unvisitedNameAllPage = unVisitedName;
            this.$xc_screenToShowNext = "systems_visited_1";
            this.missionScreenOpportunity();
        }
    }

    this._xc_achievements = function () {
        "use strict";
        var testCoords = [[4.8, 40.6, 0], [9.6, 30.4, 0], [31.2, 42.4, 0], [62.4, 34.2, 0], [51.2, 28.8, 0], [86.4, 27.6, 0], [70.8, 4.6, 0], [90.8, 39.8, 0]];
        var alternativeOoniverse = false;
        if (System.infoForSystem(galaxyNumber, 255).coordinates.distanceTo(testCoords[galaxyNumber]) > 0.00001) {
            alternativeOoniverse = true;
        }
        if (alternativeOoniverse) {
            this.$xc_screenToShowNext = "alternative_ooniverse";
            this.missionScreenOpportunity();
            return;
        }
        if (!this.$xc_oldWorlds) {
            var oldWorlds = [7, 39, 46, 55, 129, 147, 255];
            this.$xc_oldWorlds = this._xc_isArray1_subsetOfArray2(oldWorlds, this.$xc_record[0]);
        }
        if (!this.$xc_famousPlanetsGalOne) {
            var famousPlanetsGalOne = [3, 7, 13, 16, 18, 21, 23, 28, 29, 35, 36, 39, 42, 44, 50, 55, 62, 66, 73, 86, 89, 90, 93, 99, 100, 101, 111, 124, 126, 129, 131, 132, 141, 147, 150, 153, 154, 172, 177, 186, 188, 198, 200, 221, 222, 227, 228, 241, 246, 250];
            this.$xc_famousPlanetsGalOne = this._xc_isArray1_subsetOfArray2(famousPlanetsGalOne, this.$xc_record[0]);
        }
        if (!this.$xc_famousPlanetsGalTwo) {
            var famousPlanetsGalTwo = [6, 23, 24, 29, 33, 42, 45, 48, 53, 54, 57, 58, 65, 66, 74, 78, 82, 88, 94, 109, 113, 114, 115, 122, 127, 136, 140, 144, 178, 188, 189, 193, 202, 204, 207, 221, 236];
            this.$xc_famousPlanetsGalTwo = this._xc_isArray1_subsetOfArray2(famousPlanetsGalTwo, this.$xc_record[1]);
        }
        if (!this.$xc_prodigalSuns) {
            var prodigalSuns = [133, 206];
            this.$xc_prodigalSuns = this._xc_isArray1_subsetOfArray2(prodigalSuns, this.$xc_record[2]);
        }
        if (!this.$xc_lostWorlds) {
            var lostWorlds = [33, 41, 55, 202];
            this.$xc_lostWorlds = this._xc_isArray1_subsetOfArray2(lostWorlds, this.$xc_record[5]);
        }
        if (!this.$xc_greatRift) {
            var greatRift = [15, 17, 27, 30, 61, 79, 97, 110, 115, 125, 130, 134, 137, 139, 153, 161, 173, 178, 186, 191, 205, 214, 218, 228, 229, 237, 248];
            this.$xc_greatRift = this._xc_isArray1_subsetOfArray2(greatRift, this.$xc_record[6]);
        }
        if (!this.$xc_oresratiChallenge) {
            if (this.$xc_record[7].indexOf(162) !== -1) {
                this.$xc_oresratiChallenge = true;
            }
        }
        if (!this.$xc_everyGalaxy) {
            if (this.$xc_record[0].length !== 0 &&
                this.$xc_record[1].length !== 0 &&
                this.$xc_record[2].length !== 0 &&
                this.$xc_record[3].length !== 0 &&
                this.$xc_record[4].length !== 0 &&
                this.$xc_record[5].length !== 0 &&
                this.$xc_record[6].length !== 0 &&
                this.$xc_record[7].length !== 0) {
                this.$xc_everyGalaxy = true;
            }
        }
        this.$xc_mileStonesPage = "";
        if (this.$xc_oldWorlds) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_old") + "\n";
        }
        if (this.$xc_famousPlanetsGalOne) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_famous_1") + "\n";
        }
        if (this.$xc_famousPlanetsGalTwo) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_famous_2") + "\n";
        }
        if (this.$xc_prodigalSuns) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_prodigal") + "\n";
        }
        if (this.$xc_lostWorlds) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_lost") + "\n";
        }
        if (this.$xc_greatRift) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_rift") + "\n";
        }
        if (this.$xc_oresratiChallenge) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_oresrati") + "\n";
        }
        if (this.$xc_everyGalaxy) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_eight") + "\n";
        }
        if (!this.$xc_oldWorlds) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_old") + "\n";
        }
        if (!this.$xc_famousPlanetsGalOne) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_famous_1") + "\n";
        }
        if (!this.$xc_famousPlanetsGalTwo) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_famous_2") + "\n";
        }
        if (!this.$xc_prodigalSuns) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_prodigal") + "\n";
        }
        if (!this.$xc_lostWorlds) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_lost") + "\n";
        }
        if (!this.$xc_greatRift) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_rift") + "\n";
        }
        if (!this.$xc_oresratiChallenge) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_oresrati") + "\n";
        }
        if (!this.$xc_everyGalaxy) {
            this.$xc_mileStonesPage += expandMissionText("explorers_club_achieved_no_eight") + "\n";
        }
        this.$xc_screenToShowNext = "achievements";
        this.missionScreenOpportunity();
    }

    this._xc_isArray1_subsetOfArray2 = function (array1, array2) {
        "use strict";
        if (!array1 || !array2 || array1.length > array2.length) {
            return false;
        }
        if (array1.length === array2.filter(function (value) {return this.indexOf(value) >= 0;}, array1).length) {
            return true;
        } else {
            return false;
        }
    }

/* ========================================================
			INITIALIZATION
=========================================================== */

    this.startUp = function () {
        "use strict";
        if (galaxyNumber < 0 || galaxyNumber > 7) {
            var message = "Warning: Explorers' Club is not compatible with additional hacked galaxies. OXP disabled.";
            log(this.name, message);
            player.consoleMessage(message, 10);
            for (prop in this) {
                if (prop !== "name" && prop !== "version") {
                    delete this[prop];
                }
            }
            return;
        }
        if (!missionVariables.explorerClub_record) {
            this.$xc_record = [[], [], [], [], [], [], [], []];
            this.$xc_chartOption = 1;
            this.$xc_visitOption = 1;
            this.$xc_firstRun = true;
        } else {
            this.$xc_record = JSON.parse(missionVariables.explorerClub_record);
            this.$xc_chartOption = missionVariables.explorerClub_chartOption;
            this.$xc_visitOption = missionVariables.explorerClub_visitOption;
        }
        this.$xc_fadingReminder = 7;
        delete this.startUp;
        // Defunct mission variables from previous versions:-
        delete missionVariables.explorerClub_snapshotOption;
        delete missionVariables.explorerClub_snapshotOnLaunch;
        mission.setInstructions(null, this.name);
    }

    this.startUpComplete = function () {
        "use strict";
        if (player.ship.docked) {
            this.shipDockedWithStation(player.ship.dockedStation);
            if (this.$xc_firstRun) {
                delete this.$xc_firstRun;
                if (player.ship.dockedStation === system.mainStation) {
                    this.$xc_record[galaxyNumber][0] = system.ID;
                }
            }
        }
        delete this.startUpComplete;
    }

/* ========================================================
			INTERFACE FUNCTIONS

	Other scripts can call these functions.
=========================================================== */

    this._playerRank = function (requested) {
        "use strict";
        if (this.startUp) {
            this.startUp();
        }
        var chartVisited = this.$xc_record[galaxyNumber].length;
        if (requested === "chart") {
            return chartVisited;
        }
        var totalVisited = 0;
        for (var i = 0; i < 8; i++) {
            totalVisited += this.$xc_record[i].length;
        }
        if (requested === "total") {
            return totalVisited;
        }
        var rank;
        if (totalVisited >= 2048) {
            rank = expandMissionText("explorers_club_rank_2048");
        } else if (totalVisited >= 1024) {
            rank = expandMissionText("explorers_club_rank_1024");
        } else if (totalVisited >= 512) {
            rank = expandMissionText("explorers_club_rank_512");
        } else if (totalVisited >= 256) {
            rank = expandMissionText("explorers_club_rank_256");
        } else if (totalVisited >= 128) {
            rank = expandMissionText("explorers_club_rank_128");
        } else {
            rank = expandMissionText("explorers_club_rank_1");
        }
        if (requested === "rank") {
            return rank;
        }
        var rankString = expandMissionText("explorers_club_rank_string", {"explorers_club_rank_chart": chartVisited, "explorers_club_rank_total": totalVisited, "explorers_club_rank_player": rank});
        return rankString;
    }

    this._playerVisited = function (galaxy, sysID) {
        "use strict";
        if (this.startUp) {
            this.startUp();
        }
        if (typeof(sysID) === "undefined") {
            return "bad parameters";
        }
        if (galaxy < 0 ||
            galaxy > 7) {
            return "bad galaxy";
        }
        if (sysID < 0 ||
            sysID > 255) {
            return "bad system";
        }
        if (this.$xc_record[galaxy].indexOf(sysID) === -1) {
            return false;
        } else {
            return true;
        }
    }

/* ========================================================
			OTHER EVENT HANDLER

This is the only change from 1.4.4 to 1.4.6 - removing this 
because, for many players, the manifest screen is a lot 
more cluttered than it used to be.
=========================================================== */

  //  this.guiScreenWillChange = function (to, from) {
  //      "use strict";
  //      if (to === "GUI_SCREEN_MANIFEST") {
  //          mission.setInstructions(this._playerRank(), this.name);
  //      }
  //  }

/* ========================================================
			THE END
=========================================================== */