// JavaScript for Oolite (ECMAScript 5)
"use strict";

    this.license = "CC-BY-NC-SA 4.0";
    this.author = "Wildeblood";
    this.version = "0.8";
    this.name = "thargoidifier_tests";

    this._testing = true;

/* ==================== TESTING FUNCTIONS ==================== */

 // To add the test functions "Thargoidify System", "Thargoidify Nearby Systems"
 // and "Reset Thargoidification" to the F4 screen,
 // in any world script, in the startUp or startUpComplete functions, set:
 // worldScripts.thargoidifier_tests._testing = true;
 // This cannot be changed after startUpComplete.

    this.missionScreenOpportunity = function () {
        if (this._testing) {
            this.shipDockedWithStation(player.ship.dockedStation);
            log(this.oolite_manifest_identifier, "Test functions added to F4 screen.");
            this._testTextGenerators();
        } else {
            delete this._testTextGenerators;
            delete this.infoSystemChanged;
            delete this.playerBoughtEquipment;
            delete this.shipDockedWithStation;
            delete this._thargoidifyTargetSystem;
            delete this._thargoidifyNearbySystems;
            delete this._resetChart;
            delete this._alertPlayer;
        }
        delete this._testing;
        delete this.missionScreenOpportunity; // Runs only once, shortly after startUpComplete
    };

    this._testTextGenerators = function () {
        var message = "\nTesting a dozen calls to _generatePlanetName\n"
        for (let i = 1; i < 13; i++) {
            message += (worldScripts.thargoidifier._generatePlanetName() + "\n");
        }
        message += "\nTesting a dozen calls to _createPopulationDescription\n"
        for (let i = 1; i < 13; i++) {
            message += (worldScripts.thargoidifier._createPopulationDescription(player.ship.infoSystem) + "\n");
        }
        log(this.name, message);
    };

    this.infoSystemChanged = function (sysID) {
        if (player.ship.docked) {
            system.mainStation.setInterface("Thargoidifier", {
              title: "Thargoidify " + System.systemNameForID(sysID),
              category: "A TEST",
              summary: "Thargoidify. See https://wiki.alioth.net/index.php/Thargoidifier for details.",
              callback: this._thargoidifyTargetSystem.bind(this)
            });
        }
    };

    this.playerBoughtEquipment = function (equipmentKey) {
        if (equipmentKey === "EQ_FUEL") {
            system.mainStation.setInterface("nearby_Thargoidifier", {
              title: "Thargoidify Nearby Systems",
              category: "A TEST",
              summary: "Thargoidify systems within " + player.ship.fuel + "LY of " + system.name + ".",
              callback: this._thargoidifyNearbySystems.bind(this)
            });
        }
    };

    this.shipDockedWithStation = function (station) {
        if (station.isMainStation) {
            station.setInterface("Thargoidifier", {
              title: "Thargoidify " + System.systemNameForID(player.ship.infoSystem),
              category: "A TEST",
              summary: "Thargoidify.",
              callback: this._thargoidifyTargetSystem.bind(this)
            });
            station.setInterface("nearby_Thargoidifier", {
              title: "Thargoidify Nearby Systems",
              category: "A TEST",
              summary: "Thargoidify systems within " + player.ship.fuel + "LY of " + system.name + ".",
              callback: this._thargoidifyNearbySystems.bind(this)
            });
            station.setInterface("reset_Thargoidification", {
              title: "Reset Thargoidification",
              category: "A TEST",
              summary: "Reset all Thargoidification of current chart (galaxy " + galaxyNumber + ").",
              callback: this._resetChart.bind(this)
            });
        }
    };

    this._thargoidifyTargetSystem = function () {
        this._alertPlayer();
        worldScripts.thargoidifier._thargoidifySystem(player.ship.infoSystem);
    };

    this._thargoidifyNearbySystems = function () {
        this._alertPlayer();
        var sysIDs = [];
        var systems = system.info.systemsInRange(player.ship.fuel);
        for (let i = 0; i < systems.length; i++) {
            sysIDs.push(systems[i].systemID);
        }
        worldScripts.thargoidifier._thargoidifySystems(sysIDs);
    };

    this._resetChart = function () {
        player.consoleMessage("Chart will be reset in a few seconds.", 10);
        worldScripts.thargoidifier._resetAllSystemsInGalaxy(galaxyNumber);
    };

    this._alertPlayer = function () {
        player.consoleMessage("Thargoidification will be complete in a few seconds.", 10);
        setScreenBackground({ name: "thargoidifier_background.png", height: 512 });
    };
