// JavaScript for Oolite (ECMAScript 5)
"use strict";

    this.license = "CC-BY-NC-SA 4.0";
    this.author = "Wildeblood";
    this.version = "0.8";
    this.name = "thargoidifier";

    this._thargoidStationRole = "KWwreck"; // See oolite.oxp.Killer_Wolf.Wrecked_Coriolis

    this._thargoidifySystem = function (sysID) {
        if (typeof sysID !== "number" || sysID < 0 || sysID > 255) {
            log(this.name, "Invalid system ID parameter.");
            return;
        }
        const sys = System.infoForSystem(galaxyNumber, sysID);

     // These are the essentials to instantiate the system...
        sys.setProperty(3, "populator", "_thargoidSystemWillPopulate");       // See below, bare system.
        sys.setProperty(3, "repopulator", "interstellarSpaceWillRepopulate"); // See worldScripts["oolite-populator"]
        sys.setProperty(3, "station", this._thargoidStationRole);

     // These are for the GUI screens...
        sys.setProperty(2, "concealment", null);
        sys.setProperty(2, "economy_description", "Trade Prohibited");
        sys.setProperty(2, "government_description", "Alien");
        sys.setProperty(2, "population_description", this._createPopulationDescription(sysID)); // Call before changing inhabitants.
        sys.setProperty(2, "inhabitants", "Thargoid Overlords");
        sys.setProperty(2, "market_script", "thargoidifier_market.js");
        sys.setProperty(2, "name", "I.N.F.E. " + sysID);
        sys.setProperty(2, "planet_name", this._generatePlanetName());

        sys.setProperty(1, "techlevel", 0);
        sys.setProperty(1, "description", expandDescription("[thargoid_curses]"));
    };

    this._resetAllSystemsInGalaxy = function (galaxy) {
        if (typeof galaxy !== "number" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter. Defaulting to galaxyNumber: " + galaxyNumber);
            galaxy = galaxyNumber;
        }
        for (let sysID = 0; sysID <= 255; sysID++) {
            var sys = System.infoForSystem(galaxy, sysID);

         // Ensure this list matches above EXACTLY (layer numbers must match).
            sys.setProperty(3, "populator", null);
            sys.setProperty(3, "repopulator", null);
            sys.setProperty(3, "station", null);

            sys.setProperty(2, "concealment", null);
            sys.setProperty(2, "economy_description", null);
            sys.setProperty(2, "government_description", null);
            sys.setProperty(2, "population_description", null);
            sys.setProperty(2, "inhabitants", null);
            sys.setProperty(2, "market_script", null);
            sys.setProperty(2, "name", null);
            sys.setProperty(2, "planet_name", null);

            sys.setProperty(1, "techlevel", null);
            sys.setProperty(1, "description", null);
        }
    };

    this._thargoidSystemWillPopulate = function () {;}; // Bare system.

    this._thargoidifySystems = function (sysIDs) {
        if (!Array.isArray(sysIDs)) {
            log(this.name, "Invalid parameter: expected an array of system IDs.");
            return;
        }
        for (let i = 0; i < sysIDs.length; i++) {
            var sysID = sysIDs[i]; 
            if (typeof sysID === "number" && sysID >= 0 && sysID <= 255) {
                this._thargoidifySystem(sysID);
            } else {
                log(this.name, "Skipping invalid system ID: " + sysID);
            }
        }
    };

    this._isThargoidified = function (galaxy, sysID) {
        if (typeof sysID !== "number" || sysID < 0 || sysID > 255) {
            log(this.name, "Invalid system ID parameter.");
            return null;
        }
        if (typeof galaxy !== "number" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter.");
            return null;
        }
        const sys = System.infoForSystem(galaxy, sysID);
        if (sys.populator === "_thargoidSystemWillPopulate" &&
            sys.repopulator === "interstellarSpaceWillRepopulate" &&
            sys.station) {
            return sys.station;
        } else {
            return false;
        }
    };

/* ============= POPULATION DESCRIPTION-GENERATOR ============= */

    this._createPopulationDescription = function (sysID) {
        const sys = System.infoForSystem(galaxyNumber, sysID);
        const multiples = ["", "0", ",000", "", "3", "7", " thousand", " million"];
        const multiple = multiples[Math.floor(Math.random() * multiples.length)];
        return sys.population + multiple + " enslaved " + sys.inhabitants;
    };

/* ================== PLANET NAME-GENERATOR =================== */

    this._generatePlanetName = function () {
        const starters = ["Thar", "Tharg"];
        const middles = ["a", "e", "i", "o", "u", "ar", "or", "al", "il", "en"];
        const endings = ["x", "n", "th", "s", "k", "nex", "tus", "ros", "vox"];

        const starter = starters[Math.floor(Math.random() * starters.length)];
        const middle = middles[Math.floor(Math.random() * middles.length)];
        const ending = endings[Math.floor(Math.random() * endings.length)];

        let name = starter + middle + ending;
     // Truncate to 10 characters max
        name = name.substring(0, 10);
     // Ensure minimum length of 3 characters
        while (name.length < 3) {
            name += middles[Math.floor(Math.random() * middles.length)];
        }
        return name;
    };

/* =============== SYSTEM DESCRIPTION-GENERATOR =============== */