// JavaScript for Oolite (ECMAScript 5)
"use strict";

    this.license = "CC-BY-NC-SA 4.0";
    this.author = "Wildeblood";
    this.version = "0.6";
    this.name = "thargoidifier_market.js";

    this.updateLocalCommodityDefinition = function (definition, station, sysID) {

        const population = System.infoForSystem(galaxyNumber, sysID).population;
	var commodity = definition.key;

	if (commodity === "slaves") {
		definition.price = 10000;
		definition.quantity = population;
		definition.capacity = population;
		definition.legality_export = 0;
		definition.legality_import = 1;

	} else if (commodity === "alien_items") {
		definition.price = 10000;
		definition.quantity = 0;
		definition.capacity = population;
		definition.legality_export = 1000;
		definition.legality_import = 0;
	
	} else { // No definition found, no market for that commodity
		definition.price = 0;
		definition.quantity = 0;
		definition.capacity = 0;
		definition.legality_export = 0;
		definition.legality_import = 0;
	}
	return definition;
    };
