// JavaScript for Oolite (ECMAScript 5)

"use strict";
    this.license = "CC-BY-NC-SA 4.0";
    this.author = "Wildeblood";
    this.version = "0.1";
    this.name = "Thargoidifier";

    this._thargoidifySystem = function (sysID) {
        const sys = System.infoForSystem(galaxyNumber, sysID);

     // These are the essentials to instantiate the system...
        sys.setProperty(3, "populator", "_thargoidSystemWillPopulate");       // See below, bare system.
        sys.setProperty(3, "repopulator", "interstellarSpaceWillRepopulate"); // See worldScripts["oolite-populator"]
     // sys.setProperty(3, "station", "infe-station");                        // Left as an exercise for the reader. 

     // These are for the GUI screens...
        sys.setProperty(2, "concealment", null);
        sys.setProperty(2, "name", "I.N.F.E. " + sysID);
        sys.setProperty(2, "planet_name", this._generatePlanetName());
        sys.setProperty(2, "economy_description", "Trade Prohibited");
        sys.setProperty(2, "government_description", "Alien");

        sys.setProperty(1, "economy", Math.floor(Math.random() * 8));
        sys.setProperty(1, "government", Math.floor(Math.random() * 8));
        sys.setProperty(1, "techlevel", Math.floor(Math.random() * 16));
        sys.setProperty(1, "description", "Mostly harmless.");
    };

    this._resetAllSystemsInGalaxy = function (galaxy) {
        if (typeof galaxy !== "number" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter. Defaulting to galaxyNumber: " + galaxyNumber);
            galaxy = galaxyNumber;
        }
        for (let sysID = 0; sysID <= 255; sysID++) {
            var sys = System.infoForSystem(galaxy, sysID);

         // Ensure this list matches above EXACTLY (layer numbers must match).
            sys.setProperty(3, "populator", null);
            sys.setProperty(3, "repopulator", null);
            sys.setProperty(3, "station", null);

            sys.setProperty(2, "concealment", null);
            sys.setProperty(2, "name", null);
            sys.setProperty(2, "planet_name", null);
            sys.setProperty(2, "economy_description", null);
            sys.setProperty(2, "government_description", null);

            sys.setProperty(1, "economy", null);
            sys.setProperty(1, "government", null);
            sys.setProperty(1, "techlevel", null);
            sys.setProperty(1, "description", null);
        }
    };

    this._thargoidSystemWillPopulate = function () {;} // Bare system.

/* ==================== PLANET NAME-GENERATOR ==================== */

this._generatePlanetName = function () {
    const starters = ["Thar", "Tharg"];
    const middles = ["a", "e", "i", "o", "u", "ar", "or", "al", "il", "en"];
    const endings = ["x", "n", "th", "s", "k", "nex", "tus", "ros", "vox"];

    const starter = starters[Math.floor(Math.random() * starters.length)];
    const middle = middles[Math.floor(Math.random() * middles.length)];
    const ending = endings[Math.floor(Math.random() * endings.length)];

    let name = starter + middle + ending;
    // Truncate to 10 characters max
    name = name.substring(0, 10);
    // Ensure minimum length of 3 characters
    while (name.length < 3) {
        name += middles[Math.floor(Math.random() * middles.length)];
    }
    return name;
};

/* ==================== TESTING FUNCTIONS ==================== */

 // To add the test functions "Thargoidify System" and "Reset Thargoidification" to
 // the F4 screen, in any world script, in the startUp or startUpComplete functions, set:
 // worldScripts.Lost_In_Space._testing = true;
 // This cannot be changed after startUpComplete.

    this._testing = true;

    this.missionScreenOpportunity = function () {
        if (this._testing) {
            this.shipExitedWitchspace();
        } else {
            delete this.infoSystemChanged;
            delete this.shipExitedWitchspace;
            delete this._thargoidifyTargetSystem;
            delete this._resetChart;
        }
        delete this._testing;
        delete this.missionScreenOpportunity; // Run only once, shortly after startUpComplete
    };

    this.infoSystemChanged = function (sysID) {
        if (system.mainStation) {
            system.mainStation.setInterface("Thargoidification", {
              title: "Thargoidify " + System.systemNameForID(sysID),
              category: "A TEST",
              summary: "Thargoidify.",
              callback: this._thargoidifyTargetSystem.bind(this)
            });
        }
    };

    this.shipExitedWitchspace = function () {
        if (system.mainStation) {
            system.mainStation.setInterface("Thargoidification", {
              title: "Thargoidify " + System.systemNameForID(player.ship.infoSystem),
              category: "A TEST",
              summary: "Thargoidify.",
              callback: this._thargoidifyTargetSystem.bind(this)
            });
            system.mainStation.setInterface("reset_Thargoidification", {
              title: "Reset Thargoidification",
              category: "A TEST",
              summary: "Reset all Thargoidification of current chart (galaxy " + galaxyNumber + ").",
              callback: this._resetChart.bind(this)
            });
        }
    };

    this._thargoidifyTargetSystem = function () {
        player.consoleMessage("Thargoidification will be complete in a few seconds.", 10);
        this._thargoidifySystem(player.ship.infoSystem);
    };

    this._resetChart = function () {
        player.consoleMessage("Chart will be reset in a few seconds.", 10);
        this._resetAllSystemsInGalaxy(galaxyNumber);
    };
