"use strict";
this.name           = "blackbaron";
this.author         = "Thargoid, Kaks, Rxke, phkb";
this.copyright      = "Creative Commons: attribution, non-commercial, sharealike.";
this.description    = "The Black Baron Mission - original plist script by Rxke, js script by Kaks";
this.licence        = "CC BY-NC-SA 3.0";

// Script update for 1.74 - will not work with any lower version

this.startUp = function() {
	if (missionVariables.blackbaron=='MISSION_COMPLETE') {
		delete this.missionScreenOpportunity;
		delete this.shipWillExitWitchspace;
		delete this.playerEnteredNewGalaxy;
		delete this.startUp;
		return;
	}
	if(!missionVariables.blackbaron) missionVariables.blackbaron='OFFER';
}
	

this.addMinions = function() {
	if (player.ship.isInSpace === false) {
		this.timer.stop();
		return;
	}
	this.minionCounter++;
	if(system.shipsWithRole('rxke_blackbaron_minion').length < 7 && Math.random() < 0.5) system.addShips('rxke_blackbaron_minion', 1);
	if(this.minionCounter >= (system.ID==222 ? 9 :6)) this.timer.stop();
}

// mission offers --------------------------------------------------------

this.missionScreenOpportunity = function ()	{	
	if (player.ship.docked && player.ship.dockedStation.isMainStation && galaxyNumber==0) {
		if (missionVariables.longwayround=='MISSION_COMPLETE'
			&& missionVariables.blackbaron == 'OFFER'
			&& system.ID==243
			&& player.score>150) {
			mission.runScreen({screenID:"blackbaron", title:"Black Baron", messageKey: "rxke_blackbaron_briefing1", choicesKey: "rxke_blackbaron_choices"}, this.choice);
			return;
		}
				
		switch(missionVariables.blackbaron) {
			case 'STAGE1': {
				if (system.ID==93 && galaxyNumber==0){
					mission.runScreen({screenID:"blackbaron", title:"Black Baron", messageKey: "rxke_blackbaron_briefing2"});
					mission.setInstructionsKey("rxke_blackbaron_short1"); 
					player.credits+=1000;
					player.consoleMessage("You have been awarded 1000cr.");
					missionVariables.blackbaron='STAGE2';
				}
				break;
			}
			case 'STAGE2': {
				if (system.ID==180 && galaxyNumber==0){
					mission.runScreen({screenID:"blackbaron", title:"Black Baron", messageKey: "rxke_blackbaron_briefing3"});
					player.credits+=5000;
					player.consoleMessage("You have been awarded 5000cr.");
					missionVariables.blackbaron='MISSION_COMPLETE';
					mission.setInstructionsKey(null);
					delete this.missionScreenOpportunity;
					delete this.shipWillExitWitchspace;
					delete this.playerEnteredNewGalaxy;
				}	
				break;
			}
		}
	}
}

this.choice = function(choice) {
	switch(choice) {
		case "rxke_blackbaron_choiceAccept": {
			mission.setInstructionsKey("rxke_blackbaron_short2"); 
			missionVariables.blackbaron='STAGE1';
			break;
		}
		case "rxke_blackbaron_choiceReject": {
			missionVariables.blackbaron='MISSION_COMPLETE';
			mission.setInstructionsKey(null);
			break;
		}
	}
}

//    events  ---------------------------------------------------------------

this.shipWillExitWitchspace = function() {
	if (missionVariables.blackbaron=='STAGE2' && galaxyNumber == 0) {
		if (system.ID==180)
			system.addShips('rxke_blackbaron_minion', 7);
		else if (system.ID==222 || system.ID==48) {
			this.minionCounter=0;
			this.timer=new Timer(this, this.addMinions,2,8);
		}
	}
}

this.playerEnteredNewGalaxy = function(galaxyNumber) {
    if(galaxyNumber == 1 && (missionVariables.blackbaron=='STAGE1' || missionVariables.blackbaron=='STAGE2')) {
		mission.setInstructionsKey(null);
		missionVariables.blackbaron='MISSION_COMPLETE';
		delete this.missionScreenOpportunity;
		delete this.shipWillExitWitchspace;
		delete this.playerEnteredNewGalaxy;
	}
}
