"use strict";

this.name    = "Contracted Goods Reminder";
this.version = "1.0";

/* ====================================================================================
			EVENT HANDLERS
======================================================================================= */

    this.guiScreenChanged = function (to, from) {
        "use strict";
        if (player.ship.docked &&
            to === "GUI_SCREEN_MARKET") {
            this._reserveGoodsForContracts();
        }
    }

    this._reserveGoodsForContracts = function () {
        "use strict";
        this.$reservedGoods = {};
        var arrayLength = player.ship.contracts.length;
        if (arrayLength) {
            for (var i = 0; i < arrayLength; i++) {
                var commodity = player.ship.contracts[i].commodity;
                var quantity  = player.ship.contracts[i].quantity;
                var reserve   = this.$reservedGoods[commodity];
                if (reserve) {
                    this.$reservedGoods[commodity] += quantity;
                } else {
                    this.$reservedGoods[commodity] = quantity;
                }
            }
        }
    }

    this.playerSoldCargo = function (commodity, quantity, unitPrice) {
        "use strict";
        var panic = false;
        var reserve = this.$reservedGoods[commodity];
        if (reserve && !manifest[commodity]) {
            panic = true;
        } else if (reserve && reserve > manifest[commodity]) {
            panic = true;
        }
        if (panic) {
            var displayName = displayNameForCommodity(commodity);
            player.consoleMessage("You need at least " + reserve + " units of " + displayName.toLowerCase() + " to fulfil your contracts.", 6);
        }
    }

/* ====================================================================================
			THE END
======================================================================================= */
