"use strict";
this.name = "LoadoutCategories_Conditions";
this.author = "phkb";
this.copyright = "2023 phkb";
this.description = "Condition script for equipment.";
this.license = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {
    if (equipment.indexOf("_F5") >= 0) {
        return (context == "scripted");
    }
    // hide headers for OXP-specific items
    switch (equipment) {
        case "EQ_REORDERING_WEAPONONLY":
        case "EQ_REORDERING_BERTHWEAPON":
            if (context != "scripted") return false;
            break;
        case "EQ_REORDERING_LMSS":
            if (!worldScripts.LMSS_Core) return false;
            break;
        case "EQ_REORDERING_TRACTORBEAM":
            if (!worldScripts.towbar) return false;
            break;
        case "EQ_REORDERING_REPAIRBOTS":
            if (!worldScripts["Repair System"] && !worldScripts.hardships && !worldScripts["Caduceus Damage Control Node"]) return false;
            break;
        case "EQ_REORDERING_SALVAGE":
            if (!worldScripts.Anarchies || player.ship.dockedStation.name !== "Salvage Gang") return false;
            break;
        case "EQ_REORDERING_NAVIGATION":
            if (worldScripts.LoadoutCategories._useAstrogation == true) return false;
            break;
        case "EQ_REORDERING_ASTROGATION":
            if (worldScripts.LoadoutCategories._useAstrogation == false) return false;
            break;
    }
    return true;
}