"use strict"
this.name = "More Moolah";
this.author = "Reval";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.5";
this.description = "An enhanced and extended Market for the zealous merchanter. 5 (five) new commodities for industrial and agricultural economies; 10 (ten) recast display aliases for the Oolite goods. Full descriptions and advice for all 18 commodities via the F8F8 Market screen. More variety, more realism, more trade possibilities, more moolah. MM makes an ideal pairing with Merchanter's Zeal (MM + MZ = $$$)";

/* ALL credit and homage to Spara for this code! The only things Reval changed were the content, and order of the items in the commodities array; also introduced conditional for the loop and a try catch() to reduce the logged errors. When, oh when will the devs fix this persistent Oolite BUG that even now, with version 1.91, forces workarounds and kludges like this? Shows how much _they_ care about Trading, eh? */

//1.1 save every market on save and restore when spawning. now it's fully compatible with market inquirer.

this.startUp = function() {
	if (missionVariables.marketRestorePrimaryRoles) {
		this.$primaryRoles = JSON.parse(missionVariables.marketRestorePrimaryRoles);
		this.$markets = JSON.parse(missionVariables.marketRestoreMarkets);
	}
	else {
		this.$primaryRoles = new Array();
		this.$markets = new Array();
		delete this.shipSpawned;
	}
}

//restore market when station is spawned
this.shipSpawned = function(ship) {
	if (ship.isStation) {
		var index = this.$primaryRoles.indexOf(ship.primaryRole);
		if (index !== -1) {
			var commodities  = ["slaves","androids","robots","luxuries","computers","live_animals","furs","leather_goods","firearms","machinery","medicines","narcotics","alloys","liquor_wines","textiles","food","minerals","radioactives","gold","platinum","gem_stones","alien_items"];		
			var market = this.$markets.splice(index, 1)[0];
			if (market!=null) {
				var i, commodity;
				for (i = 0; i < market.length; i++) {
					commodity = commodities[i];
					try {
						ship.setMarketQuantity(commodity, market[i][0]);
						ship.setMarketPrice(commodity, market[i][1]);
					} catch(err) {}
				}
				this.$primaryRoles.splice(index, 1);
			}
		}		
	}
}

//wipe everything when leaving system
this.shipWillEnterWitchSpace = function() {
	this.$primaryRoles = new Array();
	this.$markets = new Array();
	delete this.shipSpawned;
}

//save primaryRoles and markets (prices and quantities) of all stationary stations
this.playerWillSaveGame = function() {
	function stations(entity) {return (entity.isStation && !entity.isMainStation && !entity.maxSpeed)};
	var i, j, station, commodity;
	var stationMarket = new Array();
	var primaryRoles = this.$primaryRoles.concat();
	var markets = this.$markets.concat();
	var commodities  = ["slaves","androids","robots","luxuries","computers","live_animals","furs","leather_goods","firearms","machinery","medicines","narcotics","alloys","liquor_wines","textiles","food","minerals","radioactives","gold","platinum","gem_stones","alien_items"];	
	var oxpStations = system.filteredEntities(this, stations, player.ship);
	for (i = 0; i < oxpStations.length; i++) {
		station = oxpStations[i];
		primaryRoles.push(station.primaryRole);
		stationMarket = new Array();
		for (j = 0; j < commodities.length; j++) {
			commodity = commodities[j];
			try {
				stationMarket.push([station.market[commodity].quantity, station.market[commodity].price]);
			} catch(err) {}
		}
		markets.push(stationMarket);
	}
	if (primaryRoles.length > 0) {
		missionVariables.marketRestorePrimaryRoles = JSON.stringify(primaryRoles);
		missionVariables.marketRestoreMarkets = JSON.stringify(markets);
	}
	else {
		delete missionVariables.marketRestorePrimaryRoles;
		delete missionVariables.marketRestoreMarkets;
	}
}

