"use strict";
this.name        = "NoMarketNotification"; 
this.author      = "phkb";
this.copyright   = "2018 phkb";
this.description = "Display a message instead of an unusable market screen.";
this.licence     = "CC BY-NC-SA 4.0";

this._noMarket = false;
this._cargoTypes = ["food", "textiles", "radioactives", "slaves", "liquor_wines", "luxuries", "narcotics", "computers", "machinery", "alloys", "firearms", "furs", "minerals", "alien_items", "gold", "platinum", "gem_stones"];

//-------------------------------------------------------------------------------------------------------------
this.shipWillDockWithStation = function(station) {
	var priceTotal = 0;
	this._noMarket = false;
	for (var i = 0; i < this._cargoTypes.length; i++) {
		priceTotal += station.market[this._cargoTypes[i]].price;
	}
	if (priceTotal == 0) this._noMarket = true;
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenWillChange = function(to, from) {

	// if market observer changes the HUD on the market screen, and we also run a mission screen
	// the "Press Space Commander" may not show, if the default HUD has allow Big GUI set.
	// so stop market observers "guiScreenChanged" event from firing, then put it back afterwards
	if (worldScripts.market_ads) {
		var ma = worldScripts.market_ads;
		if (to === "GUI_SCREEN_MARKET" && player.ship.docked && this._noMarket == true) {
			if (ma.guiScreenChanged) {
				ma.$hold_guiScreenChanged = ma.guiScreenChanged;
				delete ma.guiScreenChanged;
			}
		} else {
			if (ma.$hold_guiScreenChanged) {
				ma.guiScreenChanged = ma.$hold_guiScreenChanged;
				delete ma.$hold_guiScreenChanged;
			}
		}
	}
	if (worldScripts.market_observer3) {
		var mo = worldScripts.market_observer3;
		if (to === "GUI_SCREEN_MARKET" && player.ship.docked && this._noMarket == true) {
			if (mo.guiScreenChanged) {
				mo.$hold_guiScreenChanged = mo.guiScreenChanged;
				delete mo.guiScreenChanged;
			}
		} else {
			if (mo.$hold_guiScreenChanged) {
				mo.guiScreenChanged = mo.$hold_guiScreenChanged;
				delete mo.$hold_guiScreenChanged;
			}
		}
	}
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenChanged = function(to, from) {
	var p = player.ship;
	if (p.docked) {
		if (p.dockedStation.hasRole("planetFall_feudalStates") || p.dockedStation.hasRole("feudal-hunting-lodge")) return;
		if (to === "GUI_SCREEN_MARKET" && this._noMarket == true) {
			mission.runScreen({
				title: "No Market Available",
				message: "There is no commodities market available on this station. No goods can be bought or sold here.",
				exitScreen: "GUI_SCREEN_MANIFEST"
			});
		}
	}
}