"use strict";
this.name = "FuelTweaks_StationSetup";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Script to add fuel station to certain systems";

this._notify = false;
this._fxScale = 0.2;
this._fxForward = 200;
this._fxUp = 20;

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	if (missionVariables.FuelTweaks_Notice) this._notify = missionVariables.FuelTweaks_Notice;
}

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function () {
	if (worldScripts.BountySystem_Core) {
		worldScripts.BountySystem_Core._offenceTypes["damaged property"] = { description: expandMissionText("FT_station_offence"), severity: 2 };
	}
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function () {
	if (this._notify == false) {
		this._notify = true;
		/*mission.runScreen({
			screenID:"oolite-fueltweaks-notice-map",
			title: "Change to refuelling process",
			model:"fuelTweaks_station",
			spinModel:true,
			message: this.$duplicate("=", 32) + "\nOfficial GalCop Notice:\n" + this.$duplicate("-", 32) + "\n\nDue to a spate of accidents involving refuelling at GalCop stations, all pilots need to be aware of new rules and processes governing the refuelling of ships.\n\nYou will no longer be able to fully refuel your ship at GalCop stations. Instead, GalCop have installed a specialised refuelling station near the main station of many systems. Pilots can enter these facilities to refuel.\n\nThere are a few places where these refuelling stations are not yet able to be installed, and so you will be able to purchase an emergency fuel ration from those stations.\n\nWe thank you for your support and help in making our stations safer.\n\nGalCop Port Authority",
			exitScreen: "GUI_SCREEN_STATUS"
		});*/
	}
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
	missionVariables.FuelTweaks_Notice = this._notify;
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function () {
	if (system.isInterstellarSpace || system.sun.isGoingNova || system.sun.hasGoneNova || system.countShipsWithRole("fuelTweaks_location") > 0) return;

	// no anarchy system, and no really low-tech systems
	var fe = worldScripts.FuelTweaks_FuelEconomy;
	if (fe.$isRefuelStationAvailable() === false) return;

	var posFS = system.mainStation.position.add(system.mainStation.vectorForward.multiply(system.mainStation.scannerRange * -0.8));

	system.setPopulator("fuel_station", {
		location: "COORDINATES",
		coordinates: posFS,
		callback: function (pos) {
			var fs = system.addShips("fuelTweaks_station", 1, pos, 0);
		}
	}
	);
}

//-------------------------------------------------------------------------------------------------------------
// duplicates text until it is just less than the desired length;
this.$duplicate = function (text, desiredLength) {
	var res = "";
	do {
		res += text;
	} while (defaultFont.measureString(res) < desiredLength);

	res = res.substring(1, res.length);
	return res;
}

