"use strict";
this.name = "FuelTweaks_Conditions";
this.author = "phkb";
this.copyright = "2017 phkb";
this.description = "Condition script for fuel equipment";
this.licence = "CC BY-NC-SA 4.0";

//-------------------------------------------------------------------------------------------------------------
this.allowAwardEquipment = function (equipment, ship, context) {
    if (context === "scripted") return true;
    if (equipment === "EQ_FUEL") {
        if (system.ID === -1) return true;
        var fe = worldScripts.FuelTweaks_FuelEconomy;
        if (fe._fuelNormal === true) return true;
        if (fe.$isFuelAvailable() === true && fe.$fuelRationsInUse() === false && fe.$isRefuelStationAvailable() === false) return true;
        return false;
    }

    if (equipment === "EQ_FUEL_STORAGE") {
        var sts = ship.equipmentStatus("EQ_FUEL_PROCESSOR");
        if (sts === "EQUIPMENT_OK" || sts === "EQUIPMENT_DAMAGED") return true;
        return false;
    }

    if (equipment === "EQ_PIRATE_FUEL") {
        var fe = worldScripts.FuelTweaks_FuelEconomy;
        if (fe._fuelNormal === true) return false;
        if (fe.$isFuelAvailable() === true && fe.$fuelRationsInUse() === false && fe.$isRefuelStationAvailable() === false) return false;
        if (system.economy < 4) return false;
        if (ship.dockedStation.allegiance === "pirate" || ship.dockedStation.allegiance === "chaotic") return true;
        return false;
    }

    var list = ["EQ_FUEL_ALT1", "EQ_FUEL_ALT2", "EQ_FUEL_ALT3", "EQ_FUEL_ALT4", "EQ_FUEL_ALT5", "EQ_FUEL_ALT6"]
    if (list.indexOf(equipment) >= 0) {
        if (system.ID === -1) return false;
        var fe = worldScripts.FuelTweaks_FuelEconomy;
        if (fe._fuelNormal === true) return false;
        if (fe.$fuelRationsInUse() === false) return false;
        var info = EquipmentInfo.infoForKey(equipment);
        var max = parseInt(info.scriptInfo["fuel_amount"]);
        if (max > fe.$getMaxFuelRation()) return false;

        var req = parseInt(7 - player.ship.fuel);
        if (max > req) return false;
        //if ((max - 1) < req) return false; // this would only allow the highest ration amount to be shown

        // check the station allegiance
        var alleg = ship.dockedStation.allegiance;
        if (alleg == null) alleg = "neutral";
        if (fe._fuelAllegiance.indexOf(alleg) === -1) return false; // fe._fuelAllegiance.length > 0 && 
        // not available if we've already got our ration from this station.
        if (ship.dockedStation && fe._emergencyFuel.indexOf(ship.dockedStation.displayName) >= 0) return false;
        // might add further conditions here.
    }
    return true;
}

//-------------------------------------------------------------------------------------------------------------
this.updateEquipmentPrice = function (equipment, price) {
    var newprice = price;
    var p = player.ship;
    if (equipment === "EQ_PIRATE_FUEL") {
        newprice = ((7 - p.fuel) * 10) * price;
    }
    // in case our condition script has won the install race via equipment-overrides
    if (equipment == "EQ_FUEL" && player.ship.dockedStation.dataKey == "KW_II") {
        newprice = worldScripts["oolite-II"].updateEquipmentPrice(equipment, price);
    }
    return newprice;
}