"use strict";
this.name = "ftz_market";
this.author = "spara";
this.copyright = "2014 spara";
this.license     = "CC BY-NC-SA 4.0";

this.$originalDefs = {
      "food" : [0, 0, 21, 1, 2, 0, 1, 1, 0],
      "textiles" : [0, 0, 16, 1, 3, -5, 3, 7, 0],
      "radioactives" : [0, 0, 52, 1, 3, -5, 3, 7, 0],
      "slaves" : [0, 0, 20, 0, 0, 10, 15, 0, 0],
      "liquor_wines" : [0, 0, 75, 1, 2, 4, 1, 1, 0],
      "luxuries" : [0, 0, 170, -3, -1, -5, 31, 3, 0],
      "narcotics" : [0, 0, 235, 29, 0, 0, 120, 0, 0],
      "computers" : [0, 0, 140, -7, -1, -3, 15, 7, 0],
      "machinery" : [0, 0, 105, -4, -1, 0, 7, 7, 0],
      "alloys" : [0, 0, 75, -1, -1, 10, 3, 31, 0],
      "firearms" : [0, 0, 124, -7, -1, -2, 15, 3, 0],
      "furs" : [0, 0, 135, 3, 2, 3, 7, 1, 0],
      "minerals" : [0, 0, 18, 3, 3, 9, 3, 7, 0],
      "gold" : [0, 0, 102, 1, 0, 0, 20, 0, 1],
      "platinum" : [0, 0, 181, 2, 0, 0, 21, 0, 1],
      "gem_stones" : [0, 0, 50, 1, 0, 0, 15, 0, 2],
      "alien_items" : [0, 0, 10, 1, 0, 0, 7, 0, 0]
};

this.updateLocalCommodityDefinition = function(goodDefinition) {
	var commodity = goodDefinition.key;
	var oldDefs = this.$originalDefs[commodity];
	//old style definition found for the good. calculate it the old way
	if (oldDefs) {
		var market_base_price = oldDefs[2];
		var market_eco_adjust_price = oldDefs[3];
		var market_eco_adjust_quantity = oldDefs[4];
		var market_base_quantity = oldDefs[5];
		var market_mask_price = oldDefs[6];
		var market_mask_quantity = oldDefs[7];
		var market_rnd = Math.floor(Math.random() * 256);

		var economy = system.economy;

		var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
		price *= 0.4;

		var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
		if (quantity > 127) quantity = 0;
		quantity &= 63;

		goodDefinition.price = price * 10;
		goodDefinition.quantity = quantity;
	} else {
		// hit or miss variation
		var price = goodDefinition.price * (1 + (system.scrambledPseudoRandomNumber(clock.days) * 0.6 - 0.3));
		// make sure there aren't lots of units to buy if the price is cheaper
		if (price < goodDefinition.price && goodDefinition.quantity > 0) {
			goodDefinition.quantity = parseInt(goodDefinition.quantity * 0.5);
		}
	}
	return goodDefinition;
};
