this.name			= "alien_systems";
this.author			= "Redspear";
this.copyright		= "2022 Redspear";
this.licence		= "CC BY-NC-SA 4.0"; 
this.description	= "System variance by inhabitant type";
this.version		= "0.4";

"use strict";

this.startUp = function() {
	_alienVisa = 0;	//	set jump restrictions
	
	var msi = worldScripts.MarketScriptInterface_Main;
	msi.$addMarketInterface("system_local", "$updateLocalCommodity", this.name, "highest");
}

this.guiScreenChanged = function () {//	'fleshing' out the planet descriptions a bit	

	var hud0 = 0;	//	set up HUD removal when viewing f7 screen
		
	if (guiScreen === "GUI_SCREEN_SYSTEM_DATA") {	//	f7 screen accessed
		var sys = System.infoForSystem(galaxyNumber, player.ship.infoSystem);
		var desc = sys.description;
		var eco = sys.economy;
		var inhab = sys.inhabitants;
		var birds = /bird/i;
		var felines = /feline/i;
		var frogs = /frog/i;
		var humanoids = /humanoid/i;
		var insects = /insect/i;
		var lizards = /lizard/i;
		var lobsters = /lobster/i;
		var rodents = /rodent/i;
		
		player.ship.hudHidden = true;	//	hide HUD
		var hud0 = 1;
	
		if (inhab.match(birds)) {
			//	bird systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Sharp visual acuity tends to make for astute traders.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Birds are an ancient and aloof people with much to teach us and little inclination to do so.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Not all birds can fly but those that can tend to reason that being 'above' others is merely a statement of fact.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("Being asked to keep the eggs warm for a moment is an unlikely honour that few outsiders ever merit.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("According to local lore, there's nothing more masculine that singing a high note.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Avians particularly distrust humanoids. In this regard humanoids would tend to agree with them.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("One way or another, feathers tend to make for costly souvenirs.");
			}
		}
		
		if (inhab.match(felines))	{
			//	feline systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Felines have contributed more pirates, bounty hunters and freebooters to the spaceways than anyone else.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Felines tend to respect power, skill and ruthlessness. In this regard they're much like everyone else.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Lasers are popular here, always have been.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("When offered a dead tourist, the official GalCop recommendation is to graciously accept.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("Don't be put off by the locals' predatory demeanor, but don't ignore it either.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Felines tend to like rodents; a relationship that is seldom reciprocated.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("While rumours abound of successful trade deals involving offers to mate, they are mostly exaggerated.");
			}
		}
			
		if (inhab.match(frogs))	{
			//	frog systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Frogs are masters of the inscrutable stare.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Croak meters are popular gadgets for male and female frogs alike.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Visitors often complain about inaccessible stairways.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("The local cuisine is often somewhat challenging to the visitor's pallette.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("GalCop tourist advice describes the local Spawning Pools as follows: 'Best avoided'.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Frogs are highly variable in size, colour and aggression.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("The more diminuitive, insect trader is strongly advised to remain in their ship while docked here.");
			}
		}
			
		if (inhab.match(humanoids))	{
			//	humanoid systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Humanoids are a highly variable group, such that grouping them is difficult.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Humanoid origins are unclear and attempts at drawing attention to such are frequently considered unwise.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Prejudice might seem more unlikely on a world with such a diverse population but local ingenuity finds a way.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("Do you remember that scene from the cantina in a certain space opera? Some say it's not worth the trouble.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("GalCop advice describes the local welcome as such: 'absent by default'.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Humanoids aren't generally renowned for their friendliness. Of all the other groups, they dislike humans the most.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("Use of the following descriptors is forbidden: 'bastard', 'cross', 'hybrid', 'mongrel', 'mutant', and, of course, 'weirdo'.");
			}
		}
			
		else if (inhab.match(insects))	{
			// insect systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Insects are known for making limited cultural distinctions betwen visitors and slaves.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Once established, insect colonies grow rapidly.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Gruesome legends of visitors ascending 'sky towers' persist to this day, along with their grizzly endings.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("Flight, six limbs, powerful jaws and superb senses are sadly of limited use to insect comedians.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("GalCop advises that to avoid unwanted attention, travel with a lizard. GalCop further advises that to avoid being eaten, never travel with a lizard.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Insects tend to have a very practical outlook with regards to alien relations. They have little respect for anyone.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("It is rumoured that there are insect cells across the galaxy, secretly controlling the...");
			}
		}
			
		if (inhab.match(lizards))	{
			// lizard systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Lizards are often large and even more often indiscriminate in their dietary choices.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Lizards are an ancient and powerful group but seldom expansionist due to their particular climatic requirements.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("There's no reason to assume that a lizard might eat you but there's a very good reason not to rule it out.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("'The way to a lizard's stomach is through his heart', is an oft misunderstood local saying.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("Local cuisine is often described, somewhat disconcertingly, as 'inclusive'.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("The 'harmless' designation assigned to some lizard groups has recently been called into question after the disappearance of several GalCop diplomats.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("Trader's wisdom has it that all trading here should be concluded strictly post-dining.");
			}
		}
			
		if (inhab.match(lobsters))	{
			// lobster systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Lobsters have a reputation for being unhappy, especially with everyone else.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Water worlds tend to make the best lobster habitats. Xenobehaviouralists have hypothesised a correlation between their scarcity and Lobster 'hospitality'.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Your inconvenience is often their amusement.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("They say that if a lobster likes you then it was only a momentary lapse of judgement.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("Elasticated ties of all kinds are extremely hard to acquire here.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Lobster officials wish it to be known that they know things that you don't.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("Lobsters are unimpressed by pushy traders. Exactly when a lobster is impressed however has proved frustratingly difficult to discern.");
			}
		}
			
		if (inhab.match(rodents))	{
			// rodent systems
			if (player.ship.infoSystem < 36) {	
				mission.addMessageText("");
				mission.addMessageText("Rodents are a highly adaptable and opportunistic group.");
			}
			else if (player.ship.infoSystem < 72) {
				mission.addMessageText("");
				mission.addMessageText("Having an inhabitabnt type that could be classed as vermin in some systems is not without its issues.");
			}
			else if (player.ship.infoSystem < 108) {
				mission.addMessageText("");
				mission.addMessageText("Often badmouthed by other inhabitant types, rodents are not above using their reputation to their advantage.");
			}
			else if (player.ship.infoSystem < 144) {
				mission.addMessageText("");
				mission.addMessageText("Translation can be confusing where 'dirty' and 'stolen' are synonymous with 'homely' and 'treasured'.");
			}
			else if (player.ship.infoSystem < 180) {
				mission.addMessageText("");
				mission.addMessageText("All you can eat franchises tend to avoid worlds like this one.");
			}
			else if (player.ship.infoSystem < 216) {
				mission.addMessageText("");
				mission.addMessageText("Rodents find their way onto most worlds and outposts but here they are dominant.");
			}
			else {
				mission.addMessageText("");
				mission.addMessageText("It's not uncommom to agree a price with one rodent only to find the deal concluded by another and at a new price.");
			}
		}
	}
	else	{	//	not f7 screen
			if (hud0 = 1)	{	//	was f7 screen
			player.ship.hudHidden = false;	//	restore HUD
			}
		}
}


this.shipWillEnterWitchspace = function() {
	Sound.stopMusic();
}

this.shipExitedWitchspace = function() {
    var birds = /bird/i;
    var felines = /feline/i;
    var frogs = /frog/i;
    var humanoids = /humanoid/i;
    var insects = /insect/i;
    var lizards = /lizard/i;
    var lobsters = /lobster/i;
    var rodents = /rodent/i;
    var colonials = /colonial/i;
	
	if(system.isInterstellarSpace)
	{
		Sound.playMusic("Reorte_Theme.ogg");
	}
    if(system.info.inhabitants.match(birds))
    {
		Sound.playMusic("Isinor_Theme.ogg");
		player.commsMessage("[bird-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.5) + Math.floor(Math.random() + 0.5) + Math.floor(Math.random() + 0.5) + Math.floor(Math.random() + 0.5) + Math.floor(Math.random() + 0.5));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 5;
				break;
			}
		}
    }
    if(system.info.inhabitants.match(felines))
    {
		Sound.playMusic("Tianve_Theme.ogg");
		player.commsMessage("[feline-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.3) + Math.floor(Math.random() + 0.3) + Math.floor(Math.random() + 0.3));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 3;
				break;
			}
		}
    }
    if(system.info.inhabitants.match(frogs))
    {
        Sound.playMusic("Lerelace_Theme.ogg");
		player.commsMessage("[frog-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.2) + Math.floor(Math.random() + 0.2));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 2;
				break;
			}
		}
    }
    if(system.info.inhabitants.match(humanoids))
    {
        Sound.playMusic("Leesti_Theme.ogg");
		player.commsMessage("[humanoid-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 4;
				break;
			}
		}
	}
    if(system.info.inhabitants.match(insects))
    {
        Sound.playMusic("Diso_Theme.ogg");
		player.commsMessage("[insect-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.3) + Math.floor(Math.random() + 0.3) + Math.floor(Math.random() + 0.3) + Math.floor(Math.random() + 0.3));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 3.5;
				break;
			}
		}
    }
    if(system.info.inhabitants.match(lizards))
    {
        Sound.playMusic("Tionisle_Theme.ogg");
		player.commsMessage("[lizard-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4) + Math.floor(Math.random() + 0.4));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 4.5;
				break;
			}
		}
    }
    if(system.info.inhabitants.match(lobsters))
    {
        Sound.playMusic("Zaonce_Theme.ogg");
		player.commsMessage("[lobster-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.2) + Math.floor(Math.random() + 0.2) + Math.floor(Math.random() + 0.2));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 2.5;
				break;
			}
		}
    }
    if(system.info.inhabitants.match(rodents))
    {
        Sound.playMusic("Teraed_Theme.ogg");
		player.commsMessage("[rodent-beacon-messsages]", 6);
		
		this.$updateLocalCommodity = function (goodDefinition, station, systemID) {
	
		if (!systemID || systemID == -1 || station) return goodDefinition;
		var new_stock; // stocking variation
	
		switch (goodDefinition.key) {
			case "alien_items":
				new_stock = (Math.floor(Math.random() + 0.1) + Math.floor(Math.random() + 0.1));
				if (new_stock < 0) { new_stock = 0 };
				goodDefinition.quantity = new_stock;
				goodDefinition.price *= 1.5;
				break;
			}
		}
    }	
}

this.shipEnteredPlanetaryVicinity = function(entity)
{
	if(entity.isSun) {
		Sound.playMusic("Lave_Theme.ogg");
		_alienVisa = 1;
	}
}

this.shipExitedPlanetaryVicinity = function(entity)
{
    if(entity.isSun) {
		_alienVisa = 0;
	}
}

this.playerStartedJumpCountdown = function(type)
{
	if (type = "standard") {
		if (System.infoForSystem(galaxyNumber, player.ship.targetSystem).inhabitants.match(/colonial/i)) {
			player.consoleMessage ("Colonial Target System");	//	no visa required
		}
		else {
		if (manifest.alien_items > 0) {
			player.ship.cancelHyperspaceCountdown();
			player.consoleMessage ("Target System Valid");	//	valid 'visa'
		}
		else {
		if (_alienVisa == 0) {
			player.ship.cancelHyperspaceCountdown();
			player.consoleMessage ("Target System Restricted");	//	nice try human scum! :-p
		}
		else {
			player.consoleMessage ("Target System...");
			player.consoleMessage ("... Accepted");	//	visa test... dodged
		}
		}
	}
	}
}

this.shipEnteredStationAegis = function(station) {
    if (station.isMainStation) {
		Sound.stopMusic();
        this.$startTimer();
	var birds = /bird/i;
    var felines = /feline/i;
    var frogs = /frog/i;
    var humanoids = /humanoid/i;
    var insects = /insect/i;
    var lizards = /lizard/i;
    var lobsters = /lobster/i;
    var rodents = /rodent/i;
    var colonials = /colonial/i;
	
    if(system.info.inhabitants.match(birds))
    {
		Sound.playMusic("Isinor_Theme.ogg");
    }
    if(system.info.inhabitants.match(felines))
    {
		Sound.playMusic("Tianve_Theme.ogg");
    }
    if(system.info.inhabitants.match(frogs))
    {
        Sound.playMusic("Lave_Theme.ogg");
    }
    if(system.info.inhabitants.match(humanoids))
    {
        Sound.playMusic("Leesti_Theme.ogg");
    }
    if(system.info.inhabitants.match(insects))
    {
        Sound.playMusic("Diso_Theme.ogg");
    }
    if(system.info.inhabitants.match(lizards))
    {
        Sound.playMusic("Tionisle_Theme.ogg");
    }
    if(system.info.inhabitants.match(lobsters))
    {
        Sound.playMusic("Zaonce_Theme.ogg");
    }
    if(system.info.inhabitants.match(rodents))
    {
        Sound.playMusic("Teread_Theme.ogg");
    }
    }
}

this.shipLaunchedFromStation = function(station) {
    if (station.isMainStation) {
        this.$startTimer();
	var birds = /bird/i;
    var felines = /feline/i;
    var frogs = /frog/i;
    var humanoids = /humanoid/i;
    var insects = /insect/i;
    var lizards = /lizard/i;
    var lobsters = /lobster/i;
    var rodents = /rodent/i;
    var colonials = /colonial/i;
	
    if(system.info.inhabitants.match(birds))
    {
		Sound.playMusic("Isinor_Theme.ogg");
    }
    if(system.info.inhabitants.match(felines))
    {
		Sound.playMusic("Tianve_Theme.ogg");
    }
    if(system.info.inhabitants.match(frogs))
    {
        Sound.playMusic("Lave_Theme.ogg");
    }
    if(system.info.inhabitants.match(humanoids))
    {
        Sound.playMusic("Leesti_Theme.ogg");
    }
    if(system.info.inhabitants.match(insects))
    {
        Sound.playMusic("Diso_Theme.ogg");
    }
    if(system.info.inhabitants.match(lizards))
    {
        Sound.playMusic("Tionisle_Theme.ogg");
    }
    if(system.info.inhabitants.match(lobsters))
    {
        Sound.playMusic("Zaonce_Theme.ogg");
    }
    if(system.info.inhabitants.match(rodents))
    {
        Sound.playMusic("Teread_Theme.ogg");
    }
    }
}

this.shipExitedStationAegis = function(station) {
    if (station.isMainStation) {
        this.$stopTimer();
    }
}

this.shipDockedWithStation = function(station) {
    if (station.isMainStation) {
        this.$stopTimer();
    }
}

this.shipDied = function() {
    this.$stopTimer();
}

this.$startTimer = function $startTimer () {
    this.$stopTimer(); // safety check
    this._myTimer = new Timer(this, this.$sendMessageTimer, 60, 120); // first and subsequent
}

this.$stopTimer = function $stopTimer () {
    if (this._myTimer && this._myTimer.isRunning) this._myTimer.stop();
}

this.$sendMessageTimer = function $sendMessageTimer () {
    var p = player.ship;
    var stn = system.mainStation;
    var dist = p.position.distanceTo(stn.position);
    if (dist < stn.scannerRange) { // only send a message if the player is within scanner range
        if (p.alertCondition != 3) { // only send if the player is not at condition red
            this.$sendStationMessage();
        }
    }
}

this.$sendStationMessage = function $sendStationMessage () {
    var birds = /bird/i;
    var felines = /feline/i;
    var frogs = /frog/i;
    var humanoids = /humanoid/i;
    var insects = /insect/i;
    var lizards = /lizard/i;
    var lobsters = /lobster/i;
    var rodents = /rodent/i;
    var colonials = /colonial/i;
	
    if(system.info.inhabitants.match(birds) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[bird-messages]", 6);
    }
    if(system.info.inhabitants.match(felines) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[feline-messages]", 6);
    }
    if(system.info.inhabitants.match(frogs) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[frog-messages]", 6);
    }
    if(system.info.inhabitants.match(humanoids) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[humanoid-messages]", 6);
    }
    if(system.info.inhabitants.match(insects) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[insect-messages]", 6);
    }
    if(system.info.inhabitants.match(lizards) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[lizard-messages]", 6);
    }
    if(system.info.inhabitants.match(lobsters) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[lobster-messages]", 6);
    }
    if(system.info.inhabitants.match(rodents) && system.techLevel < 12)
    {
        system.mainStation.commsMessage("[rodent-messages]", 6);
    }		
}