"use strict";
this.name        = "LongWayRound";
this.author      = "aegidian, phkb";
this.copyright   = "2018 phkb";
this.description = "Script for Long Way Round mission - original script by aegidian, JS script by phkb.";
this.licence     = "CC BY-NC-SA 3.0";

this._counter = 0;
this._timer = null;

this.startUp = function() {
    if (missionVariables.longwayround === "MISSION_COMPLETE") {
        delete this.missionScreenOpportunity;
        delete this.shipExitedWitchspace;
        delete this.startUp;
    }
}

this.missionScreenOpportunity = function() {
    if (player.ship.dockedStation.isMainStation && galaxyNumber === 0) {
        if (!missionVariables.longwayround && system.ID === 3) {
            // show mission screen
            mission.runScreen(
                {
                    screenID: "longwayround",
                    title: "Incoming Message",
                    exitScreen: "GUI_SCREEN_STATUS",
                    messageKey: "long_way_round_Biarge_briefing"
                } 
            );
            missionVariables.longwayround = "STAGE1";
            mission.markSystem({system:248, name:this.name});
            mission.setInstructionsKey("em1_short_desc1", this.name);
            return;
        }
        if (missionVariables.longwayround === "STAGE1" && system.ID === 248) {
            // show mission screen
            mission.runScreen(
                {
                    screenID: "longwayround",
                    title: "Incoming Message",
                    exitScreen: "GUI_SCREEN_STATUS",
                    messageKey: "long_way_round_Soladies_briefing"
                } 
            );
            missionVariables.longwayround = "STAGE2";
            player.credits += 500;
            player.consoleMessage("You have been awarded 500cr.");
            mission.unmarkSystem({system:248, name:this.name});
            mission.markSystem({system:233, name:this.name});
            mission.setInstructionsKey("em1_short_desc2", this.name);
            return;
        }
        if (missionVariables.longwayround === "STAGE2" && system.ID === 233) {
            // show mission screen
            mission.runScreen(
                {
                    screenID: "longwayround",
                    title: "Incoming Message",
                    overlay: "loyalistflag.png",
                    exitScreen: "GUI_SCREEN_STATUS",
                    messageKey: "long_way_round_Qubeen_briefing"
                } 
            );
            missionVariables.longwayround = "MISSION_COMPLETE";
            player.credits += 2000;
            player.consoleMessage("You have been awarded 2000cr.");
            mission.unmarkSystem({system:233, name:this.name});
            mission.setInstructionsKey(null, this.name);
            delete this.shipExitedWitchspace;
            delete this.missionScreenOppportunity;
            return;
        }
    }
}

this.shipExitedWitchspace = function() {
    if (galaxyNumber === 0 && system.ID === 233 && missionVariables.longwayround === "STAGE2") {
        this._counter = 0;
        this._timer = new Timer(this, this.$addExtraShips, 1, 1);
        system.addShips("longWay_rebel", 2);
    }
}

this.$addExtraShips = function $addExtraShips() {
    if (player.ship.isValid === false || player.ship.isInSpace === false) {
        this._timer.stop();
        return;
    }
    this._counter += 1;
    if (this._counter < 60) {
        if (system.countShipsWithPrimaryRole("longWay_rebel") < 5) {
            if (Math.random() < 0.5) {
                system.addShips("longWay_rebel", 1);
            }
        }
    } else {
        this._timer.stop();
    }
}