"use strict";
this.name = "FuelSatellite";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Script for fuel satellite";
this.version = "2.3";

this.shipSpawned = function () { //  line the station up with the route one. Code borrowed from Anarchies for convenience.
	this.ship.scannerDisplayColor1 = "greenColor";
	this.ship.scannerDisplayColor2 = "darkGrayColor";

	if (system.isInterstellarSpace || !system.mainPlanet) { return; }
	var targetVector = system.mainPlanet.position.subtract(this.ship.position).direction()
	var angle = this.ship.heading.angleTo(targetVector)
	var cross = this.ship.heading.cross(targetVector).direction()
	this.ship.orientation = this.ship.orientation.rotate(cross, -angle);
	// this.setColour();
	this.setPrice();
	this.maxAmount = worldScripts["FuelStation-Setup"].maxSatelliteAmount;
	this.dispensed = 0;
}

//this.setColour = function()
//	{
//	this.colRand = system.scrambledPseudoRandomNumber(45.32)
//	colName = "yellowColor";
//	if(this.colRand < 0.25) { colName = "blueColor"; }
//	if(this.colRand < 0.75) { colName = "redColor"; }
//	if(this.colRand > 0.25 && this.colRand < 0.5) { colName = "magentaColor"; }
//	this.ship.setMaterials({"fuelStation_satellite.png": { diffuse: colName }});
//	}	

this.setPrice = function () {
	this.fuelPrice = 0.15 * EquipmentInfo.infoForKey("EQ_FUEL").price * player.ship.fuelChargeRate; // price per 0.1LY of fuel
	if (system.economy === 0 || system.economy === 5) { this.fuelPrice *= 1.2; } //  rich industrial or agricultural
	if (system.techLevel > 4 && system.techLevel < 11) { this.fuelPrice *= 1.1; } //  mid-tech level
	this.fuelPrice = this.decPlaces(this.fuelPrice, 2);
}

this.decPlaces = function (number, places) {
	if (!places || places < 0) { places = 0; }
	if (!number) { return 0; }
	return ((Math.round(number * Math.pow(10, places))) / Math.pow(10, places));
}

this.playerDetected = function () {
	if (this.dispensed >= this.maxAmount) {
		if (this.scanTimer && this.scanTimer.isRunning) this.scanTimer.stop();
		return;
	}
	this.firstMessage = true;
	this.secondMessage = true;
	this.thirdMessage = true;
	this.fuelTransferred = 0; // how many 0.1LY units are transferred
	this.fuelBill = 0;
	var msg = "Greetings Commander " + player.name + ". Refuel here for only " + this.decPlaces((10 * this.fuelPrice), 1) + " credits per ly.";
	if (this.maxAmount < 7) {
		msg += " Limit of " + this.maxAmount + "ly per ship.";
	}
	this.ship.commsMessage(msg, player.ship);
	if (this.scanTimer) {
		this.scanTimer.start();
	} else {
		this.scanTimer = new Timer(this, this.locatePlayer, 0, 0.50);
	}
}

this.locatePlayer = function () {
	if (!this.ship || !this.ship.isValid || !this.ship.position || !player.ship.isValid) { // if the ship no longer exists but timer is running, e.g. if player has jumped whilst near a satellite into a system without one
		this.$stopSound();
		this.playerGone();
		return;
	}

	if (this.ship.position.distanceTo(player.ship.position) < 150) { // player ship within 150m of the centre of the satellite
		if (player.ship.fuel < 7 && this.dispensed < this.maxAmount) {
			if (player.credits > this.fuelBill) { // player in place, fuel tank not full and credit balance not empty
				player.ship.fuel += 0.1;
				this.dispensed += 0.1;
				this.fuelBill += this.fuelPrice;
				this.fuelTransferred++;

				if (this.firstMessage) {
					this.$playSound("fuelflow");
					player.consoleMessage("Fuel transfer is underway, please come to a halt.", 6);
					this.firstMessage = false;
				}
				return;
			} else { // not enough funds left
				if (this.secondMessage) {
					player.consoleMessage("Insufficient credits remaining for further transfer.", 6);
					this.$playSound("fuelshutoff");
					this.secondMessage = false;
				}
				return;
			}
		} else { // Fuel tank full
			if (player.ship.fuel < 7) {
				if (this.thirdMessage) {
					player.consoleMessage("Ship transfer limit reached.", 6);
					this.$playSound("fuelshutoff");
					this.thirdMessage = false;
				}
			} else {
				if (this.thirdMessage) {
					player.consoleMessage("Fuel tanks are full.", 6);
					this.$playSound("fuelshutoff");
					this.thirdMessage = false;
				}
			}
			return;
		}
	} else {
		if (this.fuelTransferred > 0) {
			this.fuelBill = this.decPlaces(this.fuelPrice * this.fuelTransferred, 1);
			player.consoleMessage("Summary - " + (this.fuelTransferred / 10) + " ly transferred, " + this.fuelBill + " credits charged.", 6);
			player.credits -= this.fuelBill;
			this.fuelTransferred = 0;
			this.fuelBill = 0;
			this.firstMessage = true;
			this.secondMessage = true;
			this.thirdMessage = true;
		}
	}
}

this.playerWillEnterWitchspace = this.playerGone = function () {
	if (this.scanTimer) {
		this.scanTimer.stop();
		delete this.scanTimer;
	}
}

this.shipDied = function (whom, why) {
	this.playerGone();
	this.fuelCount = (Math.ceil(Math.random() * 30) + 30);
	this.ship.spawn("fuelStation_burningFuel", this.fuelCount); // lets make this go with a bang!

	if (whom && whom.isPlayer) {
		player.consoleMessage("CCTV beam towards the main station detected.", 6);
		player.score -= 1; // don't condone vandalism!
		player.bounty += 20;
	}
}

this.attackedMessage = function () {
	this.ship.commsMessage("ALERT - fuel satellite under attack, explosion danger!");
}

//-------------------------------------------------------------------------------------------------------------
// plays the sound of the fuel being filled
this.$playSound = function $playSound(type) {
	if (this._mySound && this._mySound.isPlaying) this._mySound.stop();
	this._mySound = new SoundSource;
    switch (type) {
        case "fuelflow":
            this._mySound.sound = "fs_fuelflow.ogg";
			this._mySound.loop = true;
            break;
		case "fuelshutoff":
            this._mySound.sound = "fs_fuelshutoff.ogg";
			this._mySound.loop = false;
    }
	this._mySound.play();
}

//-------------------------------------------------------------------------------------------------------------
this.$stopSound = function() {
	if (this._mySound && this._mySound.isPlaying) {
		this._mySound.stop();
	}
	this._mySound = null;
}
