"use strict";
this.name = "planetFall2_trainFX";
this.author = "Svengali & Thargoid";
this.copyright = "CC-by";
this.description = "FX script";
this.version = "1.0";

this.effectSpawned = function () {
	this.firstFrame = true;
	this.getRid = 0;
    this.zooming = 0;
	this.mult = worldScripts.PlanetFall2.fx_mult;
	// orient the visual effect
    this.visualEffect.orientation = player.ship.orientation;
	// start the frame callback
	this.ovFCBID = addFrameCallback(this.repos.bind(this));
	player.ship.hudHidden = true;
}

this.effectRemoved = function () { 
	removeFrameCallback(this.ovFCBID); 
}

this.repos = function (delta) {
	var p = player.ship;
	if (!p.isValid || this.getRid >= 3) {
		this.visualEffect.remove();
		return;
	}

	if (this.firstFrame || !delta) {
		this.firstFrame = false;
		return;
	}

	this.visualEffect.position = p.position.add(p.vectorForward.multiply(worldScripts.PlanetFall2.fx_launch_dist));
	this.visualEffect.orientation = p.orientation;
    this.visualEffect.scale(1 + this.zooming);
    this.zooming += delta * this.mult;
	this.getRid += delta; // to get the effect finished before true launch into realspace
	return;
}
