"use strict";
this.name = "planetFall2_landingFX";
this.author = "Svengali & Thargoid, phkb";
this.copyright = "CC-by";
this.description = "FX script";
this.version = "1.0";

this.effectSpawned = function () {
	this.getRid = 0;
	this.zooming = 0;
	this.slide = worldScripts.PlanetFall2.fx_start;
	this.forward = worldScripts.PlanetFall2.fx_land_dist;
	this.step = worldScripts.PlanetFall2.fx_step;
	this.padFilename = worldScripts.PlanetFall2.fx_landing_pad_filename;
	this.firstFrame = true;
	this.changed = false;
	// size and align ve
	this.visualEffect.scale(0.81);
	this.visualEffect.orientation = player.ship.orientation;
	// start the frame callback
	this.ovFCBID = addFrameCallback(this.repos.bind(this));
}

this.effectRemoved = function () {
	removeFrameCallback(this.ovFCBID);
}

this.repos = function (delta) {
	var p = player.ship;
	if (!p.isValid || this.getRid > 2.5) {
		this.visualEffect.remove();
		return;
	}

	if (this.firstFrame || !delta) {
		this.firstFrame = false;
		return;
	}

	if (this.getRid <= 1.7) {
		this.slide += this.step;
		this.visualEffect.position = p.position.add(p.vectorForward.multiply(this.forward)).add(p.vectorUp.multiply(this.slide));
		this.visualEffect.orientation = p.orientation;
	}
	if (this.getRid > 1.7) {
		if (this.changed == false) {
			this.changed = true
			this.visualEffect.setMaterials({
				"planetFall2_clouds.png": {
					fragment_shader: "planetFall2_breakPattern.fragment",
					vertex_shader: "planetFall2_breakPattern.vertex",
					textures: [this.padFilename],
				}
			});
		}
		this.visualEffect.position = p.position.add(p.vectorForward.multiply(this.forward));
		this.visualEffect.orientation = p.orientation;
		this.zooming += delta;
		this.visualEffect.scale(0.81 + (this.zooming / 10));
	}
	this.getRid += delta;
	return;
}
