"use strict";
this.name = "PlanetFall2_Conditions";
this.author = "phkb";
this.copyright = "CC-BY-SA-NC 4.0";
this.description = "Condition script";

//-------------------------------------------------------------------------------------------------------------
// equipment condition script
this.allowAwardEquipment = function(equipment, ship, context) {
    if (equipment == "EQ_RENOVATION") {
        if (worldScripts.PlanetFall2._config.moveRenovation == true && player.ship.dockedStation && player.ship.dockedStation.hasRole("planetFall2_mainSurface") == false) {
            return false;
        }
    }

    // OXP hook to allow stations to forbid specific equipment
	if (context == "purchase" && player.ship.dockedStation && player.ship.dockedStation.scriptInfo["oolite-barred-equipment"])
	{
		if (player.ship.dockedStation.scriptInfo["oolite-barred-equipment"].indexOf(equipment) != -1)
		{
			return false;
		}
	}

	// OXP hook to allow ships to forbid specific "available to all" equipment
	if (ship.scriptInfo && ship.scriptInfo["oolite-barred-equipment"] && ship.scriptInfo["oolite-barred-equipment"].indexOf(equipment) != -1)
	{
		return false;
	}

	// otherwise allowed
	return true;
}

//-------------------------------------------------------------------------------------------------------------
// ship condition script
this.allowSpawnShip = function(shipKey) {
	switch (shipKey) {
		case "planetFall_mainSurface_OoHaulDist":
			if (!worldScripts.PlanetFall_Oohaul) return false;
			if (system.government > 0 && system.population > 30) return true;
			break;
		case "planetFall_mainSurface_blackMonks":
		case "planetFall_subSurface_blackMonks":
		case "planetFall_moonSurface_blackMonks":
			if (!worldScripts.blackmonks) return false;
			if (worldScripts.blackmonks.$monkSystemIDs.indexOf(system.ID) >= 0) return true;
			break;
		case "planetFall_mainSurface_hoopyCasino":
		case "planetFall_subSurface_hoopyCasino":
		case "planetFall_moonSurface_hoopyCasino":
			if (!worldScripts["hoopy_populator"]) return false;
			if (system.techLevel >= 10 && system.government != 4 || system.info.description.indexOf('hoopy casinos') > -1) return true;
			break;
	}
	return false;
}