"use strict";
this.name = "PlanetFall2_Names";
this.author = "Littlebear, phkb";
this.copyright = "Creative Commons Attribution - Non-Commercial - Share Alike 3.0 license with clauses - see readme.txt.";
this.description = "Naming routines for planetfall stations";

/*
	This script will give each landing site a unique name. Names are either generated, or retrieved from saved data. 
	If you reload a system without saving, all planetary locations will have new names (although the type site will be the same)
	Once the names for a system have been saved, they will remain consistent over time.
*/

this.nameStore = {};

this.rsnInUse = false;

this.planetFall_opening_words1_alt = [
	"Centre", "Hub", "Facility"
];

this.planetFall_opening_words1_alt4 = [
	"Information", "Trade", "Tourism", "Commerce"
];

this.planetFall_opening_words1_alt5 = [
	"Ground", "Immigration", "Traffic", "Passport", "Customs"
];

this.planetFall_opening_words1_alt6 = [
	"GalCop", "Imperial", "Federation", "Planetary"
];

this.planetFall_opening_words2_alt = [
	"Facility", "Complex", "Centre", "Depot"
];

this.planetFall_opening_words3_alt = [
	"Military", "Naval", "Airforce", "Army"
];

this.planetFall_opening_words3_alt2 = [
	"Base", "Compound", "Headquarters", "Outpost"
];

this.planetFall_opening_words4_alt = [
	"Cafe", "Restaurant"
];

this.planetFall_opening_words4_alt2 = [
	"Seedy", "Underground", "Disreputable", "Insalubrious", "Sketchy"
];

this.planetFall_opening_words4_alt3 = [
	"Joint", "Club"
];

this.planetFall_opening_words4_alt3a = [
	"House", "Bar"
];

this.planetFall_opening_words4_alt4 = [
	"Tavern", "Establishment"
];

this.planetFall_opening_words5a = [
	"Industrial", "Manufacturing", "Urban"
];

this.planetFall_opening_words5b = [
	"Zone", "District", "Complex", "Area", "Heartland", "Sector", "Region", "Quadrant"
];

this.planetFall_opening_words6a = [
	"Agricultural", "Rural", "Pastoral", "Horticultural", "Arable"
];

this.planetFall_opening_words6b = [
	"Zone", "District", "Area", "Sector", "Region", "Quadrant"
];

this.planetFall_opening_words7a = [
	"Corn", "Rice", "Barley", "Poppy", "Tulip", "Orchid", "Potato", "Tobacco"
];

this.planetFall_opening_words7b = [
	"Field", "Plantation"
];

this.planetFall_opening_words7c = [
	"Windswept", "Fertile", "Cultivated", "Marshy", "Barren", "Swampy"
];

this.planetFall_opening_words7d = [
	"Fields", "Meadows", "Farmland", "Grassland", "Pastures", "Countryside", "Wetlands"
];

this.planetFall_opening_words8a = [
	"Radioactive", "Biohazardous", "Recycling", "Disposal", "Contaminated", "Infected", "Quarantined"
];

this.planetFall_opening_words9_alt = [
	"Retail", "Mercantile", "Diplomatic", "Demilitarized", "Urban"
];

this.planetFall_opening_words9_alt2 = [
	"Residential", "Suburban", "Habitation"
];

this.planetFall_opening_words9_alt3 = [
	"Commercial", "Business", "Banking", "Trading"
];

this.planetFall_opening_words9_ending = [
	"Zone", "District", "Complex", "Area", "Sector", "Region", "Quadrant"
];

this.planetFall_opening_words9_ending2 = [
	"Zone", "District", "Complex", "Sector", "Quadrant"
];

this.planetFall_opening_words10_alt1 = [
	"Aerodrome", "Airstrip", "Port", "Encampment", "Fortress", "Safehouse", "Fort", "Bastion", "Camp", "Stronghold", "Stockade", "Barracks"
];

this.planetFall_ending_words1 = [
	"City", "Metropolis", "Landing", "Township", "Citadel", "Anchorage", "Dockyard", "Harbour", "Starbase", "Spaceport",
	"Astrodome", "Cosmodrome"
];

this.planetFall_ending_words2 = [
	"Outpost", "Docks", "Shipyard", "Base", "Terminus", "Warehouse", "Depot", "Waystation", "Anchorage", "Dockyard"
];

this.planetFall_mainSurface_militaryBase_name2 = [
	"Camp", "Port"
];

this.planetFall_mainSurface_militaryBase_name3 = [
	"Keep", "Fortress", "Armoury", "Bunker", "Castle", "Arsenal"
];

this.planetFall_ending_words4 = [
	"Workshop", "Foundry", "Forge", "Cannery", "Brewery", "Refinery", "Mill", "Steelworks", "Mine", "Abattoir"
];

this.planetFall_ending_words5 = [
	"Ranch", "Hatchery", "Homestead", "Orchard", "Farmstead", "Estate", "Vineyard", "Hacienda", "Apiary", "Stables"
];

this.planetFall_ending_words6 = [
	"Hermitage", "Mansion", "Manor", "Hamlet", "Village", "Lodge", "Villa", "Stockade"
];

this.planetFall_ending_words7 = [
	"Dump", "Depot", "Cesspool", "Sewage Plant", "Junkyard", "Scrapyard", "Boneyard", "Crematorium", "Mortuary", "Cemetery", "Graveyard"
];

this.planetFall_ending_words8 = [
	"Chateau", "Penthouse", "Bastion", "Settlement", "Portico", "Colony", "Arcade", "Colonnade", "Plaza", "Bazaar", "Galleria"
];

this.planetFall_ending_words9 = [
	"Cathedral", "Monastery", "Abbey", "Temple", "Church", "Nave"
];

this.planetFall_ending_words10 = [
	"Point", "Palisade", "Towers", "Springs", "Watchtower", "Outpost", "Base", "Bunker", "Armoury", "Redoubt", "Arsenal"
];

this.planetFall_ending_words11 = [
	"Harbour", "Compound", "Citadel", "Terminus", "Central"
];

this.planetFall_mainSurface_capitalCity_name1a = [
	"London", "Cambridge", "Belfast", "Birmingham", "Bradford", "Brighton", "Bristol", "Canterbury", "York",
	"Worcester", "Winchester", "Westminster", "Wakefield", "Swansea", "Sunderland", "Southampton", "Sheffield",
	"Salisbury", "Ripon", "Preston", "Plymouth", "Perth", "Oxford", "Nottingham", "Norwich", "Manchester", "Liverpool",
	"Lisburn", "Lincoln", "Lichfield", "Leicester", "Leeds"
];

this.planetFall_mainSurface_capitalCity_name1b = [
	"Lancaster", "Kingston", "Inverness", "Hereford", "Gloucester", "Exeter", "Edinburgh", "Durham", "Derby",
	"Chichester", "Chester", "Chelmsford", "Carlisle", "Cardiff", "Canterbury", "Colorado", "Kansas", "Atlanta",
	"Sacramento", "Baltimore", "Memphis", "Portland", "Detroit", "Nashville", "Boston", "Washington", "Denver",
	"Seattle", "Columbus", "Texas", "Dallas", "Houston"
];

this.planetFall_mainSurface_capitalCity_name1c = [
	"Chicago", "Albania", "Belgium", "Prague", "Estonia", "Finland", "Paris", "Helsinki", "Berlin", "Athens",
	"Dublin", "Rome", "Pristina", "Liechtenstein", "Valletta", "Amsterdam", "Oslo", "Warsaw", "Lisbon", "Moscow",
	"Belgrade", "Stockholm", "Madrid", "Bratislava", "Brussels", "Minsk", "Sarajevo", "Macedonia", "Ankara",
	"Kazakhstan", "Canberra", "Tarawa"
];

this.planetFall_Surface_hoopy_name1a = [
	"Venetian", "Bellagio", "Monte Carlo", "Manhattan", "Groucho", "Grand Lisboa", "Foxwood", "Las Vegas",
	"Canberra", "Mindil Beach", "Reef", "Treasury", "Paradise", "Gateway", "Hard Rock", "Niagara", "Woodbine",
	"Rama", "Blue Heron", "Galaxy Macau", "Homburg", "Genting", "Dragonara", "Dunedin", "Auckland", "Wild Orchid",
	"Waterfront", "Solaire", "Constanta", "Vatra Dornei", "Suncoast", "Grosvenor"
];

this.planetFall_Surface_hoopy_name1b = [
	"Crockford", "Aspinall", "Wild Creek", "Apache Gold", "Blue Water", "Spirit Mountain", "Twin Arrows", "Talking Tree",
	"Bear River", "Black Sheep", "Deuces Wild", "Eagle Mountain", "Golden Acorn", "Hawaiian Gardens", "Limelight",
	"Livermore", "Nineteenth Hole", "Red Earth", "Rolling Hills", "Silver Fox", "San Pablo", "Spotlight",
	"Thunder Valley", "Tortoise Rock", "Twin Pines", "Black Hawk", "Brass Eye", "Bullpen", "Colorado", "Doc Holliday",
	"Double Eagle", "Midnight Rose"
];

this.planetFall_Surface_hoopy_name2 = [
	"Ballroom", "Club", "Resort", "Hippodrome", "Hotel", "Hilton", "Ritz", "Card Room"
];

this.planetFall_mainSurface_leisureComplex_name_alt1 = [
	"Complex", "Centre"
];

this.planetFall_mainSurface_leisureComplex_name_alt2 = [
	"Leisure", "Entertainment"
];

this.planetFall_mainSurface_leisureComplex_name1 = [
	"Wild Rapids", "Penguin Village", "Ocean Dome", "Boogie Mountain", "Caribbean Cove", "Disney World", "Lake Coloures",
	"Paradise Landing", "Pleasure Island", "Wonderland", "Sea World", "Splash Down", "Magic Mountain", "Galaxy Land",
	"Adventure Island", "Rattlesnake Canyon", "Tinker Town", "Blue Mountain", "Clifton Hill", "Sandpit Beach", "La Ronde",
	"Funland", "Water World", "Enchanted Island", "Crystal Falls", "Hot Springs", "Little Rock", "Adventure City", "Bear Lake",
	"Fairyland", "Fun Town", "Happy Hollow"
];

this.planetFall_mainSurface_leisureComplex_name2 = [
	"Pacific Boardwalk", "Pixie Land", "Sesame Palace", "Discovery Kingdom", "Steamboat Springs", "Adventure Ridge",
	"Ocean Beach", "The Dream Machine", "Gatorland", "Perry Fair", "Enchanted Castle", "Carousel Corner", "Lost Island",
	"Pumpkin Patch", "Indiana Beach", "Kentucky Kingdom", "Dixie Land", "Splash Town", "Playland Palace", "Orchard Beach",
	"Jolly Roger Pier", "Salem Willows", "Sterling Heights", "Spirit Mountain", "Silver Dollar City", "Mountain Creek",
	"Seaside Hights", "Point Pleasant", "Morey Pier", "Adventure Zone", "Crystal Castle", "Atlantic Beach"
];

this.planetFall_mainSurface_leisureComplex_name3 = [
	"Pong", "Tetris", "Mario", "Sonic", "Zelda", "Metroid", "Zalaga", "Minecraft", "Contra", "Galaxian", "Pokemon", "Halo"
];

this.planetFall_mainSurface_leisureComplex_name3a = [
	"World", "Palace", "Land", "City", "House", "Central", "Multiplex"
];

this.planetFall_mainSurface_leisureComplex_name5a = [
	"Hothouse", "Greenhouse", "Arboretum", "Orchard", "Park", "Nursery", "Forest"
];

this.planetFall_mainSurface_leisureComplex_name6 = [
	"Out of Africa", "Lion Country", "Kings Dominion", "Jurassic Park", "Ivory Coast", "Africano Zoo", "Parc Endemika",
	"Dream Village", "World of Birds", "Mystic Monkeys", "Panda Base", "Tropical World", "Sea World", "The Lost World",
	"Tiger Country", "Wild World", "The Reptile House", "Danga Bay", "Sunway Lagoon", "Animal Wonderland", "Crocolandia Zoo",
	"Caledonia Aquarium", "Kiwi House", "Willowbank Reserve", "London Zoo", "Nature World", "Planete Sauvage", "Sevilla Zoo",
	"Valley of Ostriches", "Amazon World", "Bird World", "Borth Animalarium"
];

this.planetFall_mainSurface_leisureComplex_name8 = [
	"Multiplex", "Odeon", "Playhouse", "Theatre", "Auditorium", "Amphitheatre"
];

this.planetFall_mainSurface_leisureComplex_name9 = [
	"Fight Club", "Cobra Kai", "Bulletproof Monk", "Tiger Claw", "Ninja Garden", "Enter the Dragon", "Game of Death",
	"Exploding Fist", "Vibrating Palm", "Shadow Boxer", "Silent Knight", "Steel Fist", "Order of Iron", "Secret Way",
	"Empty Hand", "Atomic Cat", "Knight of Ni", "Crouching Tiger", "Hidden Dragon", "Way of the Rat", "Deadly Viper",
	"Suicide Squad", "Praying Mantis", "Circling Poet", "Streets of Rage", "Whirling Dervish", "Art of War", "Deadly Poet",
	"Glass Cannon", "Red Devil", "Unseen Hand", "House of Suns"
];

this.planetFall_mainSurface_oohaul_name2 = [
	"Depot", "Outpost", "Terminus", "Anchorage", "Warehouse", "Dockyard", "Anchorage", "Waystation"
];

this.planetFall_subSurface_colony_name1 = [
	"Debt", "Mammon", "Greed", "Lending", "Credit", "Default", "Insolvency", "Bankruptcy", "Austerity", "Poverty",
	"Capital", "Equity", "Servitude", "Repayment", "Ruin", "Penury"
];

this.planetFall_subSurface_colony_name2 = [
	"Terminus", "Central", "Citadel", "City", "Township"
];

this.planetFall_moon_describe1 = [
	"Volcanic", "Luna", "Glacial", "Cratered"
];

this.planetFall_moon_describe_rocks = [
	"Granite", "Basalt", "Limestone"
];

this.planetFall_moon_describe2 = [
	"Gorge", "Canyon", "Cavern", "Outcrop", "Ravine", "Valley"
];

this.planetFall_moon_describe3 = [
	"Frozen", "Hydrocarbon", "Methane", "Lava", "Magma"
];

this.planetFall_moon_describe4 = [
	"Lake", "Lagoon", "Ocean", "Sea"
];

this.planetFall_moon_describe5 = [
	"Luna", "Mountainous", "Barren", "Volcanic", "Rocky"
];

this.planetFall_moon_describe6 = [
	"Desert", "Plateau", "Tundra", "Plain", "Crater"
];

this.planetFall_moon_describe_place1 = [
	"Sea of", "Lake of", "Ocean of", "Bay of", "Valley of", "Mountains of", "Plain of", "Canyon of", "Cavern of",
	"Abyss of", "Chasm of", "Plateau of", "Isle of", "Hills of"
];

this.planetFall_moon_describe_place2a = [
	"Concord", "Serenity", "Tranquility", "Storms", "Sorrow", "Solitude", "Dreams", "Madness", "Despair", "Time",
	"Fear", "Harmony", "Obscurity", "Decay", "Gloom", "Twilight", "Silence", "Rapture", "Inspiration", "Souls",
	"Elation", "Passion", "Bliss", "Glory", "Shadow", "Light", "Doom", "Eternity", "Discord", "Euphoria", "Hysteria",
	"Dystopia"
];

this.planetFall_moon_describe_place2b = [
	"Utopia", "Dread", "Terror", "Dismay", "Horror", "Adventure", "Trepidation", "Uncertainty", "Doubt", "Faith", "Reason",
	"Rage", "Fortune", "Fate", "Chivalry", "Courage", "Equity", "Tyranny", "Hope", "Audacity", "Daring", "Endurance", "Fortitude",
	"Gallantry", "Tenacity", "Valour", "Enterprise", "Reflection", "Nostalgia", "Absolution", "Redemption", "Regret"
];

this.planetFall_moon_describe_place2c = [
	"Stoicism", "Atonement", "Resolve", "Certitude", "Persistence", "Wisdom", "Insight", "Resolve", "Resolution", "Dedication",
	"Clemency", "Cordiality", "Grace", "Solicitude", "Sympathy", "Empathy", "Destiny", "Perception", "Brilliance", "Intellect",
	"Aptitude", "Judgment", "Intuition", "Sentience", "Foresight", "Discretion", "Devotion", "Accord", "Integrity",
	"Creation", "Imagination", "Perfection"
];

this.planetFall_moonSurface_dome_ending = [
	"Village", "Hermitage", "Lodge", "Hamlet", "Hideout", "Refuge", "Belfry", "Clinic", "Sanatorium", "Sanctuary",
	"Asylum", "Seminary", "Orphanage", "Haven"
];

this.planetFall_moonSurface_seedyBar_name_alt = [
	"Bar", "Pub", "Cafe", "Bistro"
];

this.planetFall_moon_describe_bar1 = [
	"City", "Metropolis", "Township", "Spaceport", "Astrodome", "Cosmodrome", "Base", "Colony", "Outpost", "Terminus", "Starbase"
];

this.planetFall_moon_describe_bar2 = [
	"Camp", "Port"
];

this.planetFall_moon_describe_mine1 = [
	"Volcanic", "Luna", "Magma", "Lava", "Barren", "Desolate", "Cratered", "Rocky"
];

this.planetFall_moon_describe_mine2 = [
	"Gorge", "Canyon", "Cavern", "Ravine", "Valley", "Plateau", "Wasteland", "Plain", "Promontory"
];

this.planetFall_moon_describe_prison1 = [
	"Ominous", "Uncanny", "Shadowy", "Barren", "Desolate", "Eerie", "Spooky", "Mysterious", "Misty", "Lonely", "Sinister", "Gloomy", "Perilous"
];

this.planetFall_moon_describe_prison2 = [
	"Abyss", "Chasm", "Valley", "Plateau", "Canyon", "Mountain", "Island"
];

this.planetFall_moon_describe_prison3 = [
	"Prison", "Penitentiary", "Jail", "Borstal", "Gaol", "Workhouse"
];

this.planetFall_moon_describe_base1 = [
	"Underground", "Hidden", "Subterranean", "Secluded"
];

this.planetFall_moon_describe_base2 = [
	"Cave", "Cove", "Hollow", "Cavern", "Volcano", "Crater", "Anchorage"
];

this.planetFall_moon_describe_base3 = [
	"Bioweapons", "Torpedoes", "Ballistics", "Disrupters", "Armaments", "Sidearms", "Lasers", "Railguns", "Neurotoxins",
	"Landmines", "Pistols", "Blasters", "Disintegrators", "Sonics", "Propulsion", "Terraforming", "Pharmaceuticals",
	"Defence", "Armaments", "Genetics", "Computing", "Deflectors", "Armour", "Plating", "Ablatives", "Shipwrights",
	"Munitions", "Carbines"
];

this.planetFall_moonSurface_factory_name2 = [
	"Mechanoids", "Droids", "Positronics", "Bionics", "Prosthetics", "Mechanicals", "Cybernetics", "Robotics", "Replicants", "Clones"
];

this.planetFall_moonSurface_wasteLand_name1 = [
	"Irradiated", "Devastated", "Contaminated"
];

this.planetFall_moonSurface_wasteLand_name2 = [
	"Wasteland", "Plain", "Plateau", "Cavern", "Crater"
];

this.planetFall_moonSurface_wasteLand_name3a = [
	"03", "08", "11", "12", "13", "15", "17", "19", "21", "22", "29", "34", "51", "63", "75",
	"76", "77", "79", "81", "87", "88", "92", "94", "95", "96", "101", "106", "108", "111", "112",
	"114", "118"
];

this.planetFall_moonSurface_wasteLand_name3b = [
	"Bunker", "Shelter", "Refuge"
];

this.planetFall_moonSurface_wasteLand_name3c = [
	"Listening", "Surveillance", "Monitoring"
];

this.named_stations_custom_101 = [
	"Brahma", "Vednatha", "Chaturmukha", "Prajapati", "Vedagarbha", "Devi", "Parvati", "Durga", "Kali", "Bhumi", "Lakshmi",
	"Saraswati", "Gayatri", "Ganga", "Narmada", "Yami", "Sati", "Shashthi", "Savitri", "Manasa", "Svaha", "Dakshina", "Shiva",
	"Vishnu", "Narayana", "Narayana", "Thirumal", "Perumal", "Jagannatha", "Hayagriva", "Achyuta", "Madhava"
];

this.named_stations_custom_102 = [
	"Menaka", "Pramlocha", "Rambha", "Tara", "Tilottama", "Urvashi", "Adrika", "Astika", "Kaliya", "Karkotaka", "Susna",
	"Shesha", "Takshaka", "Ulupi", "Vasuki", "Erawan", "Gajasimha", "Ganesha", "Iravati", "Vinayaki", "Pundarika", "Vamana",
	"Kumunda", "Supratika", "Anjana", "Hanuman", "Kesari", "Nala", "Sugriva", "Tara", "Vishwakarma", "Dhenu"
];

this.list_of_oldgods_subtable1 = [
	"Zeus", "Hera", "Poseidon", "Demeter", "Ares", "Athena", "Apollo", "Arthemis", "Hephaestus", "Aphrodite", "Hermes",
	"Dionysus", "Hades", "Hypnos", "Janus", "Nemesis", "Iris", "Hecate", "Tyche", "Fortuna", "Chronos", "Eros", "Gaia",
	"Hemera", "Nyx", "Nesoi", "Phanes", "Pontus", "Tartarus", "Thanatos", "Cronus", "Hyperion"
];

this.list_of_oldgods_subtable2 = [
	"Prometheus", "Atlas", "Tethys", "Helios", "Dagon", "Pallas", "Styx", "Alcyoneus", "Damysus", "Mimas", "Odin",
	"Balder", "Loki", "Thor", "Heimdall", "Odinl", "Vidar", "Cthulhu", "Shoggoth", "Azathoth", "Bokrug", "Dagon",
	"Shaggai", "Shantak", "Gobogeg", "Hastar", "Yuggoth", "Osiris", "Nepit", "Aker", "Amum", "Khepri"
];

this.list_of_oldgods_subtable3 = [
	"Osiris", "Sobek", "Caturix", "Anhur", "Horus", "Khepri", "Norton", "Thoth", "Amunet", "Hathor", "Odin",
	"Nepit", "Neit", "Ogma", "Tethra", "Achall", "Canola", "Niamh", "Cermait", "Clidna", "Belenus", "Caturix",
	"Cernunnos", "Leno", "Nemausus", "Niskus", "Ogmois", "Hesus", "Andraste", "Arito", "Erecura", "Urien"
];

this.list_of_heros_subtable1 = [
	"Abderus", "Acadermus", "Achilles", "Acrisius", "Aeneas", "Agamemnon", "Alcon", "Alcyoneus", "Alexanor",
	"Amazonius", "Andropompus", "Areclepius", "Asclepius", "Bellerophon", "Cadmus", "Castor", "Pollux",
	"Ceryx", "Diomedes", "Electryone", "Erechtheus", "Eynostus", "Eurytus", "Cteatus", "Evander", "Heracles",
	"Hippothoon", "Hyacinth", "Iphigenia", "Leons", "Leucon", "Lycurgus"
];

this.list_of_heros_subtable2 = [
	"Menelaus", "Messene", "Muichus", "Myrtilus", "Odysseus", "Oedipus", "Orestes", "Palamedes", "Pandion",
	"Parrhasius", "Peleus", "Pelops", "Perseus", "Phalanthus", "Pleuron", "Podalirius", "Protesilaus", "Sostratus",
	"Theseus", "Trophonius", "Zarex", "Ajax", "Amgrim", "Bjaki", "Egil", "Helgi", "Northbrodd", "Loki", "Odin",
	"Starkad", "Scipdagr", "Pwyll"
];

this.list_of_heros_subtable3 = [
	"Honorius", "Cuchulainn", "Gwydion", "Odysseus", "Oisin", "Pryderi", "Pwyll", "Cangjie", "Ulysses", "Mulan",
	"Almos", "Laozi", "Mazu", "Nuwa", "Shennony", "Gilgamesh", "Wukong", "Nezha", "Enkidu", "Marcus", "Beowulf",
	"Hengist", "Horsa", "Scefa", "Tarchon", "Tyrrhenus", "Karna", "Arjuna", "Arash", "Rostam", "Sohrab", "Watonga"
];

this.general_names_list_subtable_1 = [
	"Bell", "Braben", "Ahruman", "Rodriguez", "Perez", "Walch", "Martinez", "Selezen", "McLane", "Hernandez",
	"Duval", "Lopez", "Mosser", "Clark", "Garcia", "Miller", "Ryder", "Holdstock", "Zetter", "Jameson", "Jackson",
	"Anderson", "Wilson", "McReno", "Taylor", "Moore", "McNab", "Thompson", "Asimov", "Havilland", "McJamefire", "Bowman"
];

this.general_names_list_subtable_2 = [
	"Robinson", "Asher", "Livingstone", "Walker", "Hickman", "Wright", "Dent", "Baker", "Campbell", "Zorath",
	"Goldberg", "Pullman", "Weston", "Blake", "Carter", "Rimmer", "Lister", "Turner", "Saxton", "Kubrick",
	"Cook", "Ortiz", "Peterson", "Parker", "Kelly", "Watson", "Bennet", "Alvarez", "Stovin", "Fisher",
	"Carpenter", "McLaren"
];

this.general_names_list_subtable_3 = [
	"Rowlling", "Zahn", "Castillo", "Baldwin", "Tarrant", "Foster", "Aherne", "Tyler", "Jimenez", "Callaghan",
	"Callen", "Zheaton", "Clancey", "Silverberg", "Greenberg", "O'Neil", "Banfield", "Pinkman", "McGeavy",
	"Barker", "Baily", "Boden", "Sharrock", "Greenwood", "Silversmith", "Bowden", "Boylan", "Tarkin", "Capone",
	"Cahall", "Wexler", "Redfield"
];

this.general_names_list_subtable_4 = [
	"McCloud", "Dexter", "Haussmann", "McCartney", "Lennon", "Sangwan", "Wesker", "Cokeley", "Nielsen",
	"Dhillon", "Bunter", "Scoresby", "Goodwin", "Jenner", "Wodehouse", "Comerford", "Marple", "Hickson",
	"Hinchcliff", "Connally", "Wharton", "Darby", "Kapoor", "Kochavi", "Eagan", "Fitzgerald", "Jellico",
	"Feehan", "McTurk", "Grey", "Garrahan", "Lovecraft"
];

this.general_names_list_subtable_5 = [
	"Gaffey", "Karpov", "Ripley", "Walker", "Polard", "Gatchell", "Barton", "Goldrick", "Gosnell", "Paterson",
	"Doyle", "Johnson", "Goyne", "Dhal", "Pratchett", "Windham", "Haggerty", "Newman", "Halferty", "Halligan",
	"Spencer", "Hanifin", "Yadin", "Hanlon", "Laskov", "Timberman", "Hassan", "O'Rook", "Townsend", "Bryson",
	"O'Donald", "Heagerty"
];

this.named_stations_custom_119 = [
	"Ghazni", "Medina", "Damascus", "Baghdad", "Cairo", "Timbuktu", "Cordoba", "Samarra", "Hibabiya", "Hamdallashi",
	"Jerusalem", "Bukhara", "Mosul", "Neyshabur", "Harran", "Palmyra", "Decapolis", "Edom", "Gadara", "Holon",
	"Hebron", "Jabbok", "Legio", "Madon", "Migdol", "Narbata", "Naveh", "Ramoth", "Resen", "Sabea", "Sarid", "Samaria"
];

this.named_stations_custom_120 = [
	"Memphis", "Carthage", "Alexandria", "Benin", "Kano", "Laibela", "Aksum", "Djenne", "Meroe", "Tulum", "Teotihuacan",
	"Xochicalco", "Palenque", "Uxmal", "Calakul", "Chacchoben", "Cuicuico", "Kabah", "Labna", "Mitla", "Sayil", "Xlapak",
	"Yagul", "Dwarka", "Kalpi", "Chirand", "Jajpur", "Kannauj", "Devkot", "Lothal", "Lashkar", "Madurai"
];

this.named_stations_custom_121 = [
	"Ossian", "Nashik", "Sangrur", "Rajapura", "Quilon", "Sagala", "Prayag", "Allahabad", "Sopara", "Taluk", "Vidisha",
	"Avanti", "Vellore", "Taxila", "Uraiyur", "Bhopal", "Hagi", "Kanazawa", "Kitsuki", "Tsuwano", "Usuki", "Matsue",
	"Uchiko", "Yokaichi", "Asuka", "Sakurai", "Bitchu", "Takahashi", "Kawagoe", "Naramachi", "Matsumoto", "Kyoto"
];

this.custom_habitat_type3_style1b_1 = [
	"Berlepsch", "Leptos", "Glaucous", "Salamanca", "Latham", "Scopili", "Surdus", "Opterus", "Puratus",
	"Temminck", "Bavicus", "Touit", "Tepui", "Andean", "Dachilleae", "lineola", "Rufous", "Aymara", "Aurifrons",
	"Amoro", "Auri", "Taczanowski", "Xanthops", "Spengeli", "Linnaeus", "Modestus", "Coelestis", "Occidental",
	"Spicillatus", "Pitrinus", "Deroptyus", "Homerius"
];

this.custom_habitat_type3_style1b_2 = [
	"Solitarius", "Almeria", "Nucha", "Nochrous", "Hypoi", "Seram", "Haruku", "Saparua", "Domicella", "Goldiei",
	"Versi", "Teuteles", "Kakapo", "Strigops", "Notabilis", "Productus", "Nestor", "Nestoridae", "Rostris",
	"Tenui", "Sulphurea", "Sanguinea", "Nator", "Pasti", "Ophthalmica", "Saparua", "Seram", "Moluc", "Censis",
	"Roselaar", "Yamdena", "Larat"
];

this.custom_habitat_type3_style1b_3 = [
	"Hausrot", "Phoeni", "Ficedula", "Albicollis", "Hypoleuca", "Parva", "Albicilla", "Luscinia", "Secica",
	"Nachti", "Hynchos", "Ruribit", "Tarsiger", "Cyaus", "Irania", "Calliope", "Larviora", "Sibilans", "Cephei",
	"Rubecula", "Erithacus", "Muscicapa", "Striata", "Daurica", "Musci", "Cerco", "Trichas", "Migra", "Toria",
	"Vorus", "Visci", "Iliacus",
];

this.custom_habitat_type3_style1b_4 = [
	"Paradoxus", "Fratercula", "Arctica", "Antiquus", "Perdix", "Ramphus", "Impennis", "Alca", "Torda", "Aalge",
	"Paradisaea", "Bengalensis", "Alphard", "Censis", "Elegans", "Chlidonias", "Hybrida", "Caspia", "Nilotica",
	"Albifrons", "Chelidon", "Sternula", "Onychoprion", "Anaethetus", "Fuscata", "Sterna", "Aleutica", "Larus",
	"Marinus", "Glaucoides", "Sonianus", "Cachinan",
];

this.custom_habitat_type3_style2a_1 = [
	"Cainhoe", "Etonbury", "Gobion", "Odell", "Podington", "Renhold", "Someries", "Hampstead", "Donnington", "Windsor",
	"Bolbec", "Bradwell", "Desborough", "Lavendon", "Kimble", "Missenden", "Turville", "Wolverton", "Boarstall", "Aldreth",
	"Bourn", "Burwell", "Cheveley", "Eaton", "Huntingdon", "Rampton", "Wisbech", "Buckden", "Elton", "Kimbolton", "Longthorpe",
	"Woodcroft"
];

this.custom_habitat_type3_style2a_2 = [
	"Aldford", "Dodlestone", "Kingsley", "Frodsham", "Malpas", "Nantwich", "Newhall", "Northwich", "Pulford", "Shipbrook",
	"Shocklach", "Shotwick", "Warrington", "Halton", "Chester", "Peckforton", "Bishopton", "Cotherstone", "Dalden",
	"Ludworth", "Auckland", "Barnard", "Lambton", "Mortham", "Scargill", "Helston", "Penstowe", "Upton", "Launceston",
	"Pendennis", "Trematon", "Denebola"
];

this.list_of_scientists_subtable1 = [
	"Newton", "Halley", "Copernicus", "Galilei", "Kepler", "Cavendish", "Lagrange", "Dalton", "Young", "Hamilton",
	"Earnshaw", "Liouville", "Drake", "Planck", "Schwarzschild", "Born", "Bohr", "Heffern", "Chapman", "Hogarty",
	"Oppengeimer", "Feynman", "Sakharov", "Lehmann", "Hubbard", "Howley", "Gottfried", "Otacon", "Fisher", "Hawking",
	"Binder", "Freeman"
];

this.list_of_scientists_subtable2 = [
	"Cooper", "Dyson", "Sinclaire", "Mendel", "Keeling", "Boyle", "Hahn", "Mendeleev", "Lomonosov", "Ostwald",
	"Wegener", "Malpighi", "Dutrochet", "Galvani", "Ettinger", "Starzl", "Freud", "Keller", "Teller", "Zhukobsky",
	"Cayley", "Kerans", "Curie", "Kissane", "Lemaitre", "Leacitt", "Hubble", "Plank", "Susskind", "Tsiolkovsky",
	"Oberth", "Turing"
];

this.list_of_scientists_subtable3 = [
	"Lovelace", "Noether", "Bolyai", "Lobachevsky", "Cardano", "Fermat", "Pascal", "Huygems", "Pointcare",
	"Carwright", "Lorenz", "Wiener", "Bellman", "Zadeh", "Shannon", "Lafferty", "Keynes", "Koch", "Cohn",
	"Pasteur", "Lamore", "Aristotle", "Chekov", "Kilpatrick", "Blackwood", "McKay", "Anaximander", "Sarek",
	"Battula", "Koothrappali", "Heriot", "Ptolemy"
];

this.list_of_military_leaders_subtable1 = [
	"Brooke", "Montgomery", "Alexander", "Wavell", "Gort", "Mohanty", "Dowding", "Cunningham", "Montbatten",
	"Lavell", "Juin", "Gamelin", "Wayland", "Darian", "Eisenhower", "MacArthur", "Bradley", "Lordan", "Patton",
	"Nimitz", "Halsey", "Fletcher", "Spruance", "Singh", "Eaker", "Spaatz", "Zhukov", "Vasilevsky", "Kosovska",
	"Shaposhnikov", "Bagramyan", "Konev"
];

this.list_of_military_leaders_subtable2 = [
	"Timoshenko", "Isakov", "Kuznetov", "Yamasee", "Khudyakov", "Shukia", "Pande", "Winkelman", "Kler",
	"McNaughton", "Rommel", "Cromwell", "Pym", "Fairfax", "Grant", "Sherman", "McCellan", "Jackson",
	"Washington", "Rawat", "Kosciuszko", "Pulaski", "Greene", "Knox", "Burgoyne", "Morgan", "Tarleton",
	"Stark", "Sharp", "Hamilton", "Lincoln", "Lowery"
];

this.list_of_military_leaders_subtable3 = [
	"Howe", "Caldwalader", "Ashe", "Haig", "Pasha", "Hindenburg", "Petain", "Foch", "Haller", "Falkenhagn",
	"Diaz", "Aleksegev", "Zhekov", "Schwarzkopf", "Yeosock", "Woodward", "Lombardo", "Geronimo", "Pontiac",
	"Teloses", "Kintpuash", "Osceola", "Wovoka", "Wellington", "Murat", "Radetz", "Davout", "Marmont",
	"Saladin", "Charlemagne", "Ludden", "Saini"
];

this.list_of_astronauts_subtable1 = [
	"Lydon", "Macken", "Conrad", "Madden", "Michell", "Mannion", "Irwin", "Yong", "Mansfield", "Cernan", "Schmitt",
	"Borman", "Lovell", "Stafford", "Gordon", "Haise", "Swigert", "Roosa", "Worden", "Mattingly", "Grissom", "McCahon",
	"Schirra", "McDivitt", "Stafford", "Eisele", "Schweickart", "McCally", "Brand", "Engle", "McAnnally", "McAuliffee"
];

this.list_of_astronauts_subtable2 = [
	"Resnik", "McNair", "McClearn", "Scobee", "Chawla", "Onizaka", "Sullivan", "McClenaghan", "McBreen", "Jemison",
	"McCleave", "Hurley", "Melroy", "Hadfield", "Bowersox", "Shuttleworth", "Llewellyn", "Llwei", "Yang", "Yaping",
	"Heipeng", "Zhigang", "Junlong", "Booming", "Wang", "Xiaoguang", "Remek", "Gargarin", "Jahn", "Ivanov", "Tuan", "Shepard"
];

this.list_of_astronauts_subtable3 = [
	"Mendez", "Prunariu", "Cretien", "Sharma", "Garneau", "Vela", "Mohmand", "Kaleri", "Viktorenko", "Firmout", "Bella",
	"Pontes", "Mansouri", "Aimbetov", "Mogensen", "Shkor", "Fuglesang", "Ansari", "McEnery", "McGinity", "Wolowitz",
	"Hofstadter", "Floyd", "Chandra", "Cochrane", "Tsuno", "Taylor", "Urkel", "Grayson", "Simpson", "Sedikh", "McCauley"
];

this.custom_bio_type3_style3a_1 = [
	"Zalagar", "Repton", "Zircon", "Discus", "Arowana", "Limpkin", "Kelpie", "Hellebore", "Tarragon", "Wendigo",
	"Orphic", "Jellico", "Astromech", "Dinton", "Andoran", "Lustrix", "Hellespont", "Mendham", "Sacrado", "Texlos",
	"Babylon", "Drennan", "Barcella", "Constantin", "Gorton", "Kingsley", "Thorpe", "Marshall", "Goliath", "Tokasha",
	"Lootera", "Olivetti"
];

this.custom_bio_type3_style3a_2 = [
	"Ironhold", "Tokasha", "Mualang", "Irece", "Dharma", "Galileo", "Kirin", "Mangon", "Gargain", "Sheridan", "Mercer",
	"Holden", "Alshain", "Buhallin", "Bulldog", "Midway", "Daisho", "Matabushi", "Luthien", "Samarkand", "Raimei",
	"Nissan", "Turanian", "Tanadi", "Surinami", "Kankoku", "Kurita", "Banzai", "Browning", "Lexicon", "Mendham", "Laurent"
];

this.custom_bio_type4_style2a_1 = [
	"Firebird", "Whitman", "Indenture", "Beckman", "Anatass", "Rosenkov", "Kassa", "Rodam", "Haribon", "Kedar",
	"Haliat", "Gateway", "Devlon", "Cerberus", "Batarian", "Armax", "Aldrin", "Parohe", "Nashan", "Borkat", "Hislop",
	"Cision", "Jenan", "Krishna", "Burgat", "Tiburon", "Elanus", "Narhu", "Merida", "Kore", "Sonax", "Phoenix"
];

this.custom_bio_type4_style2a_2 = [
	"Guanghui", "Ashland", "Skywire", "Scopuli", "Sirenum", "Heleus", "Isenberg", "Insight", "Saronis", "Delumcore",
	"Apex", "Pyrena", "Noveria", "Baria", "Janey", "Micah", "Cepheid", "Heyuan", "Genex", "Sirta", "Conatix", "Bantam",
	"Manatee", "Ibex", "Fenris", "Palantir", "Ragnarok", "Warlock", "Chimera", "Philomela", "Amalthea", "Nemus"
];

this.custom_bio_type4_style3a_1 = [
	"Mosser", "Darkes", "Annalise", "Berihn", "Alioth", "Ericsen", "Nomura", "Jannah", "Rowan", "Spartacus", "Stenson",
	"Vasquith", "Dioscuri", "Sheehan", "Faust", "Tanase", "Corbeau", "Draconis", "Achenar", "Rambert", "Rasche", "Dalibor",
	"Pritchard", "Arexack", "Hansen", "Pradesh", "Hesperus", "Calliope", "Zeinali", "Altera", "Saunders", "Juanita"
];

this.custom_bio_type4_style3a_2 = [
	"Kabden", "Soladies", "Munchausen", "Onrira", "Larais", "Rhinitis", "Acturan", "Ruffalo", "Nervosa", "Keenan",
	"Microsoft", "Laurentiis", "Rafaella", "Atreides", "Stockwell", "Rautha", "Haderach", "Kardashian", "Hudson",
	"Fukunaga", "Leiter", "Krasinki", "Romanoff", "Hamilton", "Mobius", "Wahlberg", "Banderas", "Wachowski", "Westwood",
	"McLaren", "Kronthaler", "Versace"
];

this.custom_bio_type5_style3_1 = [
	"Kobol", "Aerelon", "Aquaria", "Canceron", "Caprica", "Gemenon", "Leonis", "Libris", "Bosporus", "Aragona",
	"Scorpia", "Tauron", "Virgon", "Hibernia", "Borgia", "Baltar", "Espenson", "Atlanticus", "Hestia", "Pavia",
	"Gramadas", "Artemis", "Queenstown", "Minos", "Zarek", "Celeste", "Hypatia", "Nagala", "Celtan", "Tamara", "Kellan",
	"Columbia"
];

this.custom_bio_type5_style3_2 = [
	"Archeron", "Inviere", "Roslin", "Agathon", "Thorne", "Cecere", "Kendra", "Burton", "Versace", "Rihanna",
	"Toronto", "Zurich", "Laurent", "Harper", "Kronthaler", "Ahluwalia", "Galliano", "Beaton", "Princeton",
	"Gherardini", "Planck", "Cepheid", "Florence", "Ludovico", "Vasari", "Gabriel", "Caterina", "Giocondo", "Cecilia",
	"Gallerani", "Bernardino", "Vercellina"
];

this.custom_bio_type6_type1a_1 = [
	"Hyperion", "Atlas", "Maliwan", "Dahl", "Torgue", "Tediore", "Stingray", "Skyfall", "Pandora", "Marcus", "Zoltan",
	"Gearbox", "Eridian", "Seraph", "Dexidous", "Lynchwood", "Southpaw", "Triquetra", "Morphous", "Archer", "Fremington",
	"Paragon", "Frostburn", "Lascaux", "Chulainn", "Foster", "Hammerlock", "Jackenstein", "Nakayama", "Harpoon", "Vermion",
	"Siren", "Tundra"
];

this.custom_bio_type6_type1a_2 = [
	"Thrall", "Spycho", "Firehawk", "Tector", "Hellfire", "Bartlesby", "Pitchfork", "Jackpot", "Longbow", "Reinhart", "Eridium",
	"Hyperious", "Rapier", "Hornet", "Thunderball", "Logan", "Sawtooth", "Veruc", "Mobley", "McNally", "Firefox", "Seraphim",
	"Seraph", "Ahab", "Deadwood", "Stallion", "Maverick", "Patriot", "Falchion", "Paritisan", "Flamerock", "Banbury", "Jinx"
];

this.custom_habitat_type1_3a = [
	"Richelieu", "Noelle", "Gaelle", "Arnaude", "Sartre", "Pascale", "Langlois", "Laudine", "Clotilde", "Honorine",
	"Flavie", "Janvier", "Albertine", "Comtois", "Berdine", "Severine", "Legrand", "Fabien", "Moulin", "Plamondon",
	"Anastaise", "Eustacia", "Doriane", "Bellerose", "Armelle", "Proulx", "Daniau", "Voclain", "Faucher", "Anouk",
	"Rosette", "Capucine"
];

this.custom_habitat_type1_3b = [
	"Lamia", "Mara", "Agrona", "Medeia", "Layal", "Zelda", "Semele", "Lailah", "Adrienne", "Persephone", "Empusa",
	"Nishay", "Persefoni", "Loralai", "Mallory", "Narkissa", "Delaynie", "Lilitu", "Megaera", "Kakarauri", "Jezebeth",
	"Cecilia", "Melania", "Nimue", "Alekto", "Cessair", "Tisiphone", "Sarka", "Morana", "Libitina", "Aeron", "Hadria",
];

this.custom_habitat_type1_3c = [
	"Gideon", "Jomei", "Pravit", "Chirag", "Horatius", "Geronimo", "Bevan", "Tlacelel", "Rostam", "Sinuhe", "Luthais",
	"Raiden", "Calhoun", "Pharris", "Luken", "Laertes", "Akio", "Partho", "Partho", "Ingvar", "Alih", "Lesedi", "Oran",
	"Fenyang", "Sukhbataar", "Kulvir", "Kikosi", "Hyldeihera", "Aetheleorn", "Karamveer", "Omeet", "Oisin",
];

this.custom_habitat_type1_3d = [
	"Kalil", "Raguel", "Lele", "Nobuo", "Bakarsi", "Nitis", "Elden", "Arluin", "Greyn", "Daemyn", "Iyayi", "Amit", "Kelvin",
	"Wynn", "Oswin", "Ortwin", "Samiul", "Raham", "Besnik", "Ronan", "Amnon", "Takoda", "Tomomi", "Khalil", "Samir", "Derwin",
	"Alfwin", "Auden", "Liesel", "Pamphilos", "Besnik", "Pamphilos",
];

this.custom_habitat_type2a_1 = [
	"Timoren", "Rhyncha", "Austral", "Patagonus", "Cognathus", "Sordox", "Maculata", "Eupsitula", "Jandaya", "Auricapillus",
	"Couloni", "Aratinga", "Couloni", "Auricollis", "Primolius", "Severus", "Militaris", "Linnaeus", "Macao", "Gularis",
	"Chloropterus", "Ararauna", "Ambiguus", "Bechstein", "Orthops", "Carolinensis", "Salvadori", "Guarouba", "Nobilis",
	"Icterotis", "Ognor", "Hynchus"
];

this.custom_habitat_type2a_2 = [
	"Personatus", "Reichenow", "Fischer", "Agapornis", "Nithinae", "Agapor", "Oustalet", "Desmarest", "Hombron", "Reichenbach",
	"Undulatus", "Melops", "Neopsitacus", "Arfaki", "Toxopei", "Amabilis", "Vereaux", "Diadema", "Notata", "Rubro",
	"Pulchella", "Placentis", "Papuan", "Palmarum", "Palmlo", "Margarethae", "Josefinae", "Richsen", "Rocephala", "Peuviana",
	"Stepheni", "Australis"
];

this.custom_habitat_type2a_3 = [
	"Motacilla", "Citreola", "Calcarata", "Tomohon", "Tschut", "Schensis", "Flava", "Petronia", "Montanus", "Eurasia",
	"Passer", "Hispanica", "Prunella", "Montanella", "Collaris", "Dunnock", "Modularis", "Oenanthe", "Leucopyga", "Ipsilou",
	"Melano", "Leuca", "Chanka", "Deserti", "Oenanthe", "Rubicola", "Saxicola", "Maurus", "Solitarius", "Saxatilis", "Phoenicurus",
	"Mousieri"
];

this.custom_habitat_type2a_4 = [
	"Aegyptius", "Caprimulgus", "Europaeus", "Funereus", "Tengmalm", "Asio", "Flammeus", "Otus", "Strix", "Noctua",
	"Surnia", "Scandiacus", "Scops", "Tyto", "Alba", "Americanus", "Tytonidae", "Cuculus", "Canorus", "Clamator", "Glandarius",
	"Cuculidae", "Krameri", "Turtur", "Zenaida", "Macroura", "Orientalis", "Decaocto", "Columba", "Palumbus", "Oenas",
	"Columbidae"
];

this.custom_habitat_style2_planets1 = [
	"Ventris", "Crassus", "Crypto", "Fuscicollis", "Rufi", "Rueppe", "Pacifica", "Rhodocephala", "Hoematotis", "Calliptera",
	"Rupicola", "Orcesi", "Colombia", "Melanura", "Dicata", "Egregia", "Leucotis", "Peruviana", "Luciani", "Santarem",
	"Amazonum", "Caerulei", "Subandina", "Picta", "Molinae", "Lepida", "Perlata", "Devillei", "Frontalis", "Ochre", "Cruentata", "Terrisi"
];

this.custom_habitat_style2_planets2 = [
	"Schlegel", "Ventris", "Occidentalis", "Neopsephotus", "Splendida", "Pulchella", "Petrophila", "Anthopeplus", "Desmarest", "Polytelis",
	"Vieillot", "Jonquil", "Aprosmictus", "Lichtenstein", "Scapularis", "Molucca", "Nensis", "Amboi", "Alisterus", "Vernalis", "Pusillus",
	"Stigmatus", "Taliabu", "Sclateri", "Catamene", "Auranti", "Molucca", "Loriculus", "Nianus", "Pullarius", "Taranta", "Reichenow",
];

this.custom_habitat_style2_planets3 = [
	"Acanthis", "Flammea", "Carduelis", "Cabaret", "Spinus", "Eurasia", "Rostris", "Flavi", "Linaria", "Cannabina", "Linet",
	"Chloris", "Serinus", "Serin", "Fringilla", "Coelebs", "Rubescens", "Anthus", "Oregon", "Spinoletta", "Petros", "Cervinus",
	"Pratens", "Gustavi", "Pechora", "Triviallis", "Hodgsoni", "Campestris", "Argentatus", "Leucopsis", "Acilla", "Motacilla",
];

this.custom_habitat_style2_planets4 = [
	"Sayornis", "Dryobates", "Picoides", "Buntspecht", "Dendrocopos", "Sphyrapicus", "Viridis", "Varius", "Torquilla",
	"Jynx", "Picidae", "Botbotik", "Upupa", "Epops", "Bucero", "Upupidae", "Coracias", "Apiaster", "Merops", "Persicus",
	"Alcyon", "Meropidae", "Megaceryle", "Alcedo", "Alcedinidae", "Apus", "Tachymarptis", "Pacificus", "Palidus", "Chaetura",
	"Pelagica", "Hirundapus"
];

this.list_of_place_names_subtable_1 = [
	"England", "Scotland", "Sailsbury", "Austria", "Belgium", "Bulgaria", "Croatia", "Kingston", "Denmark", "Estonia",
	"Finland", "France", "Germany", "Greece", "Hungary", "Ireland", "Italy", "Latvia", "Lithuania", "Luxembourg", "Malta",
	"Poland", "Portugal", "Romainia", "Slovakia", "Slovenia", "Spain", "Sweden", "America", "Africa", "Australia", "Antarctica"
];

this.list_of_place_names_subtable_2 = [
	"Europe", "Amsterdam", "Ankara", "Winchester", "Belgrade", "Berlin", "Preston", "Bucharest", "Budapest", "Copenhagen",
	"Dublin", "Gibraltar", "Helsinki", "Kiev", "Lisbon", "London", "Cardiff", "Luxembough", "Madrid", "Minsk", "Monaco",
	"Moscow", "Oslo", "Chichester", "Prague", "Rome", "Stockholm", "Vienna", "Warsaw", "Sarajevo", "Valietta", "York"
];

this.list_of_place_names_subtable_3 = [
	"Alabama", "Montgomery", "Alaska", "Mexico", "Arizona", "Phoenix", "Ripon", "California", "Sacramento", "Colorado",
	"Denver", "Connecticut", "Halford", "Delaware", "Dover", "Florida", "Georgia", "Atlanta", "Hawaii", "Honolulu", "Idaho",
	"Tamworth", "Chicago", "Indiana", "Ely", "Iowa", "Matlock", "Kentucky", "Louisiana", "Brighton", "Maine", "Portland"
];

this.list_of_place_names_subtable_4 = [
	"Maryland", "Dover", "Boston", "Michigan", "Detroit", "Minnesota", "Dorchester", "Mississippi", "Bangor", "Missouri",
	"Montana", "Helena", "Nebraska", "Nevada", "Omaha", "Hampshire", "Manchester", "Jersey", "Mexico", "Alburquerque",
	"Carolina", "Bismark", "Dakota", "Caerlon", "Oklahoma", "Oregon", "Salem", "Pennsylvania", "Philadelphia", "Columbia",
	"Nashvile", "Tennessee"
];

this.list_of_place_names_subtable_5 = [
	"Texas", "Houston", "Utah", "Vermont", "Montipelier", "Washington", "Olympia", "Seattle", "Virginia", "Charleston",
	"Belfast", "Bristol", "Cambidge", "Canterbury", "Chelmsford", "Coventry", "Dundee", "Durham", "Exeter", "Glasgow",
	"Lancaster", "Asaph", "Leicster", "Lincoln", "Liverpool", "Newcastle", "Norwich", "Perth", "Nottingham", "Plymouth",
	"Sheffield", "Southampton"
];

this.list_of_place_names_subtable_6 = [
	"Swansea", "Westminster", "Yorkshire", "Essex", "Cornwall", "Devon", "Sussex", "Kent", "Lancashire", "Somerset", "Algeria",
	"Angola", "Kenya", "Cameroon", "Zambia", "Morocco", "Egypt", "Madagascar", "Russia", "Singapore", "Taiwan", "India",
	"Indonesia", "China", "Japan", "Pakistan", "Malaysia", "Canada", "Cuba", "Haiti", "Holyhead", "Jamaica"
];

this.list_of_place_names_subtable_7 = [
	"Bermuda", "Panama", "Argentina", "Bolivia", "Chile", "Fiji", "Mumbai", "Delhi", "Bangalore", "Jaipur", "Bhopal", "Karachi",
	"Lahore", "Multan", "Larkana", "Islamabad", "Okazaki", "Toyokawa", "Tsushima", "Tokyo", "Hiroshima", "Hong Kong",
	"Macau", "Beijing", "Shanghai", "Tianjin", "Cairo", "Preroria", "Mercury", "Venus", "Earth", "Pluto"
];

this.list_of_place_names_subtable_8 = [
	"Mars", "Tregaron", "Harlech", "Jupiter", "Europa", "Ganymede", "Callistro", "Saturn", "Titan", "Conway", "Pembroke",
	"Wrexham", "Cowbridge", "Neptune", "Mercury", "Charon", "Mars", "Lave", "Betelgeuse", "Rigel", "Vega", "Fomalhaut",
	"Jupiter", "Deneb", "Alderbaran", "Alitair", "Penarth", "Bala", "Achermar", "Capella", "Pollux", "Acrux"
];

this.list_of_place_names_subtable_9 = [
	"Algol", "Bellatrix", "Saiph", "Vulcan", "Bajor", "Cardassia", "Andor", "Risa", "Brecon", "Vega", "Orion", "Rigel",
	"Alderaan", "Dabtooine", "London", "Colindale", "Essex", "Manchester", "Yorkshire", "Traal", "Kakrafoon", "Scotland",
	"Magrathea", "Kidwelly", "Caladan", "Madrid", "Barcelona", "Servile", "Cartagena", "Palma", "Pamplona", "Huelva"
];

this.list_of_place_names_subtable_10 = [
	"Almeria", "Salamanca", "Rhayader", "Manresa", "Marbella", "Lugo", "Palencia", "Toledo", "Xeer", "Lave", "Ceesexe",
	"Ususor", "Gerete", "Reorte", "Zaonce", "Tionisla", "Diso", "Oreve", "Riedquat", "Leesti", "Lampeter", "Pryan",
	"Chelestra", "Abarrach", "Bradford", "Gallifrey", "Skaro", "Ruthin", "Elgin", "Oban", "Arcadia", "Eden"
];

this.custom_buoy_repair1_list1 = [
	"Lucius", "Andre", "Jenico", "Piers", "Klaus", "Stefan", "Walter", "Gustavus", "Mervyn", "Jurgen", "Karl", "Wentworth",
	"Ivor", "Janric", "Rupert", "Casper", "Archibald", "Nathaniel", "Laszio", "Peregrine", "Maximillian", "Quintin",
	"Hugo", "Herwald", "Bernardo", "Louis", "Aubin", "Francois", "Amable", "Ivan", "Igor", "Leonid"
];

this.custom_buoy_repair1_list2 = [
	"Abhay", "Ajay", "Akhil", "Amarjit", "Bhavesh", "Bhupinder", "Chandrajit", "Devendra", "Devesh", "Deepak", "Eswar",
	"Ganesh", "Ganpatrao", "Gurunath", "Hansraj", "Harish", "Ishana", "Jitendra", "Karthik", "Kishor", "Lakshan", "Mansukh",
	"Mohindra", "Munish", "Nirupam", "Prakash", "Pranav", "Rakesh", "Ramakant", "Ranbir", "Shishira", "Wasim"
];

this.custom_buoy_repair1_list3 = [
	"Arne", "Birger", "Bjon", "Gorm", "Halfdan", "Harald", "Knud", "Skarde", "Svend", "Torsten", "Leif", "Tygve", "Odger",
	"Bodil", "Frida", "Hilda", "Gudrun", "Helga", "Randi", "Signe", "Sigrid", "Revna", "Tora", "Tove", "Thyra", "Thurid", "Yrsa",
	"Frode", "Ulfhild", "Njal", "Sune", "Troels"
];

this.custom_buoy_repair1_list4 = [
	"Alastair", "Arran", "Bram", "Caelan", "Clyde", "Ewan", "Graeme", "Lennox", "Malcolm", "Kampbell", "Keithen", "Tavish",
	"Aidan", "Beacun", "Blaine", "Branigan", "Brody", "Breccan", "Devin", "Cullen", "Cathal", "Darcy", "Eoin", "Ferris",
	"Fionn", "Egan", "Liam", "Lorcan", "Oscar", "Roan", "Rafferty", "Torin"
];

this.custom_buoy_repair1_list5 = [
	"Abbad", "Abdul", "Adham", "Badi", "Bagher", "Baha", "Caden", "Daud", "Djamal", "Ehsanullah", "Fadel", "Faisal", "Farhat",
	"Farooq", "Gaffar", "Ghanem", "Hussein", "Imran", "Jabari", "Jameel", "Kadeem", "Muhsin", "Nabih", "Omar", "Osman", "Samir",
	"Qaid", "Rabia", "Rahim", "Wazir", "Yasser", "Zabit"
];

this.custom_buoy_repair1_list6 = [
	"Akifumi", "Akitomo", "Bunta", "Chikao", "Daihachi", "Eisaku", "Fujio", "Fuyukichi", "Giichi", "Hakaru", "Harukichi",
	"Hiromoto", "Junnosuke", "Junto", "Kagetaka", "Kazumichi", "Masahiro", "Masakage", "Nariakira", "Okimoto", "Osamu",
	"Otohiko", "Rikiya", "Ryu", "Sadaharu", "Sadakatsu", "Shinta", "Tadaaki", "Tadamitsu", "Tsunehiko", "Tasuku", "Yashiro"
];

this.custom_buoy_repair1_list7 = [
	"Aurick", "Bernhard", "Christof", "Conrad", "Dagobert", "Egbert", "Felix", "Ferdinand", "Fritz", "Gerwin", "Gunther",
	"Gottfried", "Harald", "Heiner", "Ignatz", "Johann", "Kaspar", "Leopold", "Lorentz", "Ludwig", "Luther", "Magnus", "Otto",
	"Ottomar", "Siegfried", "Valter", "Vollrath", "Waldemar", "Wilhelm", "Ruprecht", "Wolfgang", "Xavier"
];

this.custom_buoy_repair2_list1 = [
	"Elizabeth", "Victoria", "Matilda", "Eleanor", "Catherine", "Natalya", "Anastasia", "Ekaterina", "Miriam", "Veronica",
	"Viktoriya", "Adrienne", "Elise", "Fleur", "Hermine", "Isabella", "Jacquelin", "Juliette", "Melanie", "Nadia", "Olivia",
	"Heidi", "Helena", "Hildegard", "Isabella", "Johanna", "Nadine", "Rachel", "Leopoldine", "Karolina", "Theresia", "Cornelia"
];

this.custom_buoy_repair2_list2 = [
	"Sophia", "Amelia", "Augusta", "Charlotte", "Mary", "Alexandrina", "Josephine", "Marie", "Henrietta", "Katharine",
	"Beatrice", "Margaret", "Anne", "Diana", "Louise", "Alice", "Sarah", "Camilla", "Meghan", "Sophie", "Alberta", "Lucy",
	"Jane", "Cynthia", "Claire", "Aisling", "Shauna", "Siobhan", "Imogen", "Deirdre", "Nessa", "Adel"
];

this.custom_buoy_repair2_list4 = [
	"Emily", "Lillian", "Edith", "Madeline", "Harriette", "Helen", "Florence", "Lillian", "Mabel", "Judith", "Veronica",
	"Zara", "Dorothy", "Nancy", "Jill", "Josephine", "Isobel", "Beryl", "Barbara", "Rosalina", "Rachael", "Ingrid", "Carol",
	"Averil", "Judith", "Sally", "Geraldine", "Clare", "Jacqueline", "Constance", "Susan", "Jane"
];

this.custom_astro_type1a_new = [
	"Silverleaf", "Romulus", "Remus", "De Beers", "Coriolanus", "Ardiente", "Maximilian", "Palpatine", "Oceania", "Aladeen",
	"Comstock", "Adami", "Daredevil", "Voldemort", "Osborne", "Wildflower", "Cersei", "Tarkin", "Abstergo", "Fontaine",
	"Hyperion", "Aesir", "Shinra", "Armitage", "Paleocene", "Honeypot", "Baratheon", "Sidious", "Morlock", "Amidala",
	"Odessa", "Bonaparte"
];

this.custom_astro_type1b_new = [
	"Cove", "Hollow", "Rock", "Harbour", "Bay", "Wharf", "Mine", "Quarry", "Goldmine"
];

this.custom_astro_type1f_new = [
	"Nicodemus", "Rassilon", "Thulsa", "Krull", "Malkoth", "Komodo", "Rendain", "Varesh", "Maestro", "Solus", "Astaroth",
	"Balor", "Bertoldo", "Domenico", "Moloch", "Orthon", "Tacito", "Cormac", "Naoise", "Morbius"
];

this.list_of_military_leaders_subtable1 = [
	"Brooke", "Montgomery", "Alexander", "Wavell", "Gort", "Mohanty", "Dowding", "Cunningham", "Montbatten", "Lavell", "Juin",
	"Gamelin", "Wayland", "Darian", "Eisenhower", "MacArthur", "Bradley", "Lordan", "Patton", "Nimitz", "Halsey", "Fletcher",
	"Spruance", "Singh", "Eaker", "Spaatz", "Zhukov", "Vasilevsky", "Kosovska", "Shaposhnikov", "Bagramyan", "Konev"
];

this.list_of_military_leaders_subtable2 = [
	"Timoshenko", "Isakov", "Kuznetov", "Yamasee", "Khudyakov", "Shukia", "Pande", "Winkelman", "Kler", "McNaughton", "Rommel",
	"Cromwell", "Pym", "Fairfax", "Grant", "Sherman", "McCellan", "Jackson", "Washington", "Rawat", "Kosciuszko", "Pulaski",
	"Greene", "Knox", "Burgoyne", "Morgan", "Tarleton", "Stark", "Sharp", "Hamilton", "Lincoln", "Lowery"
];

this.list_of_military_leaders_subtable3 = [
	"Howe", "Caldwalader", "Ashe", "Haig", "Pasha", "Hindenburg", "Petain", "Foch", "Haller", "Falkenhagn", "Diaz", "Aleksegev",
	"Zhekov", "Schwarzkopf", "Yeosock", "Woodward", "Lombardo", "Geronimo", "Pontiac", "Teloses", "Kintpuash", "Osceola",
	"Wovoka", "Wellington", "Murat", "Radetz", "Davout", "Marmont", "Saladin", "Charlemagne", "Ludden", "Saini"
];

this.custom_science_type3_unique2_1 = [
	"Blowpipe", "Piranha", "Hemlock", "Colt", "Lawman", "Warlord", "Nova", "Messiah", "Kendo", "Remington", "Glock", "Ruger", "Sauer",
	"Beretta", "Springfield", "Browning", "Winchester", "Walther", "Kimber", "Mauser", "Dallera", "Hellfire", "Brimstone", "Albatros",
	"Henschel", "Rafael", "Novator", "Fireflash", "Firestreak", "Skyflash", "Stinger", "Hawker"
];

this.custom_science_type3_unique2_2 = [
	"Armadillo", "Bulldog", "Boomerang", "Caudron", "Helldiver", "Blackhawk", "Dassault", "Nimrod", "Kawanishi", "Starfire",
	"Lockheed", "Nieuport", "Tigershark", "Hammerhead", "Lancer", "Zeppelin", "Rockwell", "Snark", "Supermarine", "Tololoche", "Vickers",
	"Vanguard", "Whirlwind", "Dornier", "Communis", "Firebrand", "Hornet", "Swordfish", "Aardvark", "Nighthawk", "Hudson", "Bronco"
];

this.custom_science_type3_unique2_3 = [
	"Gladius", "Lansen", "Vindicator", "Vultee", "Westland", "Tokarev", "Makarov", "Lobaev", "Simonov", "Kalashnikov", "Claymore", "Solitare",
	"Cerulean", "Pancor", "Rheinmetall", "Sandia", "Takoma", "Versicorps", "Littlehorn", "Cordex", "Rapier", "Falchion", "Doomsday", "Gatling",
	"Direwolf", "Ravenskull", "Warhawk", "Warlord", "Chessmaster", "Antelope", "Maxim", "Fairchild"
];

this.custom_bio_type1_style1_end = [
	"Plc", "Ltd", "Inc"
];

this.custom_science_type4_unique1 = [
	"Hadron", "Innes", "Moredun", "Quadram", "Franklin", "Denhart", "Heseinberg", "Scully", "Hardwick", "Heinrich", "Skinner", "Spender",
	"Kersh", "Kennedy", "Whitestone", "Blacksand", "Gibson", "Mahler", "Mandel", "Neider", "Rahman", "Reinhart", "Schaeffer", "Rademaker",
	"Ophoven", "Waterman", "Bashar", "Darwish", "Hamdi", "Kader", "Khalid", "Rahim"
];

this.custom_science_type4_unique2 = [
	"Ingman", "Kafer", "Kalbach", "Kuehler", "Mahler", "Mulder", "Armando", "Bautista", "Castellano", "Florentino", "Jaramillo", "Lorenzo",
	"Maduro", "Mathias", "Puerta", "Sanchez", "Santana", "Valenciano", "Riversong", "Freeman", "Abiodun", "Adeleke", "Chidubem", "Obiakolam",
	"Temitope", "Beltran", "Gallardo", "Maldonado", "Pacheco", "Palacios", "Quintero", "Velasco"
];

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
	this._phraseGen = worldScripts.GNN_PhraseGen;
	if (missionVariables.PlanetFall2_StoredNames) {
		this.nameStore = JSON.parse(missionVariables.PlanetFall2_StoredNames);
		delete missionVariables.PlanetFall2_StoredNames;
	}
	if (this.nameStore[galaxyNumber] == undefined) {
		for (var i = 0; i <= 7; i++) {
			this.nameStore[i] = {};
			for (var j = 0; j <= 255; j++) {
				this.nameStore[i][j] = {};
			}
		}
	}
	if (worldScripts.RandomStationNames) this.rsnInUse = true;
	// override the rsn flag if we've specifically turned it off.
	if (worldScripts.PlanetFall2._config.useGANames == false) this.rsnInUse = false;
}

//-------------------------------------------------------------------------------------------------------------
this.playerWillSaveGame = function () {
	missionVariables.PlanetFall2_StoredNames = JSON.stringify(this.nameStore);
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_CapitalCity = function $PF_CapitalCity(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.planetFall_mainSurface_capitalCity_name1a),
			fieldB: [].concat(this.planetFall_mainSurface_capitalCity_name1b),
			fieldC: [].concat(this.planetFall_mainSurface_capitalCity_name1c),
			fieldD: ["[1]", "[2]", "[3]"],
			fieldE: [].concat(this.planetFall_opening_words1_alt), //5
			fieldF: [].concat(this.planetFall_opening_words1_alt4),
			fieldG: [].concat(this.planetFall_opening_words1_alt5),
			fieldH: [].concat(this.planetFall_opening_words1_alt6),
			fieldI: ["[7] Control", "[7] Control", "Tourist [5]", "(D50=Ministry|Department) of [6]", "Visitors [5]", "[8] Embassy", "Planetary Capital", "Trading [5]"],

			fieldJ: [].concat(this.list_of_oldgods_subtable1).concat(this.list_of_oldgods_subtable2).concat(this.list_of_oldgods_subtable3).concat(this.named_stations_custom_101).concat(this.named_stations_custom_102),
			fieldK: [],
			fieldL: [],
			fieldM: [].concat(this.planetFall_ending_words1),
			fieldN: [].concat(this.list_of_heros_subtable1).concat(this.list_of_heros_subtable2).concat(this.list_of_heros_subtable3),
			fieldO: [].concat(this.named_stations_custom_119).concat(this.named_stations_custom_120).concat(this.named_stations_custom_121),
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"New 4 (9)",
				"{1 4 (}9)",
				"{5 4 (}9)",
				"{6 4 (}9)"
			],
		};
		// special case for anarchies, that shouldn't have things like "Immigration Control"
		if (system.government == 0) def.fieldI = ["Tourist [5]", "(D50=Ministry|Department) of [6]", "Visitors [5]", "[8] Embassy", "Planetary Capital", "Trading [5]"];

		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_LeisureComplex = function $PF_LeisureComplex(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.planetFall_mainSurface_leisureComplex_name1).concat(this.planetFall_mainSurface_leisureComplex_name2),
			fieldB: [].concat(this.planetFall_mainSurface_leisureComplex_name3),
			fieldC: [].concat(this.planetFall_mainSurface_leisureComplex_name3a),
			fieldD: [].concat(this.general_names_list_subtable_4),
			fieldE: [].concat(this.general_names_list_subtable_5),
			fieldF: [].concat(this.planetFall_mainSurface_leisureComplex_name5a),
			fieldG: ["[4]", "[5]"],
			fieldH: [].concat(this.general_names_list_subtable_1).concat(this.general_names_list_subtable_2).concat(this.general_names_list_subtable_3).concat(this.general_names_list_subtable_4).concat(this.general_names_list_subtable_5),
			fieldI: ["Bristol Zoo", "Flamingo Land", "Lakeland Oasis", "Longleat Zoo", "Monkey World",
				"The Living Rainforest", "Bermuda Aquarium", "Holdstock Serpentarium", "World of Snakes", "[8] Hive", "[8] Zoo", "[8] Serpentarium", "[8] Aviary",
				"[8] Apiary", "[8] Vespiary", "[8] Cattery", "[8] Kennels", "[8] Aquarium", "[8] Reserve", "[8] Sanctuary", "[8] Wetlands", "[8] Vivarium",
				"[8] Zoo", "[8] Aviary", "[8] Apiary", "[8] Cattery", "[8] Vivarium", "[8] Aquarium", "[8] Zoo", "[8] Kennels", "[8] Wetlands", "[8] Aquarium"].concat(this.planetFall_mainSurface_leisureComplex_name6),

			fieldJ: [].concat(this.planetFall_mainSurface_leisureComplex_name8),
			fieldK: [].concat(this.planetFall_mainSurface_leisureComplex_name_alt1),
			fieldL: [].concat(planetFall_mainSurface_leisureComplex_name9),
			fieldM: [].concat(this.planetFall_mainSurface_leisureComplex_name1).concat(this.planetFall_mainSurface_leisureComplex_name2).concat(this.planetFall_mainSurface_leisureComplex_name6),
			fieldN: [].concat(this.planetFall_mainSurface_leisureComplex_name_alt2),
			fieldO: [].concat(this.custom_habitat_type3_style2a_1).concat(this.custom_habitat_type3_style2a_2),
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 (Water Park)",
				"2 3 (Games Arcade)",
				"7 6 (Botanical Gardens)",
				"9 (Public Menagerie)",
				"The {6 1 (Cinema 2)",
				"9 (Safari Park)",
				"{3 (Vacuum Karate Dojo)",
				"The {6 1 (Videodrome 2)",
				"{4 (Theme Park)",
				"{4 (5 2)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MilitaryBase = function $PF_MilitaryBase(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.planetFall_mainSurface_militaryBase_name2),
			fieldB: [].concat(this.planetFall_mainSurface_militaryBase_name3),
			fieldC: [].concat(this.general_names_list_subtable_1).concat(this.general_names_list_subtable_2).concat(this.general_names_list_subtable_3),
			fieldD: [].concat(this.planetFall_opening_words3_alt),
			fieldE: [].concat(this.planetFall_opening_words3_alt2),
			fieldF: [].concat(this.list_of_military_leaders_subtable1).concat(this.list_of_military_leaders_subtable2).concat(this.list_of_military_leaders_subtable3),
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 6 (4 5)",
				"3 2 (4 5)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_Factory = function $PF_Factory(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_bio_type3_style3a_1),
			fieldB: [].concat(this.custom_bio_type3_style3a_2),
			fieldC: [].concat(this.planetFall_ending_words4),
			fieldD: [].concat(this.planetFall_opening_words5a),
			fieldE: [].concat(this.planetFall_opening_words5b),
			fieldF: ["[1]", "[2]"],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"6 3 (4 5)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_Dump = function $PF_Dump(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_bio_type5_style3_1),
			fieldB: [].concat(this.custom_bio_type5_style3_2),
			fieldC: [].concat(this.planetFall_ending_words7),
			fieldD: [].concat(this.planetFall_opening_words8a),
			fieldE: [].concat(this.planetFall_opening_words6b),
			fieldF: ["[1]", "[2]"],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"6 3 (4 5)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_ColonyCity = function $PF_ColonyCity(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_bio_type6_type1a_1).concat(this.custom_bio_type6_type1a_2),
			fieldB: ["[4] [7]", "[5] [7]", "[6] [8]"],
			fieldC: [].concat(this.planetFall_ending_words8),
			fieldD: [].concat(this.planetFall_opening_words9_alt),
			fieldE: [].concat(this.planetFall_opening_words9_alt2),
			fieldF: [].concat(this.planetFall_opening_words9_alt3),
			fieldG: [].concat(this.planetFall_opening_words9_ending),
			fieldH: [].concat(this.planetFall_opening_words9_ending2),
			fieldI: [].concat(this.custom_habitat_type2a_1).concat(this.custom_habitat_type2a_2).concat(this.custom_habitat_type2a_3).concat(this.custom_habitat_type2a_4),
			fieldJ: [].concat(this.planetFall_subSurface_colony_name2),
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 3 (2)",
				"9 {1 (}2)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_ColonyMilitaryBase = function $PF_ColonyMilitaryBase(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_habitat_type1_3a),
			fieldB: [].concat(this.custom_habitat_type1_3b),
			fieldC: [].concat(this.custom_habitat_type1_3c),
			fieldD: [].concat(this.custom_habitat_type1_3d),
			fieldE: [].concat(this.planetFall_ending_words10),
			fieldF: [].concat(this.planetFall_opening_words10_alt1),
			fieldG: ["Military [6]", "Naval [6]"],
			fieldH: ["[1]", "[2]", "[3]", "[4]"],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"8 5 (7)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_OOHaul = function $PF_OOHaul(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.list_of_heros_subtable1),
			fieldB: [].concat(this.list_of_heros_subtable2),
			fieldC: [].concat(this.list_of_heros_subtable3),
			fieldD: [].concat(this.list_of_oldgods_subtable1),
			fieldE: [].concat(this.list_of_oldgods_subtable2),
			fieldF: [].concat(this.list_of_oldgods_subtable3),
			fieldG: [].concat(this.planetFall_mainSurface_oohaul_name2),
			fieldH: ["[1]", "[2]", "[3]", "[4]", "[5]", "[6]"],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"8 7 (Distribution Centre)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_Blackmonks = function $PF_Blackmonks(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.planetFall_ending_words9),
			fieldB: [].concat(this.planetFall_subSurface_colony_name1),
			fieldC: [].concat(this.planetFall_opening_words9_ending),
			fieldD: ["Monastic [3]", "Ecclesiastic [3]", "Clerical [3]",],
			fieldE: [],
			fieldF: [],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 2 (4)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_HoopyCasino = function $PF_HoopyCasino(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.planetFall_Surface_hoopy_name1a).concat(this.planetFall_Surface_hoopy_name1b),
			fieldB: [].concat(this.planetFall_Surface_hoopy_name2),
			fieldC: [],
			fieldD: [],
			fieldE: [],
			fieldF: [],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 2 (HoOpy Casino)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MoonDome = function $PF_MoonDome(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_habitat_type3_style1b_1).concat(this.custom_habitat_type3_style1b_2).concat(this.custom_habitat_type3_style1b_3).concat(this.custom_habitat_type3_style1b_4),
			fieldB: [],
			fieldC: [],
			fieldD: [],
			fieldE: [].concat(this.planetFall_moonSurface_dome_ending),
			fieldF: [].concat(this.planetFall_moon_describe1).concat(this.planetFall_moon_describe_rocks),
			fieldG: [].concat(this.planetFall_moon_describe2),
			fieldH: [].concat(this.planetFall_moon_describe3),
			fieldI: [].concat(this.planetFall_moon_describe4),

			fieldJ: [].concat(this.planetFall_moon_describe5),
			fieldK: [].concat(this.planetFall_moon_describe6),
			fieldL: [].concat(this.planetFall_moon_describe_place1),
			fieldM: [].concat(this.planetFall_moon_describe_place2a).concat(this.planetFall_moon_describe_place2b).concat(this.planetFall_moon_describe_place2c),
			fieldN: [],
			fieldO: ["[1]", "[2]", "[3]", "[4]"],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 5 (6 7)",
				"1 5 (8 9)",
				"1 5 ({1 2)",
				"1 5 ({3 4)",
				"1 5 ({3 4)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MoonMine = function $PF_MoonMine(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_astro_type1a_new).concat(this.custom_astro_type1f_new),
			fieldB: [].concat(this.custom_astro_type1b_new),
			fieldC: [].concat(this.planetFall_moon_describe_mine1),
			fieldD: [].concat(this.planetFall_moon_describe_mine2),
			fieldE: [],
			fieldF: [],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 2 (3 4)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MoonPrison = function $PF_MoonPrison(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.list_of_military_leaders_subtable1).concat(this.list_of_military_leaders_subtable2).concat(this.list_of_military_leaders_subtable3),
			fieldB: [].concat(this.planetFall_moon_describe_prison3),
			fieldC: [].concat(this.planetFall_moon_describe_prison1),
			fieldD: [].concat(this.planetFall_moon_describe_prison2),
			fieldE: [],
			fieldF: [],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 2 (3 4)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MoonResearch = function $PF_MoonResearch(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_science_type3_unique2_1).concat(this.custom_science_type3_unique2_2).concat(this.custom_science_type3_unique2_3),
			fieldB: [].concat(this.planetFall_moon_describe_base3),
			fieldC: [].concat(this.custom_bio_type1_style1_end),
			fieldD: [].concat(this.planetFall_moon_describe_base1),
			fieldE: [].concat(this.planetFall_moon_describe_base2),
			fieldF: [],
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 2 3 (4 5)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MoonFactory = function $PF_MoonFactory(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: [].concat(this.custom_science_type4_unique1).concat(this.custom_science_type4_unique2),
			fieldB: [].concat(this.planetFall_moonSurface_factory_name2),
			fieldC: [].concat(this.custom_bio_type1_style1_end),
			fieldD: [].concat(this.planetFall_moon_describe_base1),
			fieldE: [].concat(this.planetFall_moon_describe_base2),
			fieldF: [].concat(this.planetFall_moon_describe1).concat(this.planetFall_moon_describe_rocks),
			fieldG: [].concat(this.planetFall_moon_describe2),
			fieldH: [].concat(this.planetFall_moon_describe3),
			fieldI: [].concat(this.planetFall_moon_describe4),
			fieldJ: [].concat(this.planetFall_moon_describe5),
			fieldK: [].concat(this.planetFall_moon_describe6),
			fieldL: [].concat(this.planetFall_moon_describe_place1),
			fieldM: [].concat(this.planetFall_moon_describe_place2a).concat(this.planetFall_moon_describe_place2b).concat(this.planetFall_moon_describe_place2c),
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 2 3 (6 7)",
				"1 2 3 (8 9)",
				"1 2 3 ({1 2)",
				"1 2 3 ({3 4)",
				"1 2 3 ({3 4)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}

//-------------------------------------------------------------------------------------------------------------
this.$PF_MoonWasteland = function $PF_MoonWasteland(dataKey) {
	if (!this.rsnInUse) return "";
	var stored = this.nameStore[galaxyNumber][system.ID][dataKey];
	if (!stored) {
		var def = {
			fieldA: ["Vault [2]", "Fallout Shelter [2]", "Emergency [3] [2]", "[4] Post [2]"],
			fieldB: [].concat(this.planetFall_moonSurface_wasteLand_name3a),
			fieldC: [].concat(this.planetFall_moonSurface_wasteLand_name3b),
			fieldD: [].concat(this.planetFall_moonSurface_wasteLand_name3c),
			fieldE: [].concat(this.planetFall_moonSurface_wasteLand_name1),
			fieldF: [].concat(this.planetFall_moonSurface_wasteLand_name2),
			fieldG: [],
			fieldH: [],
			fieldI: [],
			fieldJ: [],
			fieldK: [],
			fieldL: [],
			fieldM: [],
			fieldN: [],
			fieldO: [],
			fieldP: [],
			fieldQ: [],
			fieldR: [],
			sentences: [
				"1 (5 6)"
			],
		};
		var text = this._phraseGen._makePhrase(def);
		this.nameStore[galaxyNumber][system.ID][dataKey] = text;
	} else {
		var text = stored;
	}
	return text;
}
