"use strict";
this.name = "planetFall2_launchFX";
this.author = "Svengali & Thargoid";
this.copyright = "CC-by";
this.description = "FX script";
this.version = "1.0";

this.effectSpawned = function () {
	this.firstFrame = true;
	this.getRid = 0;
	this.tex = worldScripts.PlanetFall2.launchTexture;
	// orient the visual effect
    this.visualEffect.orientation = player.ship.orientation;
	// start the frame callback
	this.ovFCBID = addFrameCallback(this.repos.bind(this));
}

this.effectRemoved = function () { 
	removeFrameCallback(this.ovFCBID); 
}

this.repos = function (delta) {
	var p = player.ship;
	if (!p.isValid || this.getRid >= 3) {
		this.visualEffect.remove();
		return;
	}

	if (this.firstFrame || !delta) {
		this.firstFrame = false;
		return;
	}

	var tex = "planetFall2_launchFX" + this.tex + "_" + Math.floor(this.getRid) + ".png";
	this.visualEffect.setMaterials({ 
		"planetFall2_launchFX0.png": { 
			fragment_shader: "planetFall2_breakPattern.fragment",
			vertex_shader: "planetFall2_breakPattern.vertex",
			textures: [tex],
	} 
	});
	this.visualEffect.position = p.position.add(p.vectorForward.multiply(worldScripts.PlanetFall2.fx_launch_dist));
	this.visualEffect.orientation = p.orientation;
	this.getRid += (2 * delta); // to get the effect finished before true launch into realspace
	return;
}
