"use strict";
this.name = "planetFall2_Markets";
this.author = "phkb";
this.copyright = "2023 phkb";
this.license = "CC BY-NC-SA 4.0";

this.$originalDefs = {
	"planetFall2_mainSurface_capitalCity": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 40, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 124, 13, 13, 29, 7, 7, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 53, 15, 0, 0, 7, 0, 0]
	},

	/*"planetFall2_mainSurface_shipYard": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 40, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 53, 15, 0, 0, 7, 0, 0]
	},*/

	"planetFall2_mainSurface_militaryBase": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 1],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 1],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 2],
		"alien_items": [0, 0, 53, 15, 0, 0, 7, 0, 0]
	},

	/*"planetFall2_mainSurface_seedyBar": {
		"food": [0, 0, 38, 6, -8, 2, 0, -2, 0],
		"textiles": [0, 0, -1, 3, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 2, 3, 0, 0, 0, 0, 0],
		"slaves": [0, 0, -10, 15, 9, 27, 0, 0, 0],
		"liquor_wines": [0, 0, 130, 7, -12, 2, 3, -2, 0],
		"luxuries": [0, 0, 0, 4, 6, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, -12, -16, 0, 0, 0, 0],
		"computers": [0, 0, 0, 3, 2, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, -1, -4, 0, 0, 0],
		"alloys": [0, 0, 87, -4, 12, 32, -2, 3, 0],
		"firearms": [0, 0, 0, 11, 43, -2, 0, 0, 0],
		"furs": [0, 0, 7, 2, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 2, -1, 0, 0, 0, 0],
		"gold": [0, 0, 0, 6, -3, 0, 0, 0, 1],
		"platinum": [0, 0, 0, 2, -1, 0, 0, 0, 1],
		"gem_stones": [0, 0, 0, 1, 5, 0, 0, 0, 2],
		"alien_items": [0, 0, 84, -2, 0, 0, -3, 0, 0]
	},*/

	"planetFall2_mainSurface_leisureComplex": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_mainSurface_factory": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	/*"planetFall2_mainSurface_farm": {
		"food": [0, 0, 15, -2, -2.5, 20, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 40, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 124, 13, 13, 29, 7, 7, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

    "planetFall2_mainSurface_fields": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},*/

	"planetFall2_mainSurface_dump": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	// Sub planet surface locations.
	"planetFall2_subSurface_colony": {
		"food": [0, 0, 22, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 24, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 70, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 43, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 90, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 200, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 160, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 120, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 85, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 127, 13, 13, 29, 7, 7, 0],
		"furs": [0, 0, 180, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 36, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 100, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 175, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 48, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 57, 15, 0, 0, 7, 0, 0]
	},

	/*"planetFall2_subSurface_shipYard": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 23, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 68, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 43, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 200, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 158, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 120, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 80, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 180, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 36, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 100, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 175, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 48, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 56, 15, 0, 0, 7, 0, 0]
	},*/

	"planetFall2_subSurface_militaryBase": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 1],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 1],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 2],
		"alien_items": [0, 0, 53, 15, 0, 0, 7, 0, 0]
	},

	/*"planetFall2_subSurface_seedyBar": {
		"food": [0, 0, 38, 6, -8, 2, 0, -2, 0],
		"textiles": [0, 0, -1, 3, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 2, 3, 0, 0, 0, 0, 0],
		"slaves": [0, 0, -10, 15, 9, 27, 0, 0, 0],
		"liquor_wines": [0, 0, 130, 7, -12, 2, 3, -2, 0],
		"luxuries": [0, 0, 0, 4, 6, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, -12, -16, 0, 0, 0, 0],
		"computers": [0, 0, 0, 3, 2, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, -1, -4, 0, 0, 0],
		"alloys": [0, 0, 87, -4, 12, 32, -2, 3, 0],
		"firearms": [0, 0, 0, 11, 43, -2, 0, 0, 0],
		"furs": [0, 0, 7, 2, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 2, -1, 0, 0, 0, 0],
		"gold": [0, 0, 0, 6, -3, 0, 0, 0, 1],
		"platinum": [0, 0, 0, 2, -1, 0, 0, 0, 1],
		"gem_stones": [0, 0, 0, 1, 5, 0, 0, 0, 2],
		"alien_items": [0, 0, 84, -2, 0, 0, -3, 0, 0]
	},*/

	"planetFall2_subSurface_leisureComplex": {
		"food": [0, 0, 21, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 23, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 86, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 200, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 158, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 120, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 180, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 100, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 174, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 49, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_subSurface_factory": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	/*"planetFall2_subSurface_farm": {
		"food": [0, 0, 17, -2, -2.5, 20, 1, 1, 0],
		"textiles": [0, 0, 22, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 40, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 85, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 198, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 157, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 120, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 127, 13, 13, 29, 7, 7, 0],
		"furs": [0, 0, 180, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 35, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 99, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 174, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 48, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_subSurface_field": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},*/

	"planetFall2_subSurface_dump": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

    // Moon locations.
	"planetFall2_moonSurface_dome": {
		"food": [0, 0, 19, -2, -2, 3, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 6, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 5, 7, 7, 0],
		"slaves": [0, 0, 40, -5, -5, 150, 31, 31, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 220, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 45, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 23, 31, 31, 0],
		"firearms": [0, 0, 124, 13, 13, 20, 7, 7, 0],
		"furs": [0, 0, 176, -9, -9, 180, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 90, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 73, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 74, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 53, 15, 0, 0, 7, 0, 0]
	},

	/*"planetFall2_moonSurface_seedyBar": {
		"food": [0, 0, 38, 6, -8, 2, 0, -2, 0],
		"textiles": [0, 0, -1, 3, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 2, 3, 0, 0, 0, 0, 0],
		"slaves": [0, 0, -10, 15, 9, 27, 0, 0, 0],
		"liquor_wines": [0, 0, 130, 7, -12, 2, 3, -2, 0],
		"luxuries": [0, 0, 0, 4, 6, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, -12, -16, 0, 0, 0, 0],
		"computers": [0, 0, 0, 3, 2, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, -1, -4, 0, 0, 0],
		"alloys": [0, 0, 87, -4, 12, 32, -2, 3, 0],
		"firearms": [0, 0, 0, 11, 43, -2, 0, 0, 0],
		"furs": [0, 0, 7, 2, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 2, -1, 0, 0, 0, 0],
		"gold": [0, 0, 0, 6, -3, 0, 0, 0, 1],
		"platinum": [0, 0, 0, 2, -1, 0, 0, 0, 1],
		"gem_stones": [0, 0, 0, 1, 5, 0, 0, 0, 2],
		"alien_items": [0, 0, 84, -2, 0, 0, -3, 0, 0]
	},*/


	"planetFall2_moonSurface_leisureDome": {
		"food": [0, 0, 21, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 24, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 87, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 204, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 243, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 162, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 121, 6, 0, 40, 7, 7, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_moonSurface_mine": {
		"food": [0, 0, 19, 0, 0, 0, 1, 0, 0],
		"textiles": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 42, -3, 0, 20, 7, 3, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 105, -5, 0, 0, 15, 0, 0],
		"luxuries": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 51, 14, 0, 0, 3, 0, 0],
		"machinery": [0, 0, 117, 6, 0, 0, 7, 0, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 60, -1, 0, 85, 3, 3, 0],
		"gold": [0, 0, 23, -1, 0, 25, 7, 3, 1],
		"platinum": [0, 0, 45, -2, 0, 46, 31, 7, 1],
		"gem_stones": [0, 0, 25, -1, 0, 56, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_moonSurface_prison": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 124, 13, 13, 29, 7, 7, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 1],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 1],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_moonSurface_researchComplex": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 40, -5, -5, 226, 31, 31, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 235, 29, 29, 8, 120, 120, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 124, 13, 13, 29, 7, 7, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 53, 15, 0, 0, 7, 0, 0]
	},

	"planetFall2_moonSurface_factory": {
		"food": [0, 0, 19, -2, -2, 6, 1, 1, 0],
		"textiles": [0, 0, 20, -1, -1, 10, 3, 3, 0],
		"radioactives": [0, 0, 65, -3, -3, 2, 7, 7, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 83, -5, -5, 251, 15, 15, 0],
		"luxuries": [0, 0, 196, 8, 8, 54, 3, 3, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 154, 14, 14, 56, 3, 3, 0],
		"machinery": [0, 0, 117, 6, 6, 40, 7, 7, 0],
		"alloys": [0, 0, 78, 1, 1, 17, 31, 31, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 176, -9, -9, 220, 63, 63, 0],
		"minerals": [0, 0, 32, -1, -1, 53, 3, 3, 0],
		"gold": [0, 0, 97, -1, -1, 66, 7, 7, 1],
		"platinum": [0, 0, 171, -2, -2, 55, 31, 31, 1],
		"gem_stones": [0, 0, 45, -1, -1, 250, 15, 15, 2],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},

	"planetFall2_moonSurface_wasteLand": {
		"food": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"textiles": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"radioactives": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"slaves": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"liquor_wines": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"luxuries": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"narcotics": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"computers": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"machinery": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alloys": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"firearms": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"furs": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"minerals": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gold": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"platinum": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"gem_stones": [0, 0, 0, 0, 0, 0, 0, 0, 0],
		"alien_items": [0, 0, 0, 0, 0, 0, 0, 0, 0]
	},
};

//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
	var msi = worldScripts.MarketScriptInterface_Main;
	msi.$addMarketInterface("station_local", "$updateLocalCommodityDefinition", this.name);
}

//-------------------------------------------------------------------------------------------------------------
this.$updateLocalCommodityDefinition = function (goodDefinition, station) {

	if (!station) return goodDefinition;
	if (!station.hasRole("planetFall2_surface")) return goodDefinition;

	var key = station.dataKey.substring(0, station.dataKey.length - 2);
	// watch for a market_key setting in script info of the station
	// allows stations to become equivalent to one of the built in stations.
	if (station.scriptInfo && station.scriptInfo.market_key) 
		key = station.scriptInfo.market_key;

	var marketType = worldScripts.PlanetFall2._config.marketMethod[key]

	// watch for a market_type setting in script info of the station
	if (station.scriptInfo && station.scriptInfo.market_type && !isNaN(station.scriptInfo.market_type)) 
		marketType = parseInt(station.scriptInfo.market_type);

	// no market
	if (marketType == 0) {
		goodDefinition.price = 0;
		goodDefinition.quantity = 0;
		return goodDefinition;
	}
	// copy main station market
	if (marketType == 1) {
		return goodDefinition;
	}

	// sfep method (adjust by distance from main station)
	if (marketType == 2) {
		if (!station.dockPos) return goodDefinition;

		var distance = station.dockPos.distanceTo(system.mainStation);
		
		//scale max price difference with distance
		//1000 km -> 0.05, 5000 km -> 0.15
		var maxPriceDiff = 0.000000025 * distance + 0.025;
		var priceDiff = Math.random() * maxPriceDiff;
		
		//cheaper or more expensive?
		var coinToss = Math.round(Math.random());
		if (coinToss === 0)  var priceMultiplier = 1 - priceDiff;
		else var priceMultiplier = 1 + priceDiff;
		
		goodDefinition.price *= priceMultiplier;
		
		//scale quantity with random +/- 100 % scale
		
		var quantityDiff = Math.random();
		var coinToss = Math.round(Math.random());
		if (coinToss === 0) var quantityMultiplier = 1 - quantityDiff;
		else var quantityMultiplier = 1 + quantityDiff;
		
		goodDefinition.quantity = Math.round(quantityMultiplier * goodDefinition.quantity);

		return goodDefinition;
	}

	// original
	if (marketType == 3) {
		// this method is the markets from the original version of planetfall
		if (!station) return goodDefinition;
		var commodity = goodDefinition.key;
		if (this.$originalDefs[key] == undefined) return goodDefinition;
		var oldDefs = this.$originalDefs[key][commodity];
		//old style definition found for the good. calculate it the old way
		if (oldDefs) {
			var market_base_price = oldDefs[2];
			var market_eco_adjust_price = oldDefs[3];
			var market_eco_adjust_quantity = oldDefs[4];
			var market_base_quantity = oldDefs[5];
			var market_mask_price = oldDefs[6];
			var market_mask_quantity = oldDefs[7];
			var market_rnd = Math.floor(Math.random() * 256);

			var economy = system.economy;

			var price = (market_base_price + (market_rnd & market_mask_price) + (economy * market_eco_adjust_price)) & 255;
			price *= 0.4;

			var quantity = (market_base_quantity + (market_rnd & market_mask_quantity) - (economy * market_eco_adjust_quantity)) & 255;
			if (quantity > 127) quantity = 0;
			quantity &= 63;

			goodDefinition.price = price * 10;
			goodDefinition.quantity = quantity;
		}
		//no definition found. nullify the goods.
		else {
			goodDefinition.price = 0;
			goodDefinition.quantity = 0;
		}
		return goodDefinition;
	}
}
