"use strict";
this.name					= "FlightLog";
this.author					= "Thargoid";
this.copyright				= "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description			= "Saves a list of systems visited, plus the kills and profit for each";
this.version				= "1.11";

this.startUpComplete = function()
	{
	this.maxLogLength = 100; // the max size of the log - minimum size should be 10 (the latest 10 are displayed in-game).
	this.blankArray = "";
	let setupCounter = 0; // reset the counter
	for(setupCounter = 0; setupCounter < this.maxLogLength; setupCounter++)
		{ this.blankArray = this.blankArray + "0:";	}
	this.blankArray = this.blankArray.substr(0, (this.blankArray.length - 1 )); // snip off the last :

	if(!missionVariables.flightLogMemory)
		{ // if this is the first run of the OXP
		missionVariables.flightLogMemory = this.blankArray;
		missionVariables.flightKillsMemory = this.blankArray;
		missionVariables.flightCreditsMemory = this.blankArray;
		missionVariables.flightKillsStore = player.score;
		missionVariables.flightCreditsStore = player.credits;
		}

	this.flightArray = missionVariables.flightLogMemory.split(":");
	this.killsArray = missionVariables.flightKillsMemory.split(":");
	this.creditsArray = missionVariables.flightCreditsMemory.split(":");

	this.baseKills = missionVariables.flightKillsStore;
	this.baseCredits = missionVariables.flightCreditsStore;

	if(this.flightArray.length !== this.maxLogLength) // just in case this.maxLogLength has been changed since last run.
		{
		let setupCounter = 0; // reset the counter
		for(setupCounter = this.flightArray.length; setupCounter < this.maxLogLength; setupCounter++)
			{ // this loop will run if the array is smaller than the max log size
			this.flightArray[setupCounter] = "0";
			this.killsArray[setupCounter] = "0";
			this.creditsArray[setupCounter] = "0";
			}
		this.$trimArrays(); // this will trim things down if the array is larger than the max log size
		}

	let setupCounter = 0; // reset the counter
	for(setupCounter = 0;setupCounter < this.flightArray.length;setupCounter++)
		{
		this.flightArray[setupCounter] *= 1; // to swap values from string to number
		this.killsArray[setupCounter] *= 1;
		this.creditsArray[setupCounter] *= 1;
		}
	this.$dockedCheck();
	}

this.shipDockedWithStation = function()
	{
	this.$dockedCheck();
	this.playerWillSaveGame();
	}

this.playerWillSaveGame = function()
	{
	missionVariables.flightKillsStore = this.baseKills;
	missionVariables.flightCreditsStore = this.baseCredits;
	}

this.$dockedCheck = function()
	{
	if (player.ship.docked)
		{
		player.ship.dockedStation.setInterface("FlightLog",
			{ title: "Flight log",
			category: "Logs",
			summary: "Displays the ships flight log.",
			callback: this.$showLog.bind(this) });
		}
	}

this.guiScreenChanged = function(to, from)
	{
	if(from == "GUI_SCREEN_MARKET" || from == "GUI_SCREEN_EQUIP_SHIP" || from == "GUI_SCREEN_SHIPYARD" || from == "GUI_SCREEN_STATUS")
		{ //  refresh the mission variables if we come from market/equipment/shipyard or status screens
		this.playerWillSaveGame();
		}

	// showing mission screen during flight is no longer recommended
	//if(player.ship.docked || to != "GUI_SCREEN_SHORT_RANGE_CHART" || from != "GUI_SCREEN_MANIFEST")
	//	{ // access main screen only from manifest to short range chart when in flight (via F4 when docked)
	//	return;
	//	}
	//this.$showLog();
	}

this.guiScreenWillChange = function (to, from) {
	if (to === "GUI_SCREEN_MANIFEST") {
		if (!player.ship.docked) {
			if(system.ID == -1) {
				mission.setInstructions("You are currently in interstellar space (" + (player.score - this.baseKills) + " kills, " + (Math.floor(10 * (player.credits - this.baseCredits)) / 10) + "cr).", this.name);
			} else {
				mission.setInstructions("You are currently in the " + system.name + " system in galaxy " + (galaxyNumber + 1) + " (" + (player.score - this.baseKills) + " kills, " + (Math.floor(10 * (player.credits - this.baseCredits)) / 10) + "cr).", this.name);
			}
		} else {
			mission.setInstructions(null, this.name);
		}
	}
}

this.$showLog = function() {
	if(this.flightArray[this.flightArray.length - 1] == 0) {// if the last entry is 0, then assume the array is blank (all zero)
		mission.runScreen({screenID:"oolite-flightlog-main-map", title:"Flight Log", overlay:{name:"fl-note_book.png", height:546}, exitScreen:"GUI_SCREEN_INTERFACES", messageKey:"flightLog_empty"});
		if(system.ID == -1) {
			mission.addMessageText("\nYou are currently in interstellar space.");
		} else {
			mission.addMessageText("\nYou are currently in the " + system.name + " system in galaxy " + (galaxyNumber + 1) + ".");
		}
		return;
	}

	mission.runScreen({screenID:"oolite-flightlog-main-map", title:"Flight Log", messageKey:"flightLog_header", overlay:{name:"fl-note_book.png", height:546}, exitScreen:"GUI_SCREEN_INTERFACES", choicesKey:"flightLog_choices"}, this.$choice);

	this.endPoint = this.flightArray.length;
	this.startPoint = this.endPoint - 10;

	let listCounter = 0; // reset the counter
	for(listCounter = this.startPoint; listCounter < this.endPoint; listCounter++) {
		if(this.flightArray[listCounter] >= 0) {
			mission.addMessageText((this.flightArray.length - listCounter) + " - " + System.systemNameForID(this.flightArray[listCounter]) + ", (" + this.killsArray[listCounter] + " kills,  " + this.creditsArray[listCounter] + "  cr).");
		}
		if(this.flightArray[listCounter] == -1) {
			mission.addMessageText((this.flightArray.length - listCounter) + " - Interstellar Space, (" + this.killsArray[listCounter] + " kills,  " + this.creditsArray[listCounter] + "  cr).");
		}
	}

	if(system.ID == -1) {
		mission.addMessageText("\nYou are currently in interstellar space (" + (player.score - this.baseKills) + " kills, " + (Math.floor(10 * (player.credits - this.baseCredits)) / 10) + "cr).");
	} else {
		mission.addMessageText("\nYou are currently in the " + system.name + " system in galaxy " + (galaxyNumber + 1) + " (" + (player.score - this.baseKills) + " kills, " + (Math.floor(10 * (player.credits - this.baseCredits)) / 10) + "cr).");
	}
}

this.$choice = function(choice)
	{
	switch(choice)
		{
		case "FLIGHTLOG_1_DUMP":
			{
			player.consoleMessage("Flight log written to latest.log", 6);
			log(this.name, "==================================");
			log(this.name, " ");

			let logCounter = 0 ; // reset the counter
			for(logCounter = 0;logCounter<this.flightArray.length;logCounter++)
				{
				if(this.flightArray[logCounter] >= 0)
					{
					log(this.name, (this.flightArray.length - logCounter) + " - " + System.systemNameForID(this.flightArray[logCounter]) + ", (" + this.killsArray[logCounter] + " kills,  " + this.creditsArray[logCounter] + "cr).");
					}
				if(this.flightArray[logCounter] == -1)
					{
					log(this.name, (this.flightArray.length - logCounter) + " - Interstellar Space, (" + this.killsArray[logCounter] + " kills,  " + this.creditsArray[logCounter] + "cr).");
					}
				}
			log(this.name, " ");
			if(system.ID != -1)
				{
				log(this.name, "Current system - " + system.name + " in galaxy " + (galaxyNumber + 1) + ", (" + (player.score - this.baseKills) + " kills, " + (Math.floor(10 * (player.credits - this.baseCredits)) / 10) + "cr).");
				}
			else
				{
				log(this.name, "Currently in interstellar space, (" + (player.score - this.baseKills) + " kills, " + (Math.floor(10 * (player.credits - this.baseCredits)) / 10) + "cr).");
				}
			log(this.name, "==================================");
			break;
			}

		case "FLIGHTLOG_2_RESET":
			{
			player.consoleMessage("Flight log cleared.", 6);
			this.playerEnteredNewGalaxy();
			break;
			}
		}
	}

this.shipWillExitWitchspace = function()
	{
	this.baseKills = player.score;
	this.baseCredits = player.credits;
	}

this.shipWillEnterWitchspace = function(cause)
	{
	this.kills = player.score - this.baseKills;
	this.profit = Math.floor(10 * (player.credits - this.baseCredits)) / 10;
	this.flightArray.push(system.ID);
	this.killsArray.push(this.kills);
	this.creditsArray.push(this.profit);

	this.$trimArrays();

	missionVariables.flightLogMemory = this.flightArray[0];
	missionVariables.flightKillsMemory = this.killsArray[0];
	missionVariables.flightCreditsMemory = this.creditsArray[0];

	let arrayCounter = 1 ; // set the counter
	for(arrayCounter = 1; arrayCounter < this.flightArray.length; arrayCounter++)
		{
		missionVariables.flightLogMemory = missionVariables.flightLogMemory + ":" + this.flightArray[arrayCounter];
		missionVariables.flightKillsMemory = missionVariables.flightKillsMemory + ":" + this.killsArray[arrayCounter];
		missionVariables.flightCreditsMemory = missionVariables.flightCreditsMemory + ":" + this.creditsArray[arrayCounter];
		}
	}

this.$trimArrays = function()
	{ // trim the arrays back to their original lengths by throwing out oldest (first in the array) log entries
	while(this.flightArray.length > this.maxLogLength)
		{ this.discard = this.flightArray.shift(); }

	while(this.killsArray.length > this.maxLogLength)
		{ this.discard = this.killsArray.shift(); }

	while(this.creditsArray.length > this.maxLogLength)
		{ this.discard = this.creditsArray.shift(); }
	}

this.playerEnteredNewGalaxy = function()
	{
	missionVariables.flightLogMemory = this.blankArray;
	missionVariables.flightKillsMemory = this.blankArray;
	missionVariables.flightCreditsMemory = this.blankArray;
	this.startUp();
	}