"use strict";
this.name = "PlanetRotationCosmetics";
this.author = "phkb";
this.copyright = "CC-BY-NC-SA 4.0";
this.description = "Script that slows planet rotation as you approach it";

// point at which rotation will start slowing
this._maxalt = 15000;

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    this.$recordInitialValues();
}

//-------------------------------------------------------------------------------------------------------------
this.shipExitedWitchspace = function() {
    this.$recordInitialValues();
    // in case there's a planet near the witchpoint
    this.shipLaunchedFromStation();
}

//-------------------------------------------------------------------------------------------------------------
this.$recordInitialValues = function() {
    var pl = system.planets;
    var i = pl.length;
    while (i--) {
        pl[i].stored_rotationalVelocity = pl[i].rotationalVelocity;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function() {
    if (worldScripts.PlanetFall2) {
        this._maxalt = worldScripts.PlanetFall2._config.atmosphereMax * 1000;
    }

    this._nearest = this.$nearestPlanet();
    if (this._nearest && this.$altitude(player.ship, this._nearest) < (this._nearest.radius * 3)) this.shipEnteredPlanetaryVicinity(this._nearest);
}

//-------------------------------------------------------------------------------------------------------------
this.shipEnteredPlanetaryVicinity = function(entity) {
    if (entity.isSun) return;
    this._nearest = entity;
    if (this._timer && this._timer.isRunning) this._timer.stop();
    this._timer = new Timer(this, this.$checkAlt.bind(this), 0.25, 0.25);
}

//-------------------------------------------------------------------------------------------------------------
this.shipExitedPlanetaryVicinity = this.shipDockedWithStation = this.shipDied = this.shipWillEnterWitchspace = function(entity) {
    if (this._timer && this._timer.isRunning) this._timer.stop();
}

//-------------------------------------------------------------------------------------------------------------
this.$checkAlt = function $checkAlt() {
    if (!this._nearest) return;

    var that = $checkAlt;
    var _altitude = (that._alt = that._alt || this.$altitude);
    var _p = (that._p = that._p || player.ship);
    var _max = (that._max = that._max || this._maxalt);

    if (!_p || !_p.isValid) return;
    var alt = _altitude(_p, this._nearest);
    var pl = this._nearest;
    if (alt >= _max) {
        pl.rotationalVelocity = pl.stored_rotationalVelocity;
    } else if (alt < 1000) {
        pl.rotationalVelocity = 0;
    } else {
        pl.rotationalVelocity = pl.stored_rotationalVelocity * (alt / _max);
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$nearestPlanet = function() {
    var p = player.ship;
    var pp = p.position;
    var c = null;
    var d = 100000000000000000000.0; //10^20m for sure
    var pl = system.planets;
    var i = pl.length;
    while (i--) { //find the smallest distance
        var s = pp.distanceTo(pl[i].position) - pl[i].radius;
        if (d > s) {
            d = s;
            c = pl[i];
        }
    }
    if (c) {
        return c;
    } else {
        return null;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.$altitude = function(p, planet) {
    var alt = 999999
    if (planet) {
        alt = p.position.distanceTo(planet) - planet.radius - p.collisionRadius;
    }
    return alt;
}
