"use strict";
this.name        = "XenonUI_CoreMissionFixes";
this.author      = "phkb";
this.copyright   = "2016 phkb";
this.description = "Updates routines in core missions for compatibility with XenonUI";
this.license     = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
	// apply fixes for nova missions
	var wn = worldScripts["oolite-nova"];
	if (wn) {
		wn.missionScreenOpportunity = this.$nova_missionScreenOpportunity;
	}
}

//-------------------------------------------------------------------------------------------------------------
this.$nova_missionScreenOpportunity = function() {
	if (!player.ship.docked)
	{
		return;
	}
	
	function choiceEvaluation(choice)
	{
		if (choice === "YES")
		{
			player.ship.useSpecialCargo(expandDescription("[oolite-nova-refugees]"));
			mission.setInstructionsKey("oolite_nova_info");
			missionVariables.nova = "NOVA_ESCAPE_HERO";
			player.ship.launch();
			this._blowUpAllStations();
			system.sun.goNova(30);
		}
		else
		{
			// choice == "NO", or null when player launched without making a choice.
			missionVariables.nova = "NOVA_ESCAPE_COWARD";
			player.commsMessage(expandDescription("[oolite-nova-coward]"), 4.5);
			system.sun.goNova(9);	// barely enough time to jump out of the system.
		}
		missionVariables.novacount = null;
	}
	
	if (player.ship.dockedStation.isMainStation)
	{
		if (galaxyNumber === 3)
		{
			if (!missionVariables.nova && !missionVariables.novacount)
			{
				missionVariables.novacount = 0;
			}
			if (missionVariables.nova === "TWO_HRS_TO_ZERO")
			{
				mission.runScreen({
					titleKey: "oolite_nova_title",
					messageKey: "oolite_nova_brief",
					overlay: {name:"solar.png", height:512},
					choicesKey: "oolite_nova_yesno",
					screenID: "oolite-nova-briefing"
				},
				choiceEvaluation);
				
				this.novaMissionTimer.stop();
			}
		}
		if (galaxyNumber === 3 || galaxyNumber === 4)
		{
			if (missionVariables.nova === "NOVA_ESCAPED_SYSTEM")
			{
				player.ship.removeAllCargo();
				mission.runScreen({
					titleKey: "oolite_nova_title",
					messageKey: "oolite_nova_hero",
					overlay: {name:"solar.png", height:512},
					screenID: "oolite-nova-hero"
				});
				player.ship.manifest["gem_stones"] += 100;
				this._endTheMission();
			}
			else if (missionVariables.nova === "NOVA_ESCAPE_POD")
			{
				player.ship.removeAllCargo();  // can only be done while docked.
				mission.runScreen(
				{
					titleKey: "oolite_nova_title",
					messageKey: "oolite_nova_disappointed",
					overlay: {name:"solar.png", height:512},
					screenID: "oolite-nova-disappointed"
				});
				this._endTheMission();
			}
			else if (missionVariables.nova === "NOVA_ESCAPE_OTHER")
			{
				mission.runScreen({
					titleKey: "oolite_nova_title",
					messageKey: "oolite_nova_ignored",
					overlay: {name:"solar.png", height:512},
					screenID: "oolite-nova-ignored"
				});
				this._endTheMission();
			}
			else if (missionVariables.nova === "NOVA_ESCAPE_COWARD" && !system.sun.isGoingNova && !system.sun.hasGoneNova)
			{
				player.decreaseContractReputation();
				player.decreasePassengerReputation();
				mission.runScreen({
					titleKey: "oolite_nova_title",
					messageKey: "oolite_nova_disappointed",
					overlay: {name:"solar.png", height:512},
					screenID: "oolite-nova-coward"
				});
				this._endTheMission();
			}
		}
	}
	else if (missionVariables.nova === "TWO_HRS_TO_ZERO")
	{
		// this is the the nova system, but not the main station.
		player.ship.launch();
		player.commsMessage(expandDescription("[oolite-nova-visit-main]"));
	}
};

