"use strict";
this.name = "XenonUI_Compatibility";
this.author = "phkb";
this.copyright = "2021 phkb";
this.description = "OXP Compatibility function overrides";
this.license = "CC BY-NC-SA 3.0";

this.startUp = function () {
    // make sothis tc compatible
    if (worldScripts.sothis_tc && worldScripts.sothis_tc.version == "1.0.3") {
        var stc = worldScripts.sothis_tc;
        stc.missionScreenOpportunity = this._sothis_missionScreenOpportunity;
    }
    // make Iron Raven compatible
    if (worldScripts["IR-main-script.js"] && worldScripts["IR-main-script.js"].version == "1.4.2.1") {
        worldScripts["IR-main-script.js"].questionScreens = this.questionScreens;
        worldScripts["IR-main-script.js"].shipDockedWithStation = this._ir_shipDockedWithStation;
        worldScripts["IR-main-script.js"].missionScreens = this.missionScreens;
        worldScripts["IR-main-script.js"].choiceEvaluation = this.choiceEvaluation;
    }
}

//-------------------------------------------------------------------------------------------------------------
// to make Sothis TC compatible
this._sothis_missionScreenOpportunity = function () {
    if (!this.$showWelcome) return;
    var messText = expandDescription("[STC_welcome]");
    if (this.$new_cargoes)
        messText = messText + expandDescription("[STC_new_cargoes]");
    var tcbgpic = "OOmap_G" + (galaxyNumber + 1) + ".png";
    mission.runScreen({
        title: "Sothis Trade Center",
        message: messText,
        overlay: tcbgpic
    });
    this.$showWelcome = false;
}

//-------------------------------------------------------------------------------------------------------------
// to make Iron Raven compatible
this.questionScreens = function () {
    if (system.ID == 23) // Maenes
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "QuiCo Pharmaceuticals",
                overlay: "IR_quico_logo.png",
                messageKey: "IR_MAENES_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_MAENES_QUESTIONS"
        }
    }

    if (system.ID == 171) // Yokohama
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Yokohama Exports",
                overlay: "IR_yk_logo.png",
                messageKey: "IR_YOKOHAMA_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS"
        }
    }

    if (system.ID == 232) //Janes
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Janes's Shipyard Intelligence",
                overlay: "IR_janes_logo.png",
                messageKey: "IR_JANES_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_JANES_QUESTIONS"
        }
    }

    if (system.ID == 240) // Pirate Cove
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            if (!missionVariables.IR_alsto) {
                this._runScreen({
                    title: " ",
                    messageKey: "IR_PIRATE_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                missionVariables.IR_alsto = "MET"
            } else {
                this._runScreen({
                    title: " ",
                    messageKey: "IR_PIRATE_intro_alt",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
            }
        }
    }

    if (system.ID == 119) // PleasureWorld
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "PleasureWorld",
                overlay: "IR_pw_logo.png",
                messageKey: "IR_PW_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_PW_QUESTIONS"
        }
    }

    if (system.ID == 180) // NWE
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Naval Weapons Establishment",
                overlay: "IR_NWE_logo.png",
                messageKey: "IR_NWE_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_NWE_QUESTIONS"
        }
    }

    if (system.ID == 219) // GSE
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "Galactic Stock Exchange",
                overlay: "IR_GSE_logo.png",
                messageKey: "IR_GSE_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
        }
    }

    if (system.ID == 31) // KORSHKOV
    {
        if (missionVariables.IR_status == "IR_IBANEZ_4") {
            this._runScreen({
                title: "OKB Korshkov",
                overlay: "IR_korshlogo.png",
                messageKey: "IR_KORSHKOV_intro",
                choicesKey: "IR_questions"
            }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
        }
    }
}

this._ir_shipDockedWithStation = function (station) {
    this.addIRinterface()

    if (missionVariables.IR_status == "IR_epilogue" && clock.days > missionVariables.IR_epilogue_deadline) {
        this._runScreen({
            messageKey: "IR_final",
            choicesKey: "IR_continue"
        }, function (choice) {
            if (choice == 1) {
                this._runScreen({
                    overlay: "IR_title.png",
                    messageKey: "IR_theend"
                });
                missionVariables.IR_status = "IR_completed"
                mission.setInstructionsKey(null)
                missionVariables.IR_epilogue_deadline = null
                missionVariables.IR_shipment_quest = null
                missionVariables.IR_SDF_quest = null
                missionVariables.IR_SDF_question_no = null
                missionVariables.IR_SDF_question_key = null
                missionVariables.IR_SDF_question_string = null
                missionVariables.IR_defences_quest = null
                missionVariables.IR_defences_question_no = null
                missionVariables.IR_defences_question_key = null
                missionVariables.IR_defences_question_string = null
                missionVariables.IR_finance_quest = null
                missionVariables.IR_finance_question_no = null
                missionVariables.IR_finance_question_key = null
                missionVariables.IR_finance_question_string = null
                missionVariables.IR_shipment_quest_method = null
                missionVariables.IR_shipment_question_no = null
                missionVariables.IR_shipment_question_key = null
                missionVariables.IR_shipment_question_string = null
                missionVariables.IR_GSE_loan = null
                missionVariables.IR_wife_status = null
                missionVariables.IR_alsto = null
                missionVariables.IR_count = null
                missionVariables.IR_defences_kill_count = null
                missionVariables.IR_SDF_quest_location = null
                missionVariables.IR_SDF_quest_location_name = null
                missionVariables.IR_KORSHKOV_deadline = null
                missionVariables.IR_asked_question = null
                missionVariables.IR_question_settings = null
                missionVariables.IR_screen_log = null
                missionVariables.IR_screen_location = null
            }
        });
    }
    if (player.ship.docked && galaxyNumber == 7) this.missionScreens();
}

this.missionScreens = function () {
    if (guiScreen == "GUI_SCREEN_MISSION" || !player.ship.docked)
        return;

    if (player.ship.dockedStation.hasRole("IR-luft-core")) {
        if (missionVariables.IR_SDF_quest == "JACOB" || missionVariables.IR_SDF_quest == "LUFTSLOTTE") {
            this._runScreen({
                title: "Luftslotte 6",
                messageKey: "IR_SDF_quest_4"
            })
            missionVariables.IR_SDF_quest = "KRAIT"
        }
    }

    if (player.ship.dockedStation.isMainStation && missionVariables.IR_offer == null) {
        if (missionVariables.IR_status == null) {
            this._runScreen({
                overlay: "IR_title.png",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1) {
                    this._runScreen({
                        messageKey: "IR_IBANEZ_1"
                    });
                    mission.setInstructionsKey("IR_IBANEZ_INFO")
                    missionVariables.IR_status = "IR_IBANEZ_1"
                }
            });
        }

        if (missionVariables.IR_finance_quest == "REPROCESSED" && clock.days >= missionVariables.IR_KORSHKOV_deadline) //this is 20 days
        {
            this._runScreen({
                title: "Jane's Shipyard Intelligence",
                messageKey: "IR_finance_quest_4"
            });
            missionVariables.IR_finance_quest = "JANES_NEWS"
            missionVariables.IR_KORSHKOV_deadline = null
            player.incrementFinanceStatus()
        }

        if (missionVariables.IR_SDF_quest == "ADDRESS" && clock.days >= missionVariables.IR_SDF_deadline) {
            this._runScreen({
                messageKey: "IR_SDF_quest_2"
            });
            missionVariables.IR_SDF_quest = "JACOB"
            player.incrementSDFStatus()
        }

        if (missionVariables.IR_SDF_quest == "POD_SCOOPED") {
            this._runScreen({
                messageKey: "IR_SDF_quest_5"
            });
            player.ship.useSpecialCargo("WARNING: Radiation detected in cargo hold")
            missionVariables.IR_SDF_quest = "KORSHKOV"
            player.incrementSDFStatus()
        }

        if (missionVariables.IR_SDF_quest == "PHOTO" && clock.days >= missionVariables.IR_SDF_deadline) {
            this._runScreen({
                messageKey: "IR_SDF_quest_8a",
                overlay: "IR_kinnaird.png",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1)
                    this._runScreen({
                        messageKey: "IR_SDF_quest_8b",
                        overlay: "IR_match.png",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this._runScreen({
                                messageKey: "IR_SDF_quest_8c"
                            });
                            missionVariables.IR_SDF_quest = "COMPLETED"
                            player.clearSDFStatus()
                            missionVariables.IR_SDF_status_no = null
                            missionVariables.IR_SDF_deadline = null
                                ++missionVariables.IR_quest_count
                        }
                    });
            });
        }

        if (missionVariables.IR_finance_quest == "WAIT3" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
            this._runScreen({
                title: " ",
                overlay: "IR_bloomberg.png",
                messageKey: "IR_finance_quest_10"
            });
            missionVariables.IR_KORSHKOV_deadline = null
            player.clearFinanceStatus()
            missionVariables.IR_finance_status_no = null
            missionVariables.IR_finance_quest = "COMPLETED"
                ++missionVariables.IR_quest_count
        }

        if (missionVariables.IR_shipment_quest == "SUCCESS") {
            this._runScreen({
                messageKey: "IR_shipment_success"
            });
            player.clearShipmentStatus()
            missionVariables.IR_shipment_status_no = null
            missionVariables.IR_shipment_quest = "COMPLETED"
            missionVariables.IR_YOKOHAMA_deadline = null
                ++missionVariables.IR_quest_count
            missionVariables.IR_tipoff_deadline = clock.days + 10
        }

        if (missionVariables.IR_shipment_quest == "DISPATCHED") {
            this._runScreen({
                messageKey: "IR_shipment_failure"
            });
            player.clearShipmentStatus()
            missionVariables.IR_shipment_status_no = null
            missionVariables.IR_shipment_quest = "FAILED"
                ++missionVariables.IR_quest_count
            missionVariables.IR_YOKOHAMA_deadline = null
        }

        if (missionVariables.IR_shipment_quest == "COMPLETED") {
            if (clock.days >= missionVariables.IR_tipoff_deadline) {
                this._runScreen({
                    messageKey: "IR_tipoff"
                });
                missionVariables.IR_tipoff_deadline = null
                missionVariables.IR_shipment_quest = "TIPPEDOFF"
            }
        }

        if (missionVariables.IR_loan_deadline) {
            if (clock.days >= missionVariables.IR_loan_deadline) {
                this._runScreen({
                    title: "First Galactic Bank",
                    messageKey: "IR_GSE_loan_warning"
                });
                mission.setInstructionsKey(null)
                missionVariables.IR_loan_deadline = null
                missionVariables.IR_load_remaining = null
                player.credits -= 550000
                missionVariables.IR_GSE_loan = "DEFAULTED"
            }
        }

        if (missionVariables.IR_defences_quest == "DEMO_6" && clock.days > missionVariables.IR_defences_quest_deadline) {
            this._runScreen({
                messageKey: "IR_defences_quest_6"
            });
            ++missionVariables.IR_quest_count
            missionVariables.IR_defences_quest = "COMPLETED"
            missionVariables.IR_defences_quest_deadline = null
            missionVariables.IR_defences_status_no = null
            player.clearDefencesStatus()
        }

        if (missionVariables.IR_status == "IR_KINNAIRD_2") {
            this._runScreen({
                messageKey: "IR_kinnaird_3alt"
            });
        }

        if (missionVariables.IR_status == "IR_LEXICON_1" && clock.days > missionVariables.IR_LEXICON_deadline) {
            this._runScreen({
                messageKey: "IR_LEXICON_2"
            });
            missionVariables.IR_status = "IR_LEXICON_2"
            mission.setInstructionsKey("IR_LEXICON_brief_2")
            missionVariables.IR_LEXICON_deadline = null
        }

        if (missionVariables.IR_status == "IR_CHERKASOVA_1") // briefing with Cherkasova
        {
            this._runScreen({
                messageKey: "IR_CHERKASOVA_1a",
                overlay: "IR_KSR_logo.png",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1)
                    this._runScreen({
                        messageKey: "IR_CHERKASOVA_1b",
                        overlay: "IR_KSR_logo.png",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1)
                            this._runScreen({
                                messageKey: "IR_CHERKASOVA_1c",
                                overlay: "IR_KSR_logo.png",
                                choicesKey: "IR_continue"
                            }, function (choice) {
                                if (choice == 1)
                                    this._runScreen({
                                        messageKey: "IR_CHERKASOVA_1d",
                                        overlay: "IR_KSR_logo.png",
                                        choicesKey: "IR_cherkasova_choices"
                                    }, function (choice) {
                                        if (choice == 1) {
                                            this._runScreen({
                                                messageKey: "IR_LOA_1",
                                                overlay: "IR_KSR_logo.png"
                                            })
                                            mission.setInstructionsKey("IR_LOA_brief_1")
                                            missionVariables.IR_status = "IR_LOA_1"
                                            mission.setInstructionsKey("IR_LOA_brief_1")
                                            missionVariables.IR_cherkasova_deadline = null
                                        }
                                        if (choice == 2) {
                                            this._runScreen({
                                                messageKey: "IR_sources_1",
                                                overlay: "IR_KSR_logo.png"
                                            }) //screen fails to run
                                            mission.setInstructionsKey("IR_LEXICON_brief_1")
                                            missionVariables.IR_status = "IR_sources_1"
                                            missionVariables.IR_cherkasova_deadline = null
                                            mission.setInstructionsKey("IR_LEXICON_brief_1")
                                            missionVariables.IR_sources_deadline = clock.days + 15
                                        }
                                    });
                            });
                    });
            });
        }

        if (missionVariables.IR_status == "IR_sources_1" && clock.days > missionVariables.IR_sources_deadline) {
            this._runScreen({
                messageKey: "IR_sources_2"
            });
            missionVariables.IR_status = "IR_sources_2"
            mission.setInstructionsKey("IR_waitforinfo_brief")
            missionVariables.IR_sources_deadline = clock.days + 7
        }

        if (missionVariables.IR_status == "IR_sources_2" && clock.days > missionVariables.IR_sources_deadline) {
            this._runScreen({
                messageKey: "IR_sources_3"
            });
            missionVariables.IR_status = "IR_sources_3"
            missionVariables.IR_sources_deadline = null
            mission.setInstructionsKey("IR_sources_brief_1")
        }

        if (missionVariables.IR_status == "IR_LOA_4" && clock.days > missionVariables.IR_attack_deadline) {
            this._runScreen({
                messageKey: "IR_LOA_5"
            });
            missionVariables.IR_status = "IR_LOA_5"
            missionVariables.IR_attack_deadline = null
            mission.setInstructionsKey("IR_LOA_brief_4")
        }

        if (missionVariables.IR_status == "IR_LOA_7" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_LOA_7"
            });
            missionVariables.IR_status = "IR_LOA_8"
            missionVariables.IR_epilogue_deadline = clock.days + 10
        }

        if (missionVariables.IR_status == "IR_LOA_8" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_LOA_8"
            });
            missionVariables.IR_status = "IR_LOA_9"
            missionVariables.IR_epilogue_deadline = clock.days + 7
        }

        if (missionVariables.IR_status == "IR_LOA_9" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_invite"
            });
            missionVariables.IR_status = "IR_invite"
            mission.setInstructionsKey("IR_invite_brief")
            missionVariables.IR_epilogue_deadline = null
        }

        if (missionVariables.IR_status == "IR_sources_6" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_sources_6"
            });
            missionVariables.IR_status = "IR_sources_7"
            missionVariables.IR_epilogue_deadline = clock.days + 15
        }

        if (missionVariables.IR_status == "IR_sources_7" && clock.days > missionVariables.IR_epilogue_deadline) {
            this._runScreen({
                messageKey: "IR_invite"
            });
            missionVariables.IR_status = "IR_invite"
            mission.setInstructionsKey("IR_invite_brief")
            missionVariables.IR_epilogue_deadline = null
        }

        //Location Specific
        if (system.ID == 7) //Vegedius
        {
            if (missionVariables.IR_status == "IR_IBANEZ_1") {
                this._runScreen({
                    title: "GalCop High Command",
                    messageKey: "IR_IBANEZ_2a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            title: "GalCop High Command",
                            messageKey: "IR_IBANEZ_2b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1) {
                                this._runScreen({
                                    title: "GalCop High Command",
                                    messageKey: "IR_IBANEZ_2c"
                                });
                                missionVariables.IR_status = "IR_IBANEZ_2"
                                mission.setInstructionsKey("IR_RAAED_INFO")
                            }
                        });
                });
            }

            if (missionVariables.IR_status == "IR_RAAED_1") //return to Ibanez
            {
                this._runScreen({
                    title: "Galcop High Command",
                    messageKey: "IR_IBANEZ_3"
                })
                missionVariables.IR_status = "IR_IBANEZ_3"
                mission.setInstructionsKey("IR_JANES_INFO")
            }


            if (missionVariables.IR_status == "IR_JANES_1") // return to Ibanez for big briefing
            {
                this._runScreen({
                    title: "GalCop High Command",
                    messageKey: "IR_IBANEZ_4a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            title: "GalCop High Command",
                            messageKey: "IR_IBANEZ_4b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    title: "GalCop High Command",
                                    messageKey: "IR_IBANEZ_4c",
                                    choicesKey: "IR_continue"
                                }, function (choice) {
                                    if (choice == 1) {
                                        this._runScreen({
                                            title: "GalCop High Command",
                                            messageKey: "IR_IBANEZ_4d"
                                        });
                                        missionVariables.IR_status = "IR_IBANEZ_4"
                                        mission.setInstructionsKey(null)
                                        this.setupQuestions()
                                        this.setupStatus()
                                        missionVariables.IR_quest_count = 0
                                        this.addIRinterface();
                                    }
                                });
                        });
                });
            }

            if (missionVariables.IR_status == "IR_IBANEZ_4" && missionVariables.IR_quest_count == 4) {
                missionVariables.IR_quest_count = null

                if (missionVariables.IR_shipment_quest_method == "YOKOHAMA_AMBUSH") {
                    this._runScreen({
                        messageKey: "IR_IBANEZ_5a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this._runScreen({
                                overlay: "IR_title.png",
                                messageKey: "IR_theend"
                            });
                            missionVariables.IR_status = "IR_completed"
                            mission.setInstructionsKey(null)
                            missionVariables.IR_epilogue_deadline = null
                            missionVariables.IR_shipment_quest = null
                            missionVariables.IR_SDF_quest = null
                            missionVariables.IR_defences_quest = null
                            missionVariables.IR_finance_quest = null
                            missionVariables.IR_shipment_quest_method = null
                        }
                    });
                }

                if (missionVariables.IR_shipment_quest == "FAILED") {
                    this._runScreen({
                        messageKey: "IR_IBANEZ_5b",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this._runScreen({
                                overlay: "IR_title.png",
                                messageKey: "IR_theend"
                            });
                            missionVariables.IR_status = "IR_completed"
                            mission.setInstructionsKey(null)
                            missionVariables.IR_epilogue_deadline = null
                            missionVariables.IR_shipment_quest = null
                            missionVariables.IR_SDF_quest = null
                            missionVariables.IR_defences_quest = null
                            missionVariables.IR_finance_quest = null
                            missionVariables.IR_shipment_quest_method = null
                        }
                    });
                } else
                    this._runScreen({
                        title: "GalCop High Command",
                        messageKey: "IR_IBANEZ_5",
                        choicesKey: "IR_IBANEZ_choices"
                    }, function (choice) {
                        if (choice == "IR_IBANEZ_A_weiss") {
                            this._runScreen({
                                title: "GalCop High Command",
                                messageKey: "IR_weiss_1"
                            });
                            missionVariables.IR_status = "IR_WEISS_1"
                            mission.setInstructionsKey("IR_weiss_brief_1")
                        }
                        if (choice == "IR_IBANEZ_B_kinnaird") {
                            this._runScreen({
                                title: "GalCop High Command",
                                messageKey: "IR_kinnaird_1"
                            });
                            missionVariables.IR_status = "IR_KINNAIRD_1"
                            mission.setInstructionsKey("IR_kinnaird_brief_1")
                        }
                        if (choice == "IR_IBANEZ_C_moreinfo") {
                            this._runScreen({
                                title: "GalCop High Command",
                                messageKey: "IR_LEXICON_1"
                            });
                            missionVariables.IR_status = "IR_LEXICON_1"
                            mission.setInstructionsKey("IR_LEXICON_1")
                            missionVariables.IR_LEXICON_deadline = clock.days + 15
                        }
                    });
            }

            if (missionVariables.IR_status == "IR_WEISS_4" || missionVariables.IR_status == "IR_KINNAIRD_4") {
                this._runScreen({
                    title: "Galcop High Command",
                    messageKey: "IR_IBANEZ_5_debrief"
                })
                missionVariables.IR_status = "IR_IBANEZ_5"
                mission.setInstructionsKey("IR_waitforinfo_brief")
                missionVariables.IR_cherkasova_deadline = clock.days + 20
            }

            if (missionVariables.IR_status == "IR_invite" && clock.days > missionVariables.IR_epilogue_deadline) {
                this._runScreen({
                    messageKey: "IR_reward_a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_reward_b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    messageKey: "IR_reward_c",
                                    choicesKey: "IR_continue",
                                    overlay: "IR_maenesmedal.png"
                                }, function (choice) {
                                    if (choice == 1)
                                        this._runScreen({
                                            messageKey: "IR_reward_d",
                                            choicesKey: "IR_continue"
                                        }, function (choice) {
                                            if (choice == 1) {
                                                this._runScreen({
                                                    messageKey: "IR_reward_e"
                                                });
                                                missionVariables.IR_status = "IR_epilogue"
                                                missionVariables.IR_epilogue_deadline = clock.days + 5
                                                player.credits += 50000
                                                mission.setInstructionsKey(null)
                                            }
                                        });
                                });
                        });
                });
            }
        }

        if (system.ID == 230) // RAAED
        {
            if (missionVariables.IR_status == "IR_IBANEZ_2") {
                this._runScreen({
                    messageKey: "IR_RAAED_1a",
                    overlay: "IR_forest.png",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            overlay: "IR_invoice.png",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    messageKey: "IR_RAAED_1c",
                                    overlay: "IR_forest.png",
                                    choicesKey: "IR_continue"
                                }, function (choice) {
                                    if (choice == 1)
                                        this._runScreen({
                                            messageKey: "IR_RAAED_1d",
                                            choicesKey: "IR_continue",
                                            overlay: "IR_forest.png"
                                        }, function (choice) {
                                            if (choice == 1) {
                                                this._runScreen({
                                                    messageKey: "IR_RAAED_1e",
                                                    overlay: "IR_forest.png"
                                                });
                                                missionVariables.IR_status = "IR_RAAED_1"
                                                mission.setInstructionsKey("IR_IBANEZ_INFO")
                                            }
                                        });
                                });
                        });
                });
            }
        }

        if (system.ID == 232) // Janes
        {
            if (missionVariables.IR_status == "IR_IBANEZ_3") // quick visit to Janes
            {
                this._runScreen({
                    messageKey: "IR_JANES_1a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_JANES_1b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1) {
                                this._runScreen({
                                    messageKey: "IR_JANES_1c"
                                });
                                missionVariables.IR_status = "IR_JANES_1"
                                mission.setInstructionsKey("IR_IBANEZ_INFO")
                            }
                        });
                });
            }

            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Janes's Shipyard Intelligence",
                    overlay: "IR_janes_logo.png",
                    messageKey: "IR_JANES_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_JANES_QUESTIONS"
            }
        }

        if (system.ID == 171) // Yokohama
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Yokohama Exports",
                    overlay: "IR_yk_logo.png",
                    messageKey: "IR_YOKOHAMA_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS"
            }
        }

        if (missionVariables.IR_convoy_exited == "TRUE" && missionVariables.IR_alsto == "HELP_ACCEPTED") {
            this._runScreen({
                messageKey: "IR_shipment_contact_report"
            });
            player.incrementShipmentStatus()
            missionVariables.IR_alsto = "INFORMED"
            missionVariables.IR_convoy_exited = null
        }

        if (system.ID == 240) // Pirate Cove
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4")

            {
                if (!missionVariables.IR_alsto) {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_intro",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                    missionVariables.IR_alsto = "MET"
                } else {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_intro_alt",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                }
            }

            if (missionVariables.IR_status == "IR_LOA_1") {
                if (missionVariables.IR_alsto)
                    missionVariables.IR_LOA_text = "known"
                if (missionVariables.IR_alsto == "INFORMED")
                    missionVariables.IR_LOA_text = "helped"
                if (!missionVariables.IR_alsto)
                    missionVariables.IR_LOA_text = "unknown"

                this._runScreen({
                    messageKey: "IR_LOA_" + [missionVariables.IR_LOA_text] + "_2a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_LOA_" + [missionVariables.IR_LOA_text] + "_2b",
                            choicesKey: "IR_continue"
                        }, function (choice) {
                            if (choice == 1)
                                this._runScreen({
                                    messageKey: "IR_LOA_2c",
                                    choicesKey: "IR_continue"
                                }, function (choice) {
                                    if (choice == 1) {
                                        this._runScreen({
                                            messageKey: "IR_LOA_2d"
                                        })
                                        missionVariables.IR_status = "IR_LOA_2"
                                        mission.setInstructionsKey("IR_LOA_brief_2")
                                        missionVariables.IR_alsto = null
                                        missionVariables.IR_LOA_text = null
                                    }
                                });
                        });
                });
            }
        }

        if (system.ID == 119) // PleasureWorld
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "PleasureWorld",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_PW_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_PW_QUESTIONS"
            }

            if (missionVariables.IR_status == "IR_WEISS_3") {
                this._runScreen({
                    title: "PleasureWord",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_weiss_3a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            overlay: "IR_pw_logo.png",
                            messageKey: "IR_weiss_3b"
                        })
                    missionVariables.IR_status = "IR_WEISS_4"
                    mission.setInstructionsKey("IR_weiss_brief_3")
                });
            }

            if (missionVariables.IR_status == "IR_KINNAIRD_3") {
                this._runScreen({
                    title: "PleasureWord",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_kinnaird_4a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_kinnaird_4b"
                        })
                    missionVariables.IR_status = "IR_KINNAIRD_4"
                    mission.setInstructionsKey("IR_kinnaird_brief_4")
                });
            }

            if (missionVariables.IR_status == "IR_LEXICON_2") {
                this._runScreen({
                    messageKey: "IR_LEXICON_3a",
                    overlay: "IR_nightclub.png",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_LEXICON_3b",
                            overlay: "IR_nightclub.png",
                            choicesKey: "IR_launch_choice"
                        }, function (choice) {
                            if (choice == 1) {
                                missionVariables.IR_status = "IR_LEXICON_4"
                                player.ship.launch()
                            }
                        });
                });
            }

            if (missionVariables.IR_status == "IR_weiss_scooped") {
                this._runScreen({
                    messageKey: "IR_LEXICON_4a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1)
                        this._runScreen({
                            messageKey: "IR_LEXICON_4b"
                        })
                    missionVariables.IR_status = "IR_IBANEZ_5"
                    mission.setInstructionsKey("IR_waitforinfo_brief")
                    missionVariables.IR_cherkasova_deadline = clock.days + 20
                });
            }
        }

        if (system.ID == 180) // NWE
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    overlay: "IR_NWE_logo.png",
                    messageKey: "IR_NWE_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_NWE_QUESTIONS"
            }

            if (missionVariables.IR_defences_quest == "DEMO_2") {
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    overlay: "IR_NWE_logo.png",
                    messageKey: "IR_defences_quest_2a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            title: "Naval Weapons Establishment",
                            overlay: "IR_NWE_logo.png",
                            messageKey: "IR_defences_quest_2b"
                        });
                        missionVariables.IR_defences_quest_deadline = clock.days + 7
                        missionVariables.IR_defences_quest = "DEMO_3"
                        player.incrementDefencesStatus()
                    }
                });
            }

            if (missionVariables.IR_defences_quest == "DEMO_3" && clock.days > missionVariables.IR_defences_quest_deadline) {
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    overlay: "IR_NWE_logo.png",
                    messageKey: "IR_defences_quest_3"
                });
                missionVariables.IR_defences_quest_deadline = null
                missionVariables.IR_defences_quest = "DEMO_4"
                player.incrementDefencesStatus()
            }
        }

        if (system.ID == 82) // Inorle
        {
            if (missionVariables.IR_SDF_quest == "JACOB") {
                this._runScreen({
                    messageKey: "IR_SDF_quest_3"
                })
                missionVariables.IR_SDF_quest = "LUFTSLOTTE"
            }
        }

        if (system.ID == 219) // GSE
        {
            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_GSE_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_GSE_QUESTIONS"
            }


            if (missionVariables.IR_finance_quest == "JANES_NEWS") {
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_finance_quest_6a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            title: "Galactic Stock Exchange",
                            overlay: "IR_GSE_logo.png",
                            messageKey: "IR_finance_quest_6b"
                        });
                        player.incrementFinanceStatus()
                        missionVariables.IR_offer = null
                        missionVariables.IR_finance_quest = "WIFE"
                    }
                });
            }

            if (missionVariables.IR_finance_quest == "WIFE_MET") {
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_finance_quest_8",
                    choicesKey: "IR_wife_choices"
                }, function (choice) {
                    if (choice == "IR_wife_yes") {
                        this._runScreen({
                            title: "Galactic Stock Exchange",
                            overlay: "IR_GSE_logo.png",
                            messageKey: "IR_finance_quest_9_confirm"
                        });
                        missionVariables.IR_wife_status = "AFFAIR_CONFIRMED"
                    }

                    if (choice == "IR_wife_no") {
                        this._runScreen({
                            title: "Galactic Stock Exchange",
                            overlay: "IR_GSE_logo.png",
                            messageKey: "IR_finance_quest_9_deny"
                        });
                        missionVariables.IR_wife_status = "AFFAIR_DENIED"
                    }

                    player.incrementFinanceStatus()
                    missionVariables.IR_finance_quest = "WAIT3"
                    missionVariables.IR_KORSHKOV_deadline = clock.days + 10
                    missionVariables.IR_offer = null
                });
            }
        }

        if (system.ID == 31) // KORSHKOV
        {
            if (missionVariables.IR_finance_quest == "WAIT" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_finance_quest_1"
                });
                player.incrementFinanceStatus()
                missionVariables.IR_finance_quest = "COLLECTION"
                missionVariables.IR_KORSHKOV_deadline = null
                return;
            }

            if (missionVariables.IR_finance_quest == "COLLECTION") {
                this.checkManifest()

                if (missionVariables.IR_manifestOK == "TRUE") {
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_finance_quest_2"
                    });
                    player.incrementFinanceStatus()
                    missionVariables.IR_KORSHKOV_deadline = clock.days + 10
                    missionVariables.IR_finance_quest = "WAIT2"
                    player.ship.manifest.radioactives -= 10
                    player.ship.manifest.alloys = -5
                    player.ship.manifest.minerals -= 2
                    player.ship.manifest.alienItems -= 2
                    player.ship.manifest.platinum -= 1
                    missionVariables.IR_manifestOK = null
                    return;
                }

                if (missionVariables.IR_manifestOK != "TRUE")
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_finance_quest_3alt"
                    });
                else return;
            }

            if (missionVariables.IR_finance_quest == "WAIT2" && clock.days >= missionVariables.IR_KORSHKOV_deadline) {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_finance_quest_3"
                });
                player.incrementFinanceStatus()
                missionVariables.IR_KORSHKOV_deadline = null
                missionVariables.IR_finance_quest = "IRRADIATE"
                return;
            }

            if (missionVariables.IR_SDF_quest == "KORSHKOV") {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_SDF_quest_6"
                });
                player.incrementSDFStatus()
                missionVariables.IR_SDF_deadline = clock.days + 10
                missionVariables.IR_SDF_quest = "ANALYSIS"
                player.ship.removeAllCargo()
                missionVariables.IR_cargoCount = null
                return;
            }

            if (missionVariables.IR_SDF_quest == "ANALYSIS" && clock.days >= missionVariables.IR_SDF_deadline)

            {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_SDF_quest_7a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_SDF_quest_7b"
                        });
                        missionVariables.IR_SDF_quest = "DATA"
                        player.incrementSDFStatus()
                        this.incrementSDFQuestion()
                        missionVariables.IR_SDF_location = null
                        missionVariables.IR_SDF_location_name = null
                    }
                });
                return;
            }

            if (missionVariables.IR_status == "IR_IBANEZ_4") {
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_KORSHKOV_intro",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
                return;
            }
        }

        if (system.ID == 142) // Tibiri bar
        {
            if (missionVariables.IR_finance_quest == "WIFE_DOCKED") {
                this._runScreen({
                    messageKey: "IR_finance_quest_7a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_finance_quest_7b"
                        });
                        player.incrementFinanceStatus()
                        player.credits += 1000
                        missionVariables.IR_offer = null
                        missionVariables.IR_finance_quest = "WIFE_MET"
                    }
                });
            }
            if (missionVariables.IR_finance_quest == "WIFE" || missionVariables.IR_finance_quest == "WIFE_IDENTIFIED")
                this._runScreen({
                    messageKey: "IR_finance_quest_7alt"
                });
        }

        if (system.ID == 23) // Maenes
        {
            if (missionVariables.IR_defences_question_no == 3 && !missionVariables.IR_defences_quest) {
                if (!missionVariables.IR_Maenes_visit) {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_defences_quest_1_alt"
                    });
                    missionVariables.IR_defences_quest = "DEMO_1"
                }
                if (missionVariables.IR_Maenes_visit == "TRUE") {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_defences_quest_1"
                    });
                    missionVariables.IR_defences_quest = "DEMO_1"
                    missionVariables.IR_Maenes_visit = null
                }

            }
            if (missionVariables.IR_defences_quest == "DEMO_4") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_defences_quest_4"
                });
                missionVariables.IR_defences_quest = "DEMO_5"
            }

            if (missionVariables.IR_defences_quest == "SABOTAGED") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_defences_quest_5a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_defences_quest_5b"
                        });
                        player.incrementDefencesStatus()
                        missionVariables.IR_defences_quest = "DEMO_6"
                        missionVariables.IR_defences_quest_deadline = clock.days + 15
                    }
                });
            }

            if (missionVariables.IR_status == "IR_sources_5") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_sources_5a",
                    choicesKey: "IR_continue"
                }, function (choice) {
                    if (choice == 1) {
                        this._runScreen({
                            messageKey: "IR_sources_5b"
                        });
                        mission.setInstructionsKey("IR_waitforinfo_brief")
                        missionVariables.IR_status = "IR_sources_6"
                        missionVariables.IR_epilogue_deadline = clock.days + 10
                    }
                });
            }

            if (missionVariables.IR_status == "IR_LOA_6") {
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_LOA_6"
                });
                mission.setInstructionsKey("IR_waitforinfo_brief")
                missionVariables.IR_status = "IR_LOA_7"
                missionVariables.IR_epilogue_deadline = clock.days + 10
            }
        }

        if (system.ID == 35 && missionVariables.IR_status == "IR_KINNAIRD_1") //Atanon
        {
            this._runScreen({
                messageKey: "IR_kinnaird_2"
            });
            missionVariables.IR_status = "IR_KINNAIRD_2"
        }

        if (system.ID == 41 && missionVariables.IR_status == "IR_KINNAIRD_2") //Orlaroor
        {
            this._runScreen({
                messageKey: "IR_kinnaird_3"
            });
            missionVariables.IR_status = "IR_KINNAIRD_3"
            mission.setInstructionsKey("IR_kinnaird_brief_3")
        }

        if (system.ID == 149 && missionVariables.IR_status == "IR_LOA_3") //Arenxeon
        {
            this._runScreen({
                messageKey: "IR_LOA_4a",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1) {
                    this._runScreen({
                        messageKey: "IR_LOA_4b"
                    });
                    missionVariables.IR_status = "IR_LOA_4"
                    missionVariables.IR_attack_deadline = clock.days + 10
                    mission.setInstructionsKey("IR_waitforinfo_brief")
                }
            });
        }

        if (system.ID == 63 && missionVariables.IR_status == "IR_sources_3") //Edsoan
        {
            this._runScreen({
                messageKey: "IR_sources_4a",
                choicesKey: "IR_continue"
            }, function (choice) {
                if (choice == 1) {
                    this._runScreen({
                        messageKey: "IR_sources_4b"
                    });
                    missionVariables.IR_status = "IR_sources_4"
                    mission.setInstructionsKey("IR_sources_brief_2")
                }
            });
        }
        //keep brackets	
    }
}

this.choiceEvaluation = function (choice) {
    switch (missionVariables.IR_offer) {
        case "IR_GSE_QUESTIONS": {
            if (choice == "IR_B_finance_question_key") {
                if (missionVariables.IR_finance_question_no == 1) {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_finance_answer_1a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementFinanceQuestion()
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_finance_answer_1b",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_finance_question_no > 1) {
                    missionVariables.IR_asked_question = missionVariables.IR_finance_question_string
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_A_shipment_question_key") {
                if (missionVariables.IR_shipment_question_no == 2 && !missionVariables.IR_GSE_loan) {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_loan_offer",
                        choicesKey: "IR_loan_choices"
                    }, function (choice) {
                        if (choice == "IR_loan_yes") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_agreed"
                            });
                            missionVariables.IR_GSE_loan = "ACCEPTED"
                            player.credits += 500000
                            missionVariables.IR_loan_deadline = clock.days + 60
                            missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days
                            mission.setInstructionsKey("IR_loan_amount")
                            missionVariables.IR_offer = null
                        }
                        if (choice == "IR_loan_no") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_rejected",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = null
                            missionVariables.IR_GSE_loan = "REJECTED"
                        }
                        if (choice == "IR_loan_defer") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_deferred",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                            missionVariables.IR_GSE_loan = "DEFERRED"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_GSE_loan == "DEFERRED") {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_loan_repeat_offer",
                        choicesKey: "IR_loan_choices"
                    }, function (choice) {
                        if (choice == "IR_loan_yes") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_agreed"
                            });
                            missionVariables.IR_GSE_loan = "ACCEPTED"
                            player.credits += 500000
                            missionVariables.IR_loan_deadline = clock.days + 60
                            missionVariables.IR_loan_remaining = missionVariables.IR_loan_deadline - clock.days
                            mission.setInstructionsKey("IR_loan_amount")
                            missionVariables.IR_offer = null
                        }
                        if (choice == "IR_loan_no") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_rejected",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                            missionVariables.IR_GSE_loan = "REJECTED"
                        }
                        if (choice == "IR_loan_defer") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_loan_deferred",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                            missionVariables.IR_GSE_loan = "DEFERRED"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_GSE_loan == "ACCEPTED") {
                    this._runScreen({
                        title: "Galactic Stock Exchange",
                        overlay: "IR_GSE_logo.png",
                        messageKey: "IR_GSE_loan_demand",
                        choicesKey: "IR_pay_choices"
                    }, function (choice) {
                        if (choice == "IR_pay_yes") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_pay_accepted",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_GSE_loan = "PAID"
                            player.credits -= 550000
                            missionVariables.IR_loan_deadline = null
                            missionVariables.IR_loan_remaining = null
                            mission.setInstructionsKey(null)
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                        }
                        if (choice == "IR_pay_no") {
                            this._runScreen({
                                title: "Galactic Stock Exchange",
                                overlay: "IR_GSE_logo.png",
                                messageKey: "IR_GSE_pay_deferred",
                                choicesKey: "IR_questions"
                            }, this.choiceEvaluation);
                            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
                        }
                    });
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Galactic Stock Exchange",
                    overlay: "IR_GSE_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_GSE_QUESTIONS"
            break;
        }

        case "IR_KORSHKOV_QUESTIONS": {
            if (choice == "IR_B_finance_question_key") {
                if (missionVariables.IR_finance_question_no == 2) {
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_KORSHKOV_finance_answer_1a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementFinanceQuestion()
                            this._runScreen({
                                title: "OKB Korshkov",
                                overlay: "IR_korshlogo.png",
                                messageKey: "IR_KORSHKOV_finance_answer_1b"
                            });
                            missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
                            missionVariables.IR_KORSHKOV_deadline = clock.days + 5
                            player.incrementFinanceStatus()
                            missionVariables.IR_offer = null
                            missionVariables.IR_finance_quest = "WAIT"
                        }
                    });
                    break;
                }

                if (missionVariables.IR_finance_question_no > 2) {
                    missionVariables.IR_asked_question = missionVariables.IR_finance_question_string
                    this._runScreen({
                        title: "OKB Korshkov",
                        overlay: "IR_korshlogo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }


            if (choice == "IR_E_exit_question_key") {
                return;
            } else
                this._runScreen({
                    title: "OKB Korshkov",
                    overlay: "IR_korshlogo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_KORSHKOV_QUESTIONS"
            break;
        }

        case "IR_JANES_QUESTIONS": {
            if (choice == "IR_A_shipment_question_key") {
                this._runScreen({
                    title: "Jane's Shipyard Intelligence",
                    overlay: "IR_janes_logo.png",
                    messageKey: "IR_no_more_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                break;
            }

            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no == 1) {
                    this.incrementSDFQuestion()
                    this._runScreen({
                        title: "Jane's Shipyard Intelligence",
                        overlay: "IR_janes_logo.png",
                        messageKey: "IR_JANES_SDF_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }

                if (missionVariables.IR_SDF_question_no > 1) {
                    this._runScreen({
                        title: "Jane's Shipyard Intelligence",
                        overlay: "IR_janes_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_D_defences_question_key") {
                this._runScreen({
                    title: "Jane's Shipyard Intelligence",
                    overlay: "IR_janes_logo.png",
                    messageKey: "IR_JANES_defences_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
                break;
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Jane's Shipyard Intelligence",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_JANES_QUESTIONS"
            break;
        }

        case "IR_PIRATE_QUESTIONS": {
            if (choice == "IR_A_shipment_question_key") {
                if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_shipment_quest == "SET") {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_shipment_answer",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1)
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_PIRATE_shipment_offer",
                                choicesKey: "IR_pirate_choices"
                            }, function (choice) {
                                if (choice == "IR_pirate_yes") {
                                    this._runScreen({
                                        title: " ",
                                        messageKey: "IR_PIRATE_shipment_accepted"
                                    });
                                    missionVariables.IR_alsto = "HELP_ACCEPTED"
                                    player.credits -= 250000
                                    player.incrementShipmentStatus()
                                    missionVariables.IR_offer = null
                                }
                                if (choice == "IR_pirate_no") {
                                    this._runScreen({
                                        title: " ",
                                        messageKey: "IR_PIRATE_shipment_declined"
                                    });
                                    missionVariables.IR_offer = null
                                    missionVariables.IR_alsto = "HELP_DECLINED"
                                }
                            });
                    });
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 1) {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_negative_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_alsto == "HELP_ACCEPTED")
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_shipment_confirm_help"
                    });


                if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_alsto == "HELP_DECLINED") {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_shipment_deferred_help",
                        choicesKey: "IR_pirate_choices"
                    }, function (choice) {
                        if (choice == "IR_pirate_yes") {
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_PIRATE_shipment_accepted"
                            });
                            missionVariables.IR_alsto = "HELP_ACCEPTED"
                            player.credits -= 250000
                            player.incrementShipmentStatus()
                            missionVariables.IR_offer = null
                        }
                        if (choice == "IR_pirate_no") {
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_PIRATE_shipment_declined"
                            });
                            missionVariables.IR_offer = null
                            missionVariables.IR_alsto = "HELP_DECLINED"
                        }

                    });

                    if (missionVariables.IR_shipment_question_no == 2 && missionVariables.IR_shipment_quest != "SET") {
                        missionVariables.IR_asked_question = missionVariables.IR_shipment_question_string
                        this._runScreen({
                            title: " ",
                            messageKey: "IR_no_more_answer",
                            choicesKey: "IR_questions"
                        }, this.choiceEvaluation);
                        break;
                    }
                }
            }

            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no < 2)
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_SDF_answer_1",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);

                if (missionVariables.IR_SDF_question_no == 2)
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_PIRATE_SDF_answer_2",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);

                if (missionVariables.IR_SDF_question_no > 2) {
                    this._runScreen({
                        title: " ",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                }
                break;
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: " ",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_PIRATE_QUESTIONS"
            break;
        }

        case "IR_YOKOHAMA_QUESTIONS": {
            if (choice == "IR_A_shipment_question_key") {
                if (missionVariables.IR_shipment_question_no == 1) {
                    this.incrementShipmentQuestion()
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_YOKOHAMA_shipment_answer_1"
                    });
                    missionVariables.IR_YOKOHAMA_deadline = clock.days + 30
                    missionVariables.IR_shipment_quest = "SET"
                    missionVariables.IR_offer = null
                    player.incrementShipmentStatus()
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 2 && clock.days < missionVariables.IR_YOKOHAMA_deadline) {
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_YOKOHAMA_shipment_answer_2",
                        choicesKey: "IR_YOKOHAMA_choices"
                    }, function (choice) {
                        if (choice == "IR_YOKOHAMA_yes") {
                            if (player.credits >= 1000000) {
                                this._runScreen({
                                    title: "Yokohama Exports",
                                    overlay: "IR_yk_logo.png",
                                    messageKey: "IR_YOKOHAMA_shipment_agreed"
                                });
                                missionVariables.IR_shipment_quest = "SUCCESS"
                                missionVariables.IR_shipment_quest_method = "PURCHASED"
                                missionVariables.IR_YOKOHAMA_deadline = null
                                    ++missionVariables.IR_quest_count
                                this.incrementShipmentQuestion()
                                player.clearShipmentStatus()
                                missionVariables.IR_offer = null
                                player.credits -= 1000000
                            } else {
                                this._runScreen({
                                    title: "Yokohama Exports",
                                    overlay: "IR_yk_logo.png",
                                    messageKey: "IR_YOKOHAMA_shipment_nomoney"
                                });
                                missionVariables.IR_offer = null
                            }
                        }

                        if (choice == "IR_YOKOHAMA_no") {
                            this._runScreen({
                                title: "Yokohama Exports",
                                overlay: "IR_yk_logo.png",
                                messageKey: "IR_YOKOHAMA_shipment_declined"
                            });
                            missionVariables.IR_shipment_quest = "ENROUTE"
                            this.incrementShipmentQuestion()
                            missionVariables.IR_offer = null
                            if (missionVariables.IR_alsto) {
                                player.incrementShipmentStatus()
                            }
                        }

                        if (choice == "IR_YOKOHAMA_defer") {
                            this._runScreen({
                                title: "Yokohama Exports",
                                overlay: "IR_yk_logo.png",
                                messageKey: "IR_YOKOHAMA_shipment_defer"
                            });
                            missionVariables.IR_offer = null
                        }
                    });
                    break;
                }

                if (missionVariables.IR_shipment_question_no == 2 && clock.days > missionVariables.IR_YOKOHAMA_deadline) {
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_YOKOHAMA_shipment_toolate"
                    });
                    missionVariables.IR_shipment_quest = "DISPATCHED"
                    player.clearShipmentStatus()
                    missionVariables.IR_offer = null
                    break;
                }

                if (missionVariables.IR_shipment_question_no > 2) {
                    missionVariables.IR_asked_question = missionVariables.IR_shipment_question_string
                    this._runScreen({
                        title: "Yokohama Exports",
                        overlay: "IR_yk_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Yokohama Exports",
                    overlay: "IR_yk_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_YOKOHAMA_QUESTIONS"
            break;
        }

        case "IR_PW_QUESTIONS": {
            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no == 2) {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_pw_logo.png",
                        messageKey: "IR_PW_SDF_answer_1",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementSDFQuestion()
                            this._runScreen({
                                title: " ",
                                messageKey: "IR_SDF_quest_1"
                            });
                            missionVariables.IR_SDF_quest = "ADDRESS"
                            missionVariables.IR_SDF_deadline = clock.days + 10
                        }
                    });
                    break;
                }

                if (missionVariables.IR_SDF_question_no == 3) {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_pw_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }

                if (missionVariables.IR_SDF_question_no == 5) {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_devries.png",
                        messageKey: "IR_PW_SDF_answer_2"
                    });
                    this.incrementSDFQuestion()
                    missionVariables.IR_SDF_quest = "PHOTO"
                    missionVariables.IR_SDF_deadline = clock.days + 35
                } else {
                    this._runScreen({
                        title: "PleasureWorld",
                        overlay: "IR_pw_logo.png",
                        messageKey: "IR_negative_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                }
                break;
            }

            if (choice == "IR_E_exit_question_key") {
                missionVariables.IR_offer = "IR_ASKED"
                return;
            } else
                this._runScreen({
                    title: "PleasureWorld",
                    overlay: "IR_pw_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_PW_QUESTIONS"
            break;
        }

        case "IR_NWE_QUESTIONS": {
            if (choice == "IR_C_SDF_question_key") {
                if (missionVariables.IR_SDF_question_no == 4) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_NWE_SDF_answer_1a",
                        choicesKey: "IR_continue"
                    }, function (choice) {
                        if (choice == 1) {
                            this.incrementSDFQuestion()
                            this._runScreen({
                                title: " ",
                                overlay: "IR_NWE_logo.png",
                                messageKey: "IR_NWE_SDF_answer_1b"
                            });
                        }
                        missionVariables.IR_offer = null
                    });
                }

                if (missionVariables.IR_SDF_question_no < 4 || missionVariables.IR_SDF_question_no > 4) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_negative_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                }
                break;
            }

            if (choice == "IR_D_defences_question_key") {
                if (missionVariables.IR_defences_question_no < 3) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_NWE_defences_answer_1"
                    });
                    missionVariables.IR_defences_question_no = 3
                    missionVariables.IR_offer = null
                    player.incrementDefencesStatus()
                    break;
                }

                if (missionVariables.IR_defences_question_no == 3) {
                    this._runScreen({
                        title: "Naval Weapons Establishment",
                        overlay: "IR_NWE_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "Naval Weapons Establishment",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_NWE_QUESTIONS"
            break;
        }

        case "IR_MAENES_QUESTIONS": {
            if (choice == "IR_D_defences_question_key") {
                if (missionVariables.IR_defences_question_no == 1) {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_MAENES_defences_answer_1"
                    });
                    this.incrementDefencesQuestion()
                    missionVariables.IR_offer = null
                    missionVariables.IR_Maenes_visit = "TRUE"
                    break;
                }

                if (missionVariables.IR_defences_question_no >= 2) {
                    this._runScreen({
                        title: "QuiCo Pharmaceuticals",
                        overlay: "IR_quico_logo.png",
                        messageKey: "IR_no_more_answer",
                        choicesKey: "IR_questions"
                    }, this.choiceEvaluation);
                    break;
                }
            }

            if (choice == "IR_E_exit_question_key")
                return;
            else
                this._runScreen({
                    title: "QuiCo Pharmaceuticals",
                    overlay: "IR_quico_logo.png",
                    messageKey: "IR_negative_answer",
                    choicesKey: "IR_questions"
                }, this.choiceEvaluation);
            missionVariables.IR_offer = "IR_MAENES_QUESTIONS"
            break;
        }
    }
}
