"use strict";
this.name = "XenonUI_HeightFix";
this.author = "phkb";
this.copyright = "2025 phkb";
this.description = "Small tweak to ensure turning HUD on/off results in the right size UI";
this.license = "CC BY-NC-SA 3.0";

this._checking = false;

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function() {
    if (this._checking) {
        if (!player.ship.hudHidden) {
            var x = worldScripts.XenonUI;
            var lib = worldScripts.Lib_GUI;
            if (lib && x._enableLibGUIInt && lib.$cur == "XenonUI") {
                lib.guiScreenChanged();
            } else {
                x.guiScreenChanged("", "");
            }
        }
        this._checking = false;
    }
}

//-------------------------------------------------------------------------------------------------------------
this.guiScreenChanged = function(to, from) {
    if (from == "GUI_SCREEN_MISSION") {
        if (player.ship.hudHidden) this._checking = true;
    }
}