"use strict";
this.name        = "AstroFactory_Conditions";
this.author      = "phkb";
this.copyright   = "2024 phkb";
this.description = "Condition script for ships and equipment.";
this.licence     = "CC BY-NC-SA 3.0";

//-------------------------------------------------------------------------------------------------------------
this.allowSpawnShip = function(shipKey) {
	if (system.government !== 3) return false;
	switch (shipKey) {
		case "dfl_astrofactory":
        case "dfl_astrofactory2":
		case "imp_lictor":
            if (system.economy < 3) return true;
            break;
        case "dfl_astrofarm":
        case "dfl_astrofarm2":
        case "rev_lictor":
            if (system.economy > 4) return true;
            break;
        case "imp_police_lictor":
			if (worldScripts["dictators.js"] && worldScripts["dictators.js"]._settings.policeShipReplace == false) return false;
            if (system.economy < 3) return true;
            break;
        case "rev_police_lictor":
			if (worldScripts["dictators.js"] && worldScripts["dictators.js"]._settings.policeShipReplace == false) return false;
            if (system.economy > 4) return true;
            break;
	}
	return false;
}
