"use strict";
this.name = "dfl_imperial_astrofactory";
this.author = "Spara";
this.copyright = "2013 Mika Spåra";
this.license = "CC BY-NC-SA 3.0";
this.description = "Add astrofactory and astrofarm to dictatorship systems";

//-------------------------------------------------------------------------------------------------------------
this.startUp = function() {
	if (worldScripts["dictators.js"]) {
		delete this.systemWillPopulate;
	}
	if (worldScripts.StationDockControl) {
		var sdc = worldScripts.StationDockControl;
		sdc._shipFits["Revolutionary AstroFarm|Serpent Class Cruiser"] = 0;
		sdc._shipFits["Revolutionary AstroFarm|Hornet"] = 0;
		sdc._shipFits["Revolutionary AstroFarm|Anaconda"] = 0;
		sdc._shipFits["Revolutionary AstroFarm|Boa Class Cruiser"] = 0;
		sdc._shipFits["Revolutionary AstroFarm|Boa"] = 0;
		sdc._shipFits["Revolutionary AstroFarm|Cobra Mark IV"] = 0;
		sdc._trafficLow.push("astrofarm");
	}
}

//-------------------------------------------------------------------------------------------------------------
this.systemWillPopulate = function() {
	if (system.government != 3) return;
	var sv = worldScripts.station_validator;
	if (system.economy < 3 && system.countShipsWithRole("astrofactory") === 0) {
		if (sv && (sv.$deaths("dfl_astrofactory").length !== 0 || sv.$deaths("dfl_astrofactory2").length !== 0)) return;
		var posAF = Vector3D((system.scrambledPseudoRandomNumber(1245) * 0.30 - 0.15), (system.scrambledPseudoRandomNumber(3827) * 0.30 - 0.15), 0.3).fromCoordinateSystem("wpu");
		system.setPopulator("dictators_astrofactory", {
			location: "COORDINATES",
			coordinates: posAF,
			deterministic:true,
			callback: function(pos) {
				var rck = system.addShips("asteroid", 30, pos, 40E3);
				var key = "dfl_astrofactory";
				if (system.techLevel >= 10) key = "dfl_astrofactory2";
				var af = system.addShips("[" + key + "]", 1, pos, 0);
				if (!af || af.length === 0) log("astrofactory.populator", "OOPS! No astrofactory spawned");
			}}
		);
	}
	if (system.economy > 4 && system.countShipsWithRole("astrofarm") === 0) {
		if (sv && (sv.$deaths("dfl_astrofarm").length !== 0 && sv.$deaths("dfl_astrofarm2").length !== 0)) return;
		var posAFM = Vector3D((system.scrambledPseudoRandomNumber(2271) * 0.30 - 0.15), (system.scrambledPseudoRandomNumber(772) * 0.30 - 0.15), 0.3).fromCoordinateSystem("spu");
		system.setPopulator("dictators_astrofarm", {
			location: "COORDINATES",
			coordinates: posAFM,
			deterministic:true,
			callback: function(pos) {
				var key = "dfl_astrofarm";
				if (system.techLevel >= 6) key = "dfl_astrofarm2";
				var af = system.addShips("[" + key + "]", 1, pos, 0);
				if (!af || af.length === 0) 
					log("astrofarm.populator", "OOPS! No astrofarm spawned");
				else 
					worldScripts.dfl_imperial_astrofactory.turnStationToEntity(af[0], system.sun, -1.5, 0, 1); // get solar panel to face sun
			}}
		);
	}
}

//-------------------------------------------------------------------------------------------------------------
this.turnStationToEntity = function (station, entity, x, y, z) {
	var targetVector = entity.position.subtract(station.position).direction();
	station.orientation = targetVector.rotationTo([(!x ? 0 : x), (!y ? 0 : y), (!z ? 1 : z)]);
}