"use strict";

this.name        = "station_ads"; 
this.author      = "spara";
this.description = "Pooling ad service";

this.$vertAdPool = [];
this.$horzAdPool = [];

//public function for adding vertical ad to pool. the parameter is the filename of the ad.
this._setVertAd = function(ad) {
  this.$vertAdPool.push(ad);
}

//public function for adding horizontal ad to pool. the parameter is the filename of the ad.
this._setHorzAd = function(ad) {
  this.$horzAdPool.push(ad);
}

this.startUp = function() {
  //add vertical ads to pools
  for (var i = 1; i <= 73; i++) {
    this.$vertAdPool.push("station_ads_vert_" + i + ".png");
  }
  //add horizontal ads to pools
  for (var i = 1; i <= 379; i++) {
    this.$horzAdPool.push("station_ads_horz_" + i + ".png");
  }
}

this.startUpComplete = function() {
  //shuffle the pools
  this.$vertAdPool = this._shuffle(this.$vertAdPool);
  this.$horzAdPool = this._shuffle(this.$horzAdPool);
  
	//Pools are divided to two parts to prevent the same ad to be seen in a quick succession. Pools are split into two parts and a primary part is randomly selected. When the active part is emptied, then the secondary part is used. When that is emptied too, pool is initialized and we draw from the primary part again.
  this._initVertPool();
	this.$vertPrimary = Math.round(Math.random());

  this._initHorzPool();
	this.$horzPrimary = Math.round(Math.random());
}

this._shuffle = function(pool) {
  var shuffled = new Array();
  var poolSize = pool.length;
  for (var i = poolSize; i > 0; i--) {
    shuffled.push(pool.splice(Math.floor(Math.random() * i), 1)[0]);
  }
  return shuffled;
}

//init the pool and divide it into two parts.
this._initVertPool = function() {
	var vertPoolSize = this.$vertAdPool.length;
  this.$vertPool = [this.$vertAdPool.slice(0, Math.floor(vertPoolSize / 2)), this.$vertAdPool.slice(Math.ceil(vertPoolSize / 2), vertPoolSize - 1)];
}

//init the pool and divide it into two parts.
this._initHorzPool = function() {
	var horzPoolSize = this.$horzAdPool.length;
  this.$horzPool = [this.$horzAdPool.slice(0, Math.floor(horzPoolSize / 2)), this.$horzAdPool.slice(Math.ceil(horzPoolSize / 2), horzPoolSize - 1)];	
}

//public function that returns a random vertical ad filename from the pool
this._getVerticalAd = function() {
	//is the active part empty?
	if (this.$vertPool[this.$vertPrimary].length === 0) {
		//switch the active part
		this.$vertPrimary = (this.$vertPrimary + 1) % 2;
		//is the active part still empty
		if (this.$vertPool[this.$vertPrimary].length === 0) {
			//init pool
			this._initVertPool();
		};
	};
	//select an ad randomly from the active part
	var adNum = Math.floor(Math.random() * this.$vertPool[this.$vertPrimary].length);
	//return and remove the selected ad from the pool
	return this.$vertPool[this.$vertPrimary].splice(adNum, 1)[0];
}

//public function that returns a random horizontal ad filename from the pool
this._getHorizontalAd = function() {
	if (this.$horzPool[this.$horzPrimary].length === 0) {
		this.$horzPrimary = (this.$horzPrimary + 1) % 2;
		if (this.$horzPool[this.$horzPrimary].length === 0) {
			this._initHorzPool();
		};
	};
	var adNum = Math.floor(Math.random() * this.$horzPool[this.$horzPrimary].length);
	return this.$horzPool[this.$horzPrimary].splice(adNum, 1)[0];
}
