// JavaScript for Oolite (ECMAScript 5)
"use strict";

    this.license = "CC-BY-NC-SA 4.0";
    this.author  = "Wildeblood";
    this.version = "0.8";
    this.name    = "Lost_In_Space_tests";

 // This script adds the test functions "Randomize Chart"
 // and "Reset Chart" to the in-game F4 screen.

    this.missionScreenOpportunity = function () {
        if (worldScripts.Lost_In_Space) {
            this.shipExitedWitchspace();
            log(this.oolite_manifest_identifier, "Test functions added to F4 screen.");
        } else {
            log(this.oolite_manifest_identifier, "Could not find worldScripts.Lost_In_Space");
            delete this.shipExitedWitchspace;
            delete this._randomizeChart;
            delete this._resetChart;
        }
        delete this.missionScreenOpportunity; // Runs only once, shortly after startUpComplete
    };

/* ==================== TESTING FUNCTIONS ==================== */

    this.shipExitedWitchspace = function () {
        if (system.mainStation) {
            system.mainStation.setInterface("randomize_chart", {
              title: "Randomize Chart",
              category: "A TEST",
              summary: "Randomize appearance of current chart (galaxy " + galaxyNumber + ").",
              callback: this._randomizeChart.bind(this)
            });
            system.mainStation.setInterface("reset_chart", {
              title: "Reset Chart",
              category: "A TEST",
              summary: "Reset all changes to current chart (galaxy " + galaxyNumber + ").",
              callback: this._resetChart.bind(this)
            });
        }
    };

    this._randomizeChart = function () {
        player.consoleMessage("Chart will be randomized in a few seconds.", 10);
        worldScripts.Lost_In_Space.playerEnteredNewGalaxy(); // Call without parameter, because we don't need to reset the previous chart
    };

    this._resetChart = function () {
        player.consoleMessage("Chart will be reset in a few seconds.", 10);
        worldScripts.Lost_In_Space._resetAllSystemsInGalaxy(galaxyNumber);
    };
