// JavaScript for Oolite (ECMAScript 5)
"use strict";

    this.license = "CC-BY-NC-SA 4.0";
    this.author  = "Wildeblood";
    this.version = "0.8";
    this.name    = "Lost_In_Space";

    this.playerEnteredNewGalaxy = function (galaxy) {
     // Choose number of systems to hide
        const TOTAL = 256;
        const MIN = 51;      // 20 % of 256
        const MAX = 128;     // 50 % of 256
        const SYSTEMS_TO_HIDE = Math.floor(Math.random() * (MAX - MIN + 1)) + MIN;

     // Create an array of sysIDs (0-255), but with order shuffled
        var sysIDs = [];
        for (let i = 0; i < TOTAL; i++) {
            sysIDs.push(i);
        }
     // Shuffle using Fisher–Yates algorithm
        for (let i = sysIDs.length - 1; i > 0; i--) {
            const j = Math.floor(Math.random() * (i + 1));
            [sysIDs[i], sysIDs[j]] = [sysIDs[j], sysIDs[i]];
        }

     // Read sysIDs from the array and hide up to chosen number
        for (let i = 0; i < TOTAL; i++) {
            if (i < SYSTEMS_TO_HIDE) {
                System.infoForSystem(galaxyNumber, sysIDs[i]).setProperty(3, "concealment", "300");
            } else {
                this._renewSystem(sysIDs[i]);
            }
        }
        log(this.oolite_manifest_identifier, "Randomly concealed " + SYSTEMS_TO_HIDE + " systems in galaxy " + galaxyNumber + ".");

     // Remove changes made to previous galaxy to avoid bloating the save file
        if (typeof galaxy === "undefined" || galaxy < 0 || galaxy > 7) {
            log(this.name, "playerEnteredNewGalaxy called with no galaxy parameter, skipped resetting the previous galaxy.");
            return;
        }
        galaxy = (galaxy + 7) % 8;  // Calculate previous galaxy number
        this._resetAllSystemsInGalaxy(galaxy);

     // Add disabled galactic hyperdrive
        player.ship.awardEquipment("EQ_GAL_DRIVE");
        player.ship.setEquipmentStatus("EQ_GAL_DRIVE", "EQUIPMENT_DAMAGED");
    };

    this._renewSystem = function (sysID) {
        const sys = System.infoForSystem(galaxyNumber, sysID);
        sys.setProperty(3, "concealment", null);
        sys.setProperty(2, "name", expandDescription("[lost_in_space_planet]"));
        sys.setProperty(1, "economy", Math.floor(Math.random() * 8));
        sys.setProperty(1, "government", Math.floor(Math.random() * 8));
        sys.setProperty(1, "techlevel", Math.floor(Math.random() * 16));
        sys.setProperty(1, "description", expandDescription("[lost_in_space_description]"));
    };

    this._resetAllSystemsInGalaxy = function (galaxy) {
        if (typeof galaxy !== "number" || galaxy < 0 || galaxy > 7) {
            log(this.name, "Invalid galaxy parameter. Defaulting to galaxyNumber: " + galaxyNumber);
            galaxy = galaxyNumber;
        }
        for (let sysID = 0; sysID <= 255; sysID++) {
            var sys = System.infoForSystem(galaxy, sysID);
            sys.setProperty(3, "concealment", null);
            sys.setProperty(2, "name", null);
            sys.setProperty(1, "economy", null);
            sys.setProperty(1, "government", null);
            sys.setProperty(1, "techlevel", null);
            sys.setProperty(1, "description", null);
        }
    };
