"use strict";
this.name = "deposed";
this.author = "Cmdr. Wombat, JS translation by Eric Walch";
this.description = "Script used for the Deposed mission.";
this.license = "CC-BY-NC-SA 3.0";

this._logging = false;

//-------------------------------------------------------------------------------------------------------------
this.startUp = function () {
    var deposed = missionVariables.deposed;
    if (deposed == "MISSION_COMPLETE" || deposed == "ABANDONED" || deposed == "NOT_PLAYED") {
        // mission is over, no need to evaluate any code in the future.
        this.$clearHandlers();
    }
    this.firstLaunch = true;

    this.log_variables_to_log("startUp");
};

//-------------------------------------------------------------------------------------------------------------
this.startUpComplete = function() {
    var pad = worldScripts.Lib_PAD;
    if (!pad) return;
    if (missionVariables.deposed_padchars && missionVariables.deposed_padchars.length > 0) {
        for (var i = 0; i < missionVariables.deposed_padchars.length; i++) {
            this.$addPadCharacter(missionVariables.deposed_padchars[i]);
        }
    }
    if (missionVariables.deposed_padchars_update) {
        var people = Object.keys(missionVariables.deposed_padchars_update);
        for (var i = 0; i < people.length; i++) {
            this.$updatePadCharacterRank(people[i], missionVariables.deposed_padchars_update[people[i]]);
        }
    }
    if (missionVariables.deposed_padchars_info) {
        var people = Object.keys(missionVariables.deposed_padchars_info);
        for (var i = 0; i < people.length; i++) {
            for (var j = 0; j < missionVariables.deposed_padchars_info[people[i]].length; j++) {
                this.$addInfoToPadCharacter(people[i], missionVariables.deposed_padchars_info[people[i]][j]);
            }
        }
    }
}

//-------------------------------------------------------------------------------------------------------------
this.missionScreenOpportunity = function () {
    var deposed = missionVariables.deposed;
    if (player.ship.dockedStation.isMainStation && galaxyNumber == 3) {

        if (!deposed && !missionVariables.deposed_started && player.score > 1693) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_teaser", choicesKey: "deposed_bien" },
                function (choice) {
                    if (choice == "YES") {
                        missionVariables.deposed = "PRELUDE";
                        missionVariables.depask = "DRILE";
                        missionVariables.depbien = "OKAY";
                        missionVariables.deposed_started = "YES";
                        mission.setInstructionsKey("deposed_desc0");
                        this.$markSystem(11);
                    }
                    if (choice == "NO") {
                        missionVariables.deposed = "NOT_PLAYED";
                        this.$missionEnded();
                    }
                });
        }

        if (system.ID == 11 && deposed == "PRELUDE") {
            this.$unmarkSystem(11);
            missionVariables.deposed = "PART1_1";
            missionVariables.depbien = "BUGGERED";
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_part1_1" });
            if (player.bounty == 0) {
                missionVariables.depstat = "CLEAN";
            } else if (player.bounty > 31) {
                missionVariables.depstat = "FUGITIVE";
            } else {
                missionVariables.depstat = "OFFENDER";
            };
            this.$markSystem(119);
            mission.setInstructionsKey("deposed_desc1");
            this.$addPadCharacter("drile");
        }

        if (system.ID == 119 && deposed == "PART1_1") {
            this.$unmarkSystem(119);
            missionVariables.deposed = "PART1_2";
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_part1_2" });
            this.$markSystem(42);
            mission.setInstructionsKey("deposed_desc2");
        }

        if (system.ID == 42 && deposed == "PART1_2") {
            this.$unmarkSystem(42);
            missionVariables.deposed = "PART1_3";
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_part1_3" });
            player.credits += 5000;
            mission.setInstructionsKey(null);
            this.$addPadLogEntry("Got 5k Cr for delivering Ruben Drile to Zadige successfully.");
        }

        if (system.ID != 42 && deposed == "PART1_3" && System.infoForSystem(galaxyNumber, 42).distanceToSystem(System.infoForSystem(galaxyNumber, system.ID)) > 7 && system.scrambledPseudoRandomNumber(system.ID) > 0.5) {
            // the random value excludes all systems in 7LY range. Edbire is probably the closest system
            if (missionVariables.depstat == "CLEAN") {
                missionVariables.deposed = "PART1_4";
                missionKey = "deposed_part1_4c"
            } else if (missionVariables.depstat == "OFFENDER") {
                missionVariables.deposed = "PART1_4";
                missionKey = "deposed_part1_4o";
                player.bounty |= 5;
            } else { // = FUGITIVE
                missionVariables.deposed = "PART1_6A";
                missionKey = "deposed_part1_4f";
                player.bounty |= 90;
            }
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: missionKey, overlay: "deposed_iNews.png" });
            this.$updatePadCharacterRank("Ruben Drile", "Former President of Bien");
            this.$addInfoToPadCharacter("Ruben Drile", "Former President of Bien, ousted in uprising.");
            this.$addInfoToPadCharacter("Ruben Drile", "Stole 1.2 Billion credits from people.");
            this.$addInfoToPadCharacter("Ruben Drile", "Escaped offworld - with your help.");
        }

        if (deposed == "PART1_4" && missionVariables.depask == "DRILE" && system.scrambledPseudoRandomNumber(system.ID) < 0.3) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_part1_5", overlay: "deposed_GalCop.png", choicesKey: "deposed_galcop" },
                function (choice) {
                    if (choice == "YES") {
                        missionVariables.deposed = "PART1_5A";
                        mission.setInstructionsKey("deposed_desc3");
                        this.$markSystem(197);
                    }
                    if (choice == "NO") {
                        missionVariables.deposed = "PART1_6A";
                        missionVariables.depstat = "FUGITIVE";
                    }
                    missionVariables.depask = "ZSKTHAK";
                });
                
            this.$addPadLogEntry("Have been asked to report to GalCop Police in Dicebe. Not good.");
        }

        if (system.ID == 197 && deposed == "PART1_5") {
            var missionKey;
            if (missionVariables.depstat == "CLEAN") {
                missionKey = "deposed_part1_6c";
            } else {
                missionVariables.depstat = "CLEAN";
                missionKey = "deposed_part1_6o";
            }
            missionVariables.deposed = "PART1_6A";
            mission.runScreen({ title: "Deposed", screenID: "deposed", overlay: "deposed_GalCop.png", messageKey: missionKey });
            var amt = 5000;
            if (player.credits >= 5000) {
                player.credits -= 5000;
            } else {
                amt = player.credits;
                player.credits = 0;
            }
            this.$unmarkSystem(197);
            mission.setInstructionsKey(null);
            this.$addPadCharacter("rider");
            this.$addPadLogEntry("Had " + formatCredits(amt, false, true) + " of stolen funds taken back by Police.");
        }

        if (deposed == "PART1_6B") missionVariables.deposed = "PART1_6C";

        if (deposed == "PART1_6D") missionVariables.deposed = "PART1_6E";

        if (system.ID == 42 && deposed == "PART1_6") {
            // there is no hint leading to Zadige. Player has to remember old locations.
            mission.runScreen({ title: "Deposed", screenID: "deposed", overlay: "deposed_iNews.png", messageKey: "deposed_part1_7" });
            missionVariables.deposed = "PART1_8A";
        }

        if (deposed == "PART1_8E") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", overlay: "deposed_iNews.png", messageKey: "deposed_inews1" });
            missionVariables.deposed = "PART1_8EE";
        }

        if (deposed == "PART2" && missionVariables.depask == "ZSKTHAK" && system.ID > 149 && player.score > 1823) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate1", choicesKey: "deposed_esarqure" },
                function (choice) {
                    if (choice == "YES") {
                        missionVariables.deposed = "PIRATE1";
                        mission.setInstructionsKey("deposed2_desc1");
                        this.$markSystem(83);
                        missionVariables.depask = "SPIDERS";
                    }
                    if (choice == "NO") {
                        missionVariables.deposed = "ABANDONED";
                        this.$missionEnded(); // clear variables that are no longer needed.
                    }
                });
        }

        if (deposed == "PIRATE2" && missionVariables.depask == "SPIDERS" && missionVariables.depstat == "CLEAN") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_contactcops", choicesKey: "deposed_contact" },
                function (choice) {
                    if (choice == "YES") {
                        mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops1", overlay: "deposed_GalCop.png" })
                        worldScripts.deposed.$addPadCharacter("lalury");
                    }
                    if (choice == "NO") {
                        missionVariables.depstat = "FUGITIVE";
                    }
                });
            missionVariables.depask = "OFFWEGO";
            missionVariables.deposed = "PIRATE3";
        }

        if (deposed == "PIRATE3" && system.ID == 83) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate2" });
            missionVariables.deposed = "PIRATE4";
            this.$addPadCharacter("zskthak");
            this.$addPadLogEntry("Need to eliminate some Peldorian ships in Edorqu.");
        }

        if (deposed == "PIRATE4" && system.ID == 83) {
            if (missionVariables.depstat == "CLEAN") {
                // Give the clean player a hint.
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops2", overlay: "deposed_GalCop.png" });
            }
            missionVariables.deposed = "PIRATE5";
            missionVariables.depblk1 = "BLACK";
            missionVariables.depblk2 = "BLACK";
            missionVariables.depblk3 = "BLACK";
            this.$unmarkSystem(83);
            this.$markSystem(10);
            mission.setInstructionsKey("deposed2_desc2");
        }

        if (deposed == "PIRATE5" && missionVariables.depblk1 == "DESTROYED" && missionVariables.depblk2 == "DESTROYED" && missionVariables.depblk3 == "DESTROYED") {
            this.$addPadLogEntry("Destroyed the Peldorian pirates in Edorqu.");
            this.$markSystem(83);
            mission.setInstructionsKey("deposed2_desc2b");
            if (missionVariables.depstat == "CLEAN") {
                // Give the clean player a hint.
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops3", overlay: "deposed_GalCop.png" });
            }
            missionVariables.deposed = "PIRATE7";
        }

        if (deposed == "PIRATE7" && system.ID == 83) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate3" });
            missionVariables.deposed = "PIRATE8";
            this.$unmarkSystem(83);
            mission.setInstructionsKey(null);
            player.credits += 9000;
        }

        if (deposed == "PIRATE8") {
            if (missionVariables.depstat == "CLEAN" && system.ID == 83) {
                // Give the clean player a hint.
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops4", overlay: "deposed_GalCop.png" });
                missionVariables.deposed = "PIRATE8_1";
            }
            if (missionVariables.depstat == "FUGITIVE") {
                missionVariables.deposed = "PIRATE8_1";
            }
        }

        if (deposed == "PIRATE8E") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_inews2", overlay: "deposed_iNews.png" });
            missionVariables.deposed = "PIRATE8EE";
        }

        if (deposed == "PIRATE9" && system.ID < 255) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate4" });
            missionVariables.deposed = "PIRATE10";
            this.$markSystem(255);
            mission.setInstructionsKey("deposed2_desc3");
            missionVariables.deptaran = "ALIVE";
        }

        if (deposed == "PIRATE10") {
            if (missionVariables.depstat == "CLEAN" && system.ID < 255) {
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops5", overlay: "deposed_GalCop.png" });
                missionVariables.deposed = "PIRATE11";
            }
            if (missionVariables.depstat == "FUGITIVE") {
                missionVariables.deposed = "PIRATE11";
            }
        }

        if (deposed == "PIRATE11" && system.ID == 83 && missionVariables.deptaran == "DEAD") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate5" });
            missionVariables.deposed = "PIRATE12";
            this.$unmarkSystem(83);
            player.credits += 5000;
            mission.setInstructionsKey(null);
            missionVariables.deptaran = null;
        }

        if (deposed == "PIRATE12") {
            if (missionVariables.depstat == "CLEAN") {
                // hint for clean players
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops6", overlay: "deposed_GalCop.png" });
            }
            missionVariables.deposed = "PIRATE13";
        }

        if (deposed == "PIRATE13A") {
            missionVariables.deposed = "PIRATE13B";
        }

        if (deposed == "PIRATE13C") {
            missionVariables.deposed = "PIRATE13D";
        }

        if (deposed == "PIRATE13E") {
            missionVariables.deposed = "PIRATE13F";
        }

        if (deposed == "PIRATE14") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate6" });
            missionVariables.deposed = "PIRATE15";
            this.$markSystem(111);
            mission.setInstructionsKey("deposed2_desc4");
            missionVariables.depdrug = "ALIVE";
        }

        if (deposed == "PIRATE15") {
            if (missionVariables.depstat == "CLEAN") {
                // hint for clean players
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops7", overlay: "deposed_GalCop.png" });
                missionVariables.deposed = "PIRATE11";
            }
            missionVariables.deposed = "PIRATE16";
        }

        if (deposed == "PIRATE16" && missionVariables.depdrug == "DESTROYED") {
            missionVariables.deposed = "PIRATE17";
            deposed = "PIRATE17";
            missionVariables.depdrug = null;
        }

        if (deposed == "PIRATE17" && system.ID == 83) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate7" });
            missionVariables.deposed = "PIRATE18";
            this.$unmarkSystem(83);
            mission.setInstructionsKey(null);
            player.credits += 10000;
        }

        if (deposed == "PIRATE18") {
            if (missionVariables.depstat == "CLEAN") {
                // hint for clean players
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops8", overlay: "deposed_GalCop.png" });
            }
            missionVariables.deposed = "PIRATE19";
        }

        if (deposed == "PIRATE20" && system.ID != 83 && system.scrambledPseudoRandomNumber(system.ID) > 0.7) {  // this also excludes offering at the target system no83.
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate8" });
            missionVariables.deposed = "PIRATE21";
            this.$markSystem(83);
        }

        if (deposed == "PIRATE21" && system.ID == 83) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate9" });
            missionVariables.deposed = "PIRATE22";
            this.$unmarkSystem(83);
            this.$markSystem(138);
            mission.setInstructionsKey("deposed2_desc5");
            player.credits += 5000;
        }

        if (deposed == "PIRATE22") {
            if (missionVariables.depstat == "CLEAN") {
                // hint for clean players
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops9", overlay: "deposed_GalCop.png" });
            }
            missionVariables.deposed = "PIRATE23";
        }

        if (deposed == "PIRATE23") {
            if (!missionVariables.nova && missionVariables.deposed_started == "YES") {
                // Allow the native Oolite nova mission from now on.
                missionVariables.novacount = 2;
                missionVariables.deposed_started = "NOVACHANCE";
            }
            if (system.ID == 138) {
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate10" });
                missionVariables.deposed = "PIRATE24";
                mission.setInstructionsKey("deposed2_desc5b");
                this.$unmarkSystem(138);
            }
        }

        if (missionVariables.nova_deposed_bug == "YES") {
            // One of the key systems is a nova system, so there is no solution for the mission.
            // tell this the player.
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "nova_deposed_newsflash", overlay: "solar.png" });
            missionVariables.nova_deposed_bug = null;
        }

    }

    if (player.ship.dockedStation.isMainStation && galaxyNumber == 4) {

        if (deposed == "PIRATE23" && missionVariables.deposed_started == "NOVACHANCE" && missionVariables.nova == "NOVA_HERO") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_pirate9" });
            this.$markSystem(70);
            missionVariables.deposed = "PIRATE25";
        }

        if (deposed == "PIRATE25" && system.ID == 70) {
            missionVariables.deposed = "PIRATE26";
            this.$unmarkSystem(70);
            mission.setInstructionsKey(null);
            var messageKey = (missionVariables.deposed_started == "NOVA_HAPPENED" ? "deposed2_delivery2" : "deposed2_delivery1");
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: messageKey });
            player.credits += 5000;
        }

        if (deposed == "PIRATE26") {
            if (missionVariables.depstat == "CLEAN") {
                // hint for clean players
                mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed2_cops10", overlay: "deposed_GalCop.png" });
                worldScripts.deposed.$addPadCharacter("dreewok");
            }
            missionVariables.deposed = "PIRATE27";
        }

        if (deposed == "PIRATE28") {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_inews3", overlay: "deposed_iNews.png" });
            missionVariables.deposed = "PIRATE29";
        }

        if (deposed == "PIRATE29" && system.scrambledPseudoRandomNumber(system.ID) < 0.1) {
            mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: "deposed_inews_the_end", overlay: "deposed_iNews.png" });
            missionVariables.deposed = "MISSION_COMPLETE";
            this.$missionEnded(); // clear variables that are no longer needed.
        }
    }

    if (this.firstLaunch && (galaxyNumber == 3 || galaxyNumber == 4)) {
        this.$addShips();
        this.firstLaunch = false;
    }
    this.log_variables_to_log("missionScreenOpportunity")
};

//-------------------------------------------------------------------------------------------------------------
this.log_variables_to_log = function (from) {
    if (!this._logging) return;
    log(this.name, "============================================");
    log(this.name, "Source = " + from);
    log(this.name, "============================================");
    log(this.name, "MV.deposed           = " + missionVariables.deposed);
    log(this.name, "MV.depask            = " + missionVariables.depask);
    log(this.name, "MV.depbien           = " + missionVariables.depbien);
    log(this.name, "MV.depstat           = " + missionVariables.depstat);
    log(this.name, "MV.depblk1           = " + missionVariables.depblk1);
    log(this.name, "MV.depblk2           = " + missionVariables.depblk2);
    log(this.name, "MV.depblk3           = " + missionVariables.depblk3);
    log(this.name, "MV.deptaran          = " + missionVariables.deptaran);
    log(this.name, "MV.depdrug           = " + missionVariables.depdrug);
    log(this.name, "MW.nova_deposed_bug  = " + missionVariables.nova_deposed_bug);
    log(this.name, "MV.deposed_started   = " + missionVariables.deposed_started);
}

//-------------------------------------------------------------------------------------------------------------
this.shipLaunchedFromStation = function (station) {
    if (galaxyNumber == 3 && system.ID == 11 && missionVariables.deposed == "PIRATE11" && missionVariables.depbien == "BUGGERED") {
        // ******* change this to only happen once
        system.addShips("bienfighter", 6, station.position, 10000);
    }
};

//-------------------------------------------------------------------------------------------------------------
this.shipExitedWitchspace = function () {
    if (galaxyNumber < 3 || galaxyNumber > 4 || system.isInterstellarSpace) return;
    var deposed = missionVariables.deposed;
    if (galaxyNumber == 3) {
        // Next lines are very inefficient delays, but needed to stay compatible with old save games by the legacy script version.
        if (deposed == "PART1_4A") missionVariables.deposed = "PART1_4";
        if (deposed == "PART1_5A") missionVariables.deposed = "PART1_5";
        if (deposed == "PART1_6A") missionVariables.deposed = "PART1_6B";
        if (deposed == "PART1_6C") missionVariables.deposed = "PART1_6D";
        if (deposed == "PART1_6E") missionVariables.deposed = "PART1_6";
        if (deposed == "PART1_8G") missionVariables.deposed = "PART2";
        if (deposed == "PART1_8F") missionVariables.deposed = "PART1_8G";
        if (deposed == "PART1_8EE") missionVariables.deposed = "PART1_8F";
        if (deposed == "PART1_8D") missionVariables.deposed = "PART1_8E";
        if (deposed == "PART1_8C") missionVariables.deposed = "PART1_8D";
        if (deposed == "PART1_8B") missionVariables.deposed = "PART1_8C";
        if (deposed == "PART1_8A") missionVariables.deposed = "PART1_8B";
        if (deposed == "PIRATE1") missionVariables.deposed = "PIRATE2";
        if (deposed == "PIRATE8G") missionVariables.deposed = "PIRATE9";
        if (deposed == "PIRATE8F") missionVariables.deposed = "PIRATE8G";
        if (deposed == "PIRATE8EE") missionVariables.deposed = "PIRATE8F";
        if (deposed == "PIRATE8D") missionVariables.deposed = "PIRATE8E";
        if (deposed == "PIRATE8C") missionVariables.deposed = "PIRATE8D";
        if (deposed == "PIRATE8B") missionVariables.deposed = "PIRATE8C";
        if (deposed == "PIRATE8A") missionVariables.deposed = "PIRATE8B";
        if (deposed == "PIRATE8_1") missionVariables.deposed = "PIRATE8A";
        if (deposed == "PIRATE13") missionVariables.deposed = "PIRATE13A";
        if (deposed == "PIRATE13B") missionVariables.deposed = "PIRATE13C";
        if (deposed == "PIRATE13D") missionVariables.deposed = "PIRATE13E";
        if (deposed == "PIRATE13F") missionVariables.deposed = "PIRATE14";
        if (deposed == "PIRATE19A") missionVariables.deposed = "PIRATE20";
        if (deposed == "PIRATE19") missionVariables.deposed = "PIRATE19A";

        if (system.sun && system.sun.hasGoneNova && [11, 30, 42, 43, 49, 54, 75, 83, 111, 119, 138, 255].indexOf(system.ID) > -1) {
            // one of the mission systems is a nova system.
            missionVariables.nova_deposed_bug == "YES";
        }
        if (!missionVariables.nova && missionVariables.deposed_started == "YES") {
            missionVariables.novacount = 0; // suppress the nova mission.
        }
    }

    if (galaxyNumber == 4) {
        if (deposed == "PIRATE27C") missionVariables.deposed = "PIRATE28";
        if (deposed == "PIRATE27B") missionVariables.deposed = "PIRATE27C";
        if (deposed == "PIRATE27A") missionVariables.deposed = "PIRATE27B";
        if (deposed == "PIRATE27") missionVariables.deposed = "PIRATE27A";
    }

    this.$addShips();
    this.log_variables_to_log("shipExitedWitchspace");
};

//-------------------------------------------------------------------------------------------------------------
this.playerEnteredNewGalaxy = function (galaxy) {
    if (galaxy == 4) {
        var deposed = missionVariables.deposed;
        if (deposed == "PIRATE23" && missionVariables.deposed_started == "NOVACHANCE" && missionVariables.nova == "NOVA_HERO") {
            // mission was interrupted by the nova mission without change to pick up the passenger from Usesri. Add one extra message on the next docking.
            this.$markSystem(70);
            mission.setInstructionsKey("deposed2_desc6b");
            missionVariables.deposed_started = "NOVA_HAPPENED"
        }

        if (deposed == "PIRATE24") {
            mission.setInstructionsKey("deposed2_desc6");
            this.$markSystem(70);
            missionVariables.deposed = "PIRATE25";
        }
    }
    this.log_variables_to_log("playerEnteredNewGalaxy");
}

//-------------------------------------------------------------------------------------------------------------
this.$searchPeldorianShips = function () {
    var messageKey = "deposed2_any_system";
    if (system.ID == 10) {
        messageKey = "deposed2_edorqu10";
    }
    if (system.ID == 30) {
        messageKey = "deposed2_atbitela30";
    }
    if (system.ID == 54) {
        messageKey = "deposed2_quisbe54";
    }
    if (system.ID == 95) {
        messageKey = "deposed2_zamaso95";
    }
    if (system.ID == 148) {
        messageKey = "deposed2_teisen148";
    }
    if (system.ID == 119) {
        messageKey = "deposed2_esisraan119";
    }
    if (system.ID == 34) {
        messageKey = "deposed2_lequteor34";
    }
    if (system.ID == 49) {
        messageKey = "deposed2_beesed49";
    }
    if (system.ID == 75) {
        messageKey = "deposed2_inve75";
    }
    if (missionVariables.depblk1 == "DESTROYED" && missionVariables.depblk2 == "DESTROYED" && missionVariables.depblk3 == "DESTROYED") {
        messageKey = "deposed2_blackwidowsdestroyed";
    }
    mission.runScreen({ title: "Deposed", screenID: "deposed", messageKey: messageKey });
}

//-------------------------------------------------------------------------------------------------------------
this.$addShips = function () {
    if (galaxyNumber == 3) {
        var deposed = missionVariables.deposed;
        if (system.ID == 30 && deposed == "PIRATE5") {
            if (missionVariables.depblk1 == "BLACK") system.addShipsToRoute("deposed-blackwidow1", 1, 0.1, "wp");
            if (missionVariables.depblk2 == "BLACK") system.addShipsToRoute("deposed-blackwidow2", 1, 0.1, "wp");
            if (missionVariables.depblk3 == "BLACK") system.addShipsToRoute("deposed-blackwidow3", 1, 0.1, "wp");
        }

        if (system.ID == 255 && deposed == "PIRATE11" && missionVariables.deptaran == "ALIVE") {
            // asps are now defined as escorts for the tarantula.
            system.addShipsToRoute("deposed-tarantula", 1, 0.01, "wp");
        }

        if (system.ID == 111 && deposed == "PIRATE16" && missionVariables.depdrug == "ALIVE") {
            var drugFactory = system.addShips("deposed-medical-drug-factory", 1, [0, 0, -200000], 1000)[0];
            var pirates = system.addShips("pirate", 15, [0, 0, -200000], 10000);
            system.addShips("asteroid", 20, [0, 0, -200000], 10000);
            drugFactory.group = new ShipGroup("Peldorian Clan", drugFactory);

            // Now add the pirates to the factory group so the factory can signal for help.
            // don't add the group to each individual pirate, so you still can kill them individually.
            for (var i = 0; i < pirates.length; i++) {
                drugFactory.group.addShip(pirates[i]);
            }
        }

        if (system.ID == 11 && missionVariables.depbien == "BUGGERED") {
            system.addShipsToRoute("bienfighter", 4, 0.05, "wp");
        }

        if (deposed == "PART1_1" || (deposed == "PART1_2" && system.ID != 42)) {
            var count = Math.floor(Math.random() * 6);  // 0 till 5;
            if (count) system.addGroupToRoute("bienfighter", count, Math.random(), "wp");

            if (deposed == "PART1_1" && count) {
                system.addShipsToRoute("bienfighter", count, 0.05, "wp");
            }
        }

        if (deposed == "PIRATE5" && system.mainStation) {
            // add hints at the main station
            system.mainStation.setInterface("Deposed",
                {
                    title: expandMissionText("deposed2_inquiries_title"),
                    category: "Inquiries",
                    summary: expandMissionText("deposed2_inquiries_body"),
                    callback: this.$searchPeldorianShips.bind(this)
                });
        }
    }
};

//-------------------------------------------------------------------------------------------------------------
this.$markSystem = function (ID) {
    mission.markSystem({
        system: ID,
        name: "deposed",
        markerColor: "redColor",
        markerScale: 1.1,
        markerShape: "MARKER_X"
    });
    missionVariables.deposedNewmarkers = "YES"; // added to deal with the legacy markers from an old saved game.
}

//-------------------------------------------------------------------------------------------------------------
this.$unmarkSystem = function (ID) {
    var ok = mission.unmarkSystem({
        system: ID,
        name: "deposed"
    });
    if (!ok && !missionVariables.deposedNewmarkers) mission.unmarkSystem(ID); // must be an old legacy marker.
}

//-------------------------------------------------------------------------------------------------------------
this.$missionEnded = function () {
    // clear all mission variables except the main one
    missionVariables.depbien = null;
    missionVariables.depask = null;
    missionVariables.depstat = null;
    missionVariables.depblk1 = null;
    missionVariables.depblk2 = null;
    missionVariables.depblk3 = null;
    missionVariables.deptaran = null;
    missionVariables.depdrug = null;
    missionVariables.deposed_started = null;
    missionVariables.deposedNewmarkers = null;
    this.$clearHandlers();
};

//-------------------------------------------------------------------------------------------------------------
this.$clearHandlers = function () {
    delete this.missionScreenOpportunity;
    delete this.shipLaunchedFromStation;
    delete this.shipWillDockWithStation;
    delete this.shipExitedWitchspace;
    delete this.missionScreenOpportunity;
    delete this.guiScreenChanged;
    delete this.playerEnteredNewGalaxy;
    delete this.shipWillLaunchFromStation;
    delete this.shipWillDockWithStation;
    delete this.shipWillEnterWitchspace;
};

//-------------------------------------------------------------------------------------------------------------
this.$updatePadCharacterRank = function (person, rank) {
    var pad = worldScripts.Lib_PAD;
    if (!pad) return;

    if (!missionVariables.deposed_padchars_update) {
        missionVariables.deposed_padchars_update = {};
    }
    missionVariables.deposed_padchars_update["person"] = rank;

    var id = person.split(" ")[0].toUpperCase() + (person.indexOf(" ") >= 0 ? " " + person.split(" ")[1].toUpperCase() : "");

    pad.$data.PERSONS[id].rank = rank;
}

//-------------------------------------------------------------------------------------------------------------
this.$addPadCharacter = function (person) {
    var pad = worldScripts.Lib_PAD;
    if (!pad) return;

    var obj;
    if (!missionVariables.deposed_padchars) {
        missionVariables.deposed_padchars = [];
    }
    if (missionVariables.deposed_padchars.indexOf(person) == -1) missionVariables.deposed_padchars.push(person);
    switch (person) {
        case "dreewok":
            obj = {name:"Dreewok", rank:"Commissioner", gender:"Male", origin:"Unknown", species:"Unknown", t2:12};
            break;
        case "drile":
            obj = {name:"Ruben Drile", gender:"Male", t1:67};
            break;
        case "rider":
            obj = {name:"Lieutenant Rider", rank:"Lieutenant", gender:"Male", age:37, t1:11, t2:7};
            break;
        case "lalury":
            obj = {name:"Isabelle Lalury", rank:"Commissioner", gender:"Female", origin:"Unknown", species:"Unknown", t2:12};
            break;
        case "zskthak":
            obj = {name:"Zskthak", rank:"", origin:"Laqusoed", species:"Blue Horned Lobster", t1:84};
            break;
    }

    var dta = {};
    var cat = [];

    dta.name = obj.name;
    dta.origin = (obj.origin ? obj.origin : system.name);
    dta.species = (obj.species ? obj.species : system.info.inhabitant);
    dta.gender = (obj.gender ? obj.gender : (Math.random() > 0.5 ? "Male" : "Female"));
    dta.age = (obj.age ? obj.age : Math.floor(Math.random() * 30) + 40);
    dta.ship = (obj.ship ? obj.ship : "None");
    dta.rank = (obj.rank ? obj.rank : "");
    dta.t0 = (obj.t0 ? obj.t0 : (obj.rank != "" ? "lib_pad_org_galcop.png" : 0));
    dta.t1 = (obj.t1 && obj.t1 > 0 ? "lib_ovc" + (obj.t1 < 10 ? "0" : "") + obj.t1 + ".png" : "");
    dta.t2 = (obj.t2 && obj.t2 > 0 ? obj.t2 : 0);
    dta.info = [];
    if (obj.info) {
        for (var i = 0; i < obj.info.length; i++) {
            dta.info.push(obj.info[i]);
        }
    }
    cat.push("GALCOP.GENERIC");

    var id = "PERSONS." + (dta.rank && dta.rank != "" ? dta.rank.toUpperCase() : dta.name.split(" ")[0].toUpperCase()) + (dta.name.indexOf(" ") >= 0 ? " " + dta.name.split(" ")[1].toUpperCase() : "");
    log(this.name, "id = " + id);
    pad._addPageInCategory(id, dta, cat, false);
}

//-------------------------------------------------------------------------------------------------------------
this.$addInfoToPadCharacter = function (person, text) {
    var pad = worldScripts.Lib_PAD;
    if (!pad) return;

    if (!missionVariables.deposed_padchars_info) {
        missionVariables.deposed_padchars_info = {};
    }
    if (!missionVariables.deposed_padchars_info[person]) missionVariables.deposed_padchars_info[person] = [];
    if (missionVariables.deposed_padchars_info[person].indexOf(text) == -1) missionVariables.deposed_padchars_info[person].push(text);

    var id = "PERSONS." + (rank && rank != "" ? rank.toUpperCase() : person.split(" ")[0].toUpperCase()) + (person.indexOf(" ") >= 0 ? " " + person.split(" ")[1].toUpperCase() : "");
    worldScripts.Lib_PAD._setPageEntry(id + ".info", text);
}

//-------------------------------------------------------------------------------------------------------------
this.$addPadLogEntry = function (text) {
    var pad = worldScripts.Lib_PAD;
    if (!pad) return;
    pad._setPageEntry("LOGS.GENERIC.list", text);
}
