"use strict";
this.name = "deposed-blackwidow";
this.author = "eric walch";
this.description = "ship script for Deposed";
this.license = "CC-BY-NC-SA 3.0";

/*  The original ships had military aft lasers. But, with the original Oolite they only fired once
	during a fly-away run. They are now replaced with pulse lasers, that are still more dangerous
	than the military ones in the Oolite version during the original oxp development.
*/

this.shipSpawned = function () {
	if (player.score < 2560) {
		// Make the mission easier for players when less than Deadly
		// Minimum score to start this part of the mission is 1823
		this.ship.removeEquipment("EQ_SHIELD_ENHANCER");
	}
	if (this.ship.accuracy < 0) this.ship.accuracy *= -1; // exclude the stupid versions.
};


this.shipDied = function () {
	// don't check who killed the ship.
	if (this.ship.primaryRole == "deposed-blackwidow1") missionVariables.depblk1 = "DESTROYED";
	if (this.ship.primaryRole == "deposed-blackwidow2") missionVariables.depblk2 = "DESTROYED";
	if (this.ship.primaryRole == "deposed-blackwidow3") missionVariables.depblk3 = "DESTROYED";

	if (missionVariables.depblk1 == "DESTROYED"
		&& missionVariables.depblk2 == "DESTROYED"
		&& missionVariables.depblk3 == "DESTROYED") {
		mission.setInstructionsKey("deposed2_desc2b", "deposed");
		worldScripts.deposed.$markSystem(83);
		worldScripts.deposed.$unmarkSystem(10);
	}
};

