"use strict";
this.name = "Laser Reflector Shield";
this.author = "Reval";
this.license = "CC-BY-NC-SA 4.0";
this.version = "1.0";
this.description = "Lasers are photons = light. A mirror reflects light. The Guild long ago used this simple precept to develop a defensive force-field to achieve precisely this: Reflect and throw back an attacking ship's laser rays to their source. Results are as you might expect: 'No... NO... NO!...!!'";


this.shipDockedWithStation = function(station) {
	// prepare Hits-options interfaces page	
	this._lrPrepOpt(station);
}


this.shipWillLaunchFromStation = function() {
	var ps = player.ship;
	this.$lrHasEQ = (ps.equipmentStatus ("EQ_LRS") === "EQUIPMENT_OK");
}


this.playerBoughtEquipment = function(equipment, paid) {
	var pc = player.consoleMessage;
	if (equipment == "EQ_LRS") {		
		pc("Laser Reflector Shield circuitry connected and functioning.",9);
	} else
	// LRS removal and refund
	if (equipment == "EQ_LRS_REM") {
		player.ship.removeEquipment("EQ_LRS");
		player.ship.removeEquipment("EQ_LRS_REM");
		pc("Laser Reflector Shields disconnected and removed. Half refund.",9);
		player.credits += this.$lrCost / 2;
	}
}


this._lrGetRandomInt = function(min, max) {
  return Math.floor(Math.random() * (max - min + 1)) + min;
}


this.shipBeingAttacked = function(whom) {
	if (this.$lrHasEQ) { 
		this.$lrLastAttacker = this.$lrAttacker;
		this.$lrAttacker = whom;
		if (this.$lrAttacker != this.$lrLastAttacker) {
			this.$lrHits = 0;
			this.$lrAllowedHits=this._lrGetRandomInt(2,this.$lrMaxHits); 
		}
	this.$lrHits++;
	}
}


this.shipTakingDamage = function() {
	
	if (this.$lrAttacker != null) {
		var ps = player.ship;
		var d = ps.damageAssessment();
		var pcm = player.consoleMessage;
		// Attackers explode only if the player's ship has weapons _offline_
		// (Weapons online deactivates the G.E.T. Laser-reflector Shields.)
		if ((d >= 2 ) && (!ps.weaponsOnline) && (this.$lrHits>=this.$lrAllowedHits)) {
			this.$lrAttacker.commsMessage("No... NO... NO!...!!");
			this.$lrAttacker.explode();
			player.score ++;
		} else { 
			this.$lrAttacker.throwSpark();
			// TEST
			if (this.$lrTesting) pcm("HIT "+this.$lrHits);
		}	
	}
}



this.playerWillSaveGame = function(message) {
	missionVariables.lrMaxHits = this.$lrMaxHits;
}


this.startUpComplete = function () {
	if (missionVariables.lrMaxHits != null) 
		this.$lrMaxHits = missionVariables.lrMaxHits;
	// prepare Hits-options interfaces page	
	// this._lrPrepOpt(station);
}


this.startUp = function() {
	this.$lrConds = ["DOCKED","GREEN","YELLOW","RED"];
	this.$lrTesting = false;
	this.$lrHasEQ = false;
	this.$lrCost = 1500;
	// maximum number of laser hits before 'No...No!...N0!...!!'
	this.$lrMaxHits = 8;
}



// create LRS 'Hits Options' page 
this._lrPrepOpt = function(station) {
	station.setInterface("lrOpt",{
	title: "Your Laser Reflector Shield Options",
	category: "FE Shipyards",
	summary: "FE Shipyards offers you these choices regarding how many laser blasts must hit you before 'No... No!...NO!!...!!'",
	callback: this._lrShowOpt.bind(this)
	});	
}


// Offer Options for maximum number of Hits
this._lrShowOpt = function() {
		
	var parameters = new Object();
	var pc = player.commsMessage;
	
	parameters.title = "FE Shipyards";
	
	parameters.message = "Dear customer, \n\n";
	
	parameters.message +="FE Shipyards is pleased to offer you these options as to the maximum number of laser blasts that must hit your ship before 'No... No!... NO!!...!!' \n\n"; 
	
	parameters.choicesKey = "lrOptions";
	
	mission.runScreen(parameters, callback);	

	function callback(choice) {
		
		if (choice === "0_ONE") this.$lrMaxHits=1; else 
		if (choice === "1_TWO")  this.$lrMaxHits=2; else
		if (choice === "2_FOUR")  this.$lrMaxHits=4; else
		if (choice === "3_SIX")this.$lrMaxHits=6; else
		if (choice === "4_EIGHT") this.$lrMaxHits=8; else
		if (choice === "5_TEN") this.$lrMaxHits=10; else
		if (choice === "6_TWELVE")  this.$lrMaxHits=12;
			
		pc("FE Shipyards notes your preference for "+this.$lrMaxHits+" Hits.");
	}
}
