"use strict";
this.name = "in-system_taxi_equipment";
this.author = "spara";
this.copyright = "2013-2014 Mika Spåra";
this.licence = "CC BY-NC-SA 3.0";
this.description = "Equipment to accept delivery jobs";
this.version = "1.3";

//accept or cancel offers with n
this.activated = function () {
	if (worldScripts["in-system_taxi"].$currentOffer[0] == 1) {
		worldScripts["in-system_taxi"].$acceptOffer();
	}
	else if (worldScripts["in-system_taxi"].$currentOffer[0] == 2) {
		worldScripts["in-system_taxi"].$cancelContract();
	}
	else {
		worldScripts["in-system_taxi"].$commsMessage(expandDescription("[taxi_no_contract]"));
	}
}

//start or stop receiving offers with b
this.mode = function () {
	if (!worldScripts["in-system_taxi"].$taxiAvailable) {
		player.consoleMessage(expandDescription("[taxi_available]"));
		worldScripts["in-system_taxi"].$taxiAvailable = true;
		if (!worldScripts["in-system_taxi"].$startOfferTimer()) {
			worldScripts["in-system_taxi"].$taxiAvailable = false;
			player.consoleMessage(expandDescription("[taxi_unavailable]"));
		}
	}
	else {
		player.consoleMessage(expandDescription("[taxi_unavailable]"));
		worldScripts["in-system_taxi"].$taxiAvailable = false;
		worldScripts["in-system_taxi"].$stopInFlightTimer();
	}
}

//equipment restiction. Need passenger berth to buy.
this.allowAwardEquipment = function (eqKey, ship, context) {
	if (eqKey == "EQ_IN_SYSTEM_TAXI_LICENCE" && player.ship.passengerCapacity == 0)
		return false;
	if (worldScripts.taxi_galactica_main) {
		if (player.ship.dockedStation.hasRole("taxi_station")) {
			return true;
		}
	}
	else if (player.ship.dockedStation.isMainStation)
		return true;
	else
		return false;
}
