"use strict";

// worldScripts.world_builder_menu

this.name = "world_builder_menu";

/* ========================================================
	DEFINITIONS OF ALL THE SHORT-CUT MENUS

 You can re-arrange and re-name the menus however you like,
 subject to the following restrictions:
 - world_builder is the starting page, and must exist.
 - LAYER, OWNER and READONLY are special, and cannot be re-named.
 - All oher menus are arbitrary, and may be altered to taste.
 - a background image (in PNG format) should exist for each menu.
 - ensure this script is active (check Config/world-scripts.plist).
=========================================================== */

this._menuItems = {
    world_builder: [
        "Enter the property to change (case-sensitive), or enter 'HELP'. Below are some of the available properties:",
        "name",
        "economy",
        "economy_description",
        "government",
        "government_description",
        "techlevel",
        "population",
        "population_description",
        "inhabitants",
        "productivity",
        "radius",
        "description"
    ],
    LAYER: [ // This menu is exceptional: header comment is last item, instead of first - this is deliberate.
        "DEFAULT",
        "STATIC",
        "DYNAMIC",
        "PRIORITY",
        "Enter the layer at which system information over-rides should take effect. Only enter a number, not a word:"
    ],
    OWNER: [
        "Enter the oolite_manifest_identifier (case-sensitive) of a currently loaded OXP. Below are some recently used:",
        "oolite.oxp.Wildeblood.World_Builder",
        "oolite.oxp.Wildeblood.Thargoidifier",
        "oolite.oxp.Wildeblood.Lost_In_Space",
        "oolite.oxp.Wildeblood.Dynooverse",
        "oolite.oxp.Wildeblood.Witches_of_Middlemap",
        "org.oolite.oolite.debug"
    ],
    HELP: [
        "Enter a keyword (ALL-CAPS) for a menu of relevant properties to change:",
        "PEOPLE",
        "PLANET",
        "ATMOSPHERE",
        "SKY",
        "STATION",
        "SUN",
        "READONLY"
    ],
    EXPERT: [
        "Enter a keyword (ALL-CAPS) for a menu of relevant properties to change:",
        "EXTRAS",
        "LAYER",
        "OWNER",
        "SYSTEM",
        "READONLY"
    ],
    PEOPLE: [
        "Enter any property to change (case-sensitive). Below are some of the available properties:",
        "description",
        "economy",
        "economy_description",
        "government",
        "government_description",
        "inhabitant",
        "inhabitants",
        "name",
        "population",
        "population_description",
        "productivity",
        "techlevel"
    ],
    PLANET: [
        "Enter any property to change (case-sensitive). Below are SOME of the planet-related properties:",
        "illumination_color",
        "land_color",
        "land_fraction",
        "planet_distance",
        "planet_distance_multiplier",
        "polar_land_color",
        "polar_sea_color",
        "radius",
        "rotational_velocity",
        "rotation_speed",
        "rotation_speed_factor",
        "sea_color",
        "terminator_threshold_vector",
        "texture",
        "texture_hsb_color",
        "texture_normspec"
    ],
    ATMOSPHERE: [
        "Enter any property to change (case-sensitive). Below are SOME of the atmosphere-related properties:",
        "air_color",
        "air_color_mix_ratio",
        "air_density",
        "atmosphere_rotational_velocity",
        "cloud_alpha",
        "cloud_color",
        "cloud_fraction",
        "has_atmosphere",
        "polar_cloud_color"
    ],
    EXTRAS: [
        "Enter any property to change (case-sensitive). Below are some extra planet-related properties:",
        "planet_distance_multiplier",
        "planet_name",
        "rotational_velocity",
        "rotation_speed_factor",
        "texture",
        "texture_hsb_color",
        "texture_normspec"
    ],
    SKY: [
        "Enter any property to change (case-sensitive). Below are all the sky-related properties:",
        "ambient_level",
        "nebula_color_1",
        "nebula_color_2",
        "nebula_count_multiplier",
        "sky_blur_alpha",
        "sky_blur_cluster_chance",
        "sky_blur_scale",
        "sky_color_1",
        "sky_color_2",
        "sky_n_blurs",
        "sky_n_stars",
        "sky_rgb_colors",
        "star_count_multiplier"
    ],
    STATION: [
        "Enter any property to change (case-sensitive). Below are all the station-related properties:",
        "market_script",
        "station",
        "station_roll",
        "station_vector",
        "stations_require_docking_clearance"
    ],
    SUN: [
        "Enter any property to change (case-sensitive). Below are all the sun-related properties:",
        "corona_flare",
        "corona_hues",
        "corona_shimmer",
        "sun_color",
        "sun_distance",
        "sun_distance_modifier",
        "sun_distance_multiplier",
        "sun_gone_nova",
        "sun_name",
        "sun_radius",
        "sun_vector"
    ],
    SYSTEM: [
        "Enter any property to change (case-sensitive). Below are some system-related properties:",
        "concealment",
        "populator",
        "random_seed",
        "repopulator"
    ],
    READONLY: [
        "View read-only properties by selecting an option below:",
        "coordinates",
        "galaxyID",
        "systemID",
        "visits",
        "sun_gone_nova"
    ]
};

/* ========================================================
		THE END
=========================================================== */