"use strict";
this.name = "TCAT_thargoid";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Ship script for general Thargoid vessels";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.spawnedAsEscort = function (mother) {
	if (mother.isThargoid) {
		this.ship.switchAI("TCAT_escortAI.plist");
	}
}

//----------------------------------------------------------------------------------------
this.findNonThargoid = function () {
	if (this.ship.target) {
		this.ship.AIState = "ATTACK_SHIP";
		return;
	}

	function targetShips(entity) { return entity.isShip && !entity.docked && entity.scanClass != "CLASS_ROCK" && entity.scanClass != "CLASS_CARGO" && !entity.isThargoid && !entity.isCloaked && entity.primaryRole != "TCAT_jumpGate" };
	this.nearArray = system.filteredEntities(this, targetShips, this.ship, 25600);
	this.farArray = system.filteredEntities(this, targetShips, this.ship, 60000);

	if (this.nearArray.length > 0) {
		this.targetNumber = Math.floor(Math.random() * this.nearArray.length);
		if (this.targetNumber > this.nearArray.length) {
			log(this.name, "script error, target number too high - please report");
			this.targetNumber = 0;
		}
		this.ship.target = this.nearArray[this.targetNumber];
		this.ship.reactToAIMessage("TARGET_FOUND");
	} else {
		if (this.farArray.length > 0) {
			this.ship.target = this.farArray[0]; // set to the closest target off-scanner but in range
			this.ship.reactToAIMessage("INTERCEPT_TARGET");
		} else {
			this.ship.reactToAIMessage("FRUSTRATED")
		}
	}
}

//----------------------------------------------------------------------------------------
this.validateTarget = function () {
	if (this.ship.target && this.ship.target.scanClass != "CLASS_THARGOID" && !this.ship.target.hasRole("thargoid") && !this.ship.target.hasRole("thargon")) {
		this.ship.reactToAIMessage("TARGET_VALID");
	} else {
		this.ship.reactToAIMessage("TARGET_INVALID");
	}
}

//----------------------------------------------------------------------------------------
this.findStation = function () {
	this.stationArray = system.shipsWithPrimaryRole("TCAT_navyStation");
	if (this.stationArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		this.ship.target = this.stationArray[0];
		this.ship.reactToAIMessage("STATION_FOUND");
	}
}

//----------------------------------------------------------------------------------------
this.shipDied = function () {
	this.ship.commsMessage(expandDescription("[thargoid_curses]"));
}