"use strict";
this.name = "TCAT_sneak";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Ship script for Thargoid sneak courier.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.shipWasScooped = function (scooper) {
	if (scooper.isPlayer) {
		missionVariables.TCAT_sneakCount += 1;
		player.ship.manifest.alien_items += 1;
		player.consoleMessage(expandMissionText("TCAT_courier_caught"), 6);
		this.enoughData = (missionVariables.TCAT_sneakCount / 10) - 0.5; // chance of having enough data, from -0.5 to 1
		if (Math.random() < this.enoughData) { // if we've caught enough sneaks now
			player.consoleMessage(expandMissionText("TCAT_enough"), 10);
			missionVariables.TCAT_mission = "CAUGHT";
			mission.setInstructionsKey("TCAT_shortBackToBase", "TCAT_missionScript"); //  mission note to go back to base
		} else {
			mission.setInstructionsKey("TCAT_shortHideAndSeek", "TCAT_missionScript"); //  update the F5-F5 screen count
		}
	}
}

//----------------------------------------------------------------------------------------
this.shipExitedWormhole = function () {
	if (this.ship.escorts.length > 0) {
		for (var escortCounter = this.ship.escorts.length - 1; escortCounter >= 0; escortCounter--) {
			this.ship.escorts[escortCounter].remove();
		}
	}
	this.ship.remove();
}

//----------------------------------------------------------------------------------------
this.shipBeingAttacked = function () {
	this.shutDownChance = this.ship.energy / this.ship.maxEnergy;
	if (Math.random() > this.shutDownChance) {
		this.ship.AIState = "SHUTDOWN";
	}
}