"use strict";
this.name = "TCAT_raptor";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Raptor class ship script.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.shipSpawned = function () {
	if (!worldScripts["TCAT_masterScript"]) {
		log("TCAT Master Script Missing!");
	}
	if (this.ship.primaryRole == "TCAT_squadRaptor" || this.ship.primaryRole == "thargoid") {
		this.ship.primaryRole = "TCAT_raptor";
	}

	this.shipName = expandDescription('[TCAT_raptorName]');
	this.ship.displayName = "Raptor - ASF " + this.shipName;
	if (this.ship.hasRole("TCAT_squadRaptor")) {
		this.ship.displayName = expandMissionText("TCAT_raptorname", {name:this.ship.displayName});
	}

	this.jammerCount = 1 + Math.ceil(Math.random() * 3);
	this.clawCount = Math.floor(Math.random() * 3);
}

//----------------------------------------------------------------------------------------
this.dropJammer = function () {
	if (this.jammerCount > 0 && worldScripts["TCAT_masterScript"] && worldScripts["TCAT_masterScript"].jammerAllowed()) {
		this.ship.ejectItem("TCAT_jammer");
		this.jammerCount -= 1;
	}
}

//----------------------------------------------------------------------------------------
this.dropClaw = function () {
	if (this.clawCount > 0 && worldScripts["TCAT_masterScript"] && worldScripts["TCAT_masterScript"].clawAllowed()) {
		this.ship.ejectItem("TCAT_claw");
		this.clawCount -= 1;
	}
}

//----------------------------------------------------------------------------------------
this.locateThargoids = function () {
	this.alienArray = system.entitiesWithScanClass("CLASS_THARGOID");
	if (this.alienArray.length == 0) {
		this.ship.reactToAIMessage("NOTHING_FOUND");
	} else {
		this.ship.target = this.alienArray[0];
		this.ship.reactToAIMessage("TARGET_FOUND");
	}
}

//----------------------------------------------------------------------------------------
this.scanForAliens = function () {
	function allShips(entity) { return entity.isShip };
	function thargoidMotherships(entity) { return entity.hasRole("thargoid-mothership") && !entity.hasRole("TCAT_jumpGate") };
	function jammerMines(entity) { return entity.hasRole("TCAT_jammer") };
	function clawMines(entity) { return entity.hasRole("TCAT_claw") };
	function activeThargons(entity) { return entity.scanClass == "CLASS_THARGOID" && (entity.hasRole("thargon") || entity.hasRole("tharglet")) };

	var anyShips = system.filteredEntities(this, allShips, this.ship, 25600);
	this.thargoidCount = anyShips.filter(thargoidMotherships).length;
	this.thargonCount = anyShips.filter(activeThargons).length;
	this.jammerActive = anyShips.filter(jammerMines).length;
	this.clawActive = anyShips.filter(clawMines).length;

	if (this.jammerCount > 0 && this.jammerActive == 0 && this.thargonCount > 0 && Math.random() > (0.1 + (this.thargonCount * 0.15))) {
		this.dropJammer();
	}

	if (this.clawCount > 0 && this.clawActive == 0 && this.thargoidCount > 0 && Math.random() > (0.1 + (this.thargoidCount * 0.05))) {
		this.dropClaw();
	}

	if (this.thargoidCount > 0 && (!this.ship.target || (this.ship.target && !this.ship.target.scanClass == "CLASS_THARGOID"))) {
		this.ship.target = anyShips.filter(thargoidMotherships)[0];
		this.ship.AIState = "ATTACK_SHIP";
	}
}