"use strict";
this.name = "TCAT_navalStation";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "Naval station ship script.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.shipSpawned = function () {
	if (this.rechargeTimer) {
		this.rechargeTimer.start();
	} else {
		this.rechargeTimer = new Timer(this, this.rechargeStation, 0, 1);
	}
	this.squadsLaunched = 0;
}

//----------------------------------------------------------------------------------------
this.rechargeStation = function () {
	if (missionVariables.TCAT_mission != "ARMADA" && this.ship.energy < this.ship.maxEnergy) {
		this.ship.energy += 98;
	}

	if (missionVariables.TCAT_mission == "ARMADA" && this.squadsLaunched < 2 && Math.random() > ((this.ship.energy / this.ship.maxEnergy) + 0.4)) {
		this.ship.AIState = "LAUNCH_SQUAD";
		this.squadsLaunched++;
	}

	if (this.ship.missiles.length < this.ship.missileCapacity && Math.random() < ((this.ship.missileCapacity - this.ship.missiles.length) / (10 * this.ship.missileCapacity))) {
		this.ship.awardEquipment("EQ_TCAT_NPC_TRIDENT_MISSILE");
	}
}

//----------------------------------------------------------------------------------------
this.missileCheck = function () {
	if (this.ship.missiles.length > 0 && this.ship.target && Math.random() < ((this.ship.missileCapacity - this.ship.missiles.length) / (this.ship.missileCapacity))) {
		this.ship.fireMissile();
	}
}

//----------------------------------------------------------------------------------------
this.stationLaunchedShip = function (ship) {
	if (ship.isPlayer && missionVariables.TCAT_mission == "ARMADA") {
		this.ship.AIState = "LAUNCH_SQUAD";
		delete this.stationLaunchedShip;
	}
}

//----------------------------------------------------------------------------------------
this.shipDied = function () {
	missionVariables.TCAT_mission = "CASE_CLOSED";
	missionVariables.TCAT_navalStation = "DEAD";

	this.fuelCount = 35 + Math.ceil(Math.random() * 10);
	this.largeCount = 17 + Math.ceil(Math.random() * 3);
	this.smallCount = 35 + Math.ceil(Math.random() * 5);

	//system.legacy_addShipsWithinRadius("TCAT_burningFuel", this.fuelCount, "abs", this.ship.position, 10);
	system.addShips("TCAT_burningFuel", this.fuelCount, this.ship.position, 10);
	//system.legacy_addShipsWithinRadius("TCAT_smallWreckage", this.smallCount, "abs", this.ship.position, 5);
	system.addShips("TCAT_smallWreckage_navy", this.smallCount, this.ship.position, 5);
	//system.legacy_addShipsWithinRadius("TCAT_largeWreckage", this.largeCount, "abs", this.ship.position, 5);
	system.addShips("TCAT_largeWreckage_navy", this.largeCount, this.ship.position, 5);

	this.playerWillEnterWitchspace();
}

//----------------------------------------------------------------------------------------
this.playerWillEnterWitchspace = function () {
	if (this.rechargeTimer && this.rechargeTimer.isRunning) {
		this.rechargeTimer.stop();
	}
}