"use strict";
this.name = "TCAT_masterScript";
this.author = "Thargoid";
this.copyright = "Creative Commons: attribution, non-commercial, sharealike with clauses - see readme.txt";
this.description = "WorldScript for TCAT OXP.";
this.version = "2.0";

//----------------------------------------------------------------------------------------
this.shipExitedWitchspace = function () {
	if (missionVariables.TCAT_overRide == true || missionVariables.TCAT_mission == "HUNT") {
		return;
	}

	this.policeCount = system.entitiesWithScanClass("CLASS_POLICE").length + system.entitiesWithScanClass("CLASS_MILITARY").length;
	this.thargoidCount = system.entitiesWithScanClass("CLASS_THARGOID").length - system.countShipsWithRole("thargon");

	if (this.thargoidCount > 6 || Math.random() < ((this.thargoidCount - this.policeCount) / 10)) {
		//system.legacy_addShips("TCAT_squadRaptor", 1);
		system.addShips("TCAT_squadRaptor", 1);
		return;
	}

	if (this.thargoidCount > 3 || Math.random() < ((this.thargoidCount - this.policeCount) / 5)) {
		//system.legacy_addShips("TCAT_raptor", 1);
		system.addShips("TCAT_raptor", 1);
	}
}

//----------------------------------------------------------------------------------------
this.playerBoughtEquipment = function (equipment) { // swap freebies and dummy equipment for the real thing at naval intel station
	switch (equipment) {
		case "EQ_TCAT_DUMMY_MINE":
		case "EQ_TCAT_FREE_MINE":
			player.ship.removeEquipment("EQ_TCAT_DUMMY_MINE");
			player.ship.removeEquipment("EQ_TCAT_FREE_MINE");
			player.ship.awardEquipment("EQ_QC_MINE");
			break;

		case "EQ_TCAT_DUMMY_MISSILE":
		case "EQ_TCAT_FREE_MISSILE":
			player.ship.removeEquipment("EQ_TCAT_DUMMY_MISSILE");
			player.ship.removeEquipment("EQ_TCAT_FREE_MISSILE");
			player.ship.awardEquipment("EQ_HARDENED_MISSILE");
			break;

		case "EQ_TCAT_DUMMY_NEU":
			// as the mission can't run without Thargoid Plans being completed, the player must have access to this anyway.
			player.ship.removeEquipment("EQ_TCAT_DUMMY_NEU");
			if (player.ship.equipmentStatus("EQ_ENERGY_UNIT") != "EQUIPMENT_UNAVAILABLE") {
				player.ship.setEquipmentStatus("EQ_ENERGY_UNIT", "EQUIPMENT_OK");
				player.ship.removeEquipment("EQ_ENERGY_UNIT");
			}
			player.ship.awardEquipment("EQ_NAVAL_ENERGY_UNIT");
			break;

		case "EQ_TCAT_DUMMY_SHIELDS":
			player.ship.removeEquipment("EQ_TCAT_DUMMY_SHIELDS");
			player.ship.awardEquipment("EQ_NAVAL_SHIELD_BOOSTER");
			break;

		case "EQ_TCAT_CLEARPYLONS":
			player.ship.removeEquipment("EQ_TCAT_CLEARPYLONS");
			this.credits = player.credits;
			player.ship.awardEquipment("EQ_MISSILE_REMOVAL");
			player.credits = this.credits;
			break;

		case "EQ_TCAT_EU_UPGRADE":
		case "EQ_TCAT_EU_FIXGRADE":
			player.ship.removeEquipment("EQ_TCAT_EU_UPGRADE");
			player.ship.removeEquipment("EQ_ENERGY_UNIT");
			player.ship.awardEquipment("EQ_NAVAL_ENERGY_UNIT");

		case "EQ_TCAT_NEU_REPAIR":
			player.ship.removeEquipment("EQ_TCAT_NEU_REPAIR");
			player.ship.awardEquipment("EQ_NAVAL_ENERGY_UNIT");
	}
}

// Code below is used by ship scripts 

this.jammerTime = clock.absoluteSeconds // for use of spacing Raptor Jammer Mine launches by ship scripts to min of 60s. 
this.clawTime = clock.absoluteSeconds // for use of spacing Raptor Claw Mine launches by ship scripts to min of 120s. 
this.defenderTime = clock.absoluteSeconds // for use of spacing jumpgate defender launches by ship scripts to min of 20s. 

//----------------------------------------------------------------------------------------
this.jammerAllowed = function () {
	if ((clock.absoluteSeconds - this.jammerTime) > 60) {
		this.jammerTime = clock.absoluteSeconds;
		return true;
	} else {
		return false;
	}
}

//----------------------------------------------------------------------------------------
this.clawAllowed = function () {
	if ((clock.absoluteSeconds - this.clawTime) > 120) {
		this.clawTime = clock.absoluteSeconds;
		return true;
	} else {
		return false;
	}
}

//----------------------------------------------------------------------------------------
this.defenderAllowed = function () {
	if ((clock.absoluteSeconds - this.defenderTime) > 20) {
		this.defenderTime = clock.absoluteSeconds;
		return true;
	} else {
		return false;
	}
}